/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.util;

import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.ActionResult;
import de.fzj.unicore.xnjs.persistence.AbstractActionStore;
import de.fzj.unicore.xnjs.persistence.IActionStore;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.security.Client;
import eu.unicore.security.SecurityTokens;
import eu.unicore.security.Xlogin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;

public class UpdateInfo
implements Runnable {
    private final File restartDirectory;
    private final IActionStore store;
    private final String action;
    private final Configuration config;
    public static final String RESTART_DIR = "RESTART_DIRECTORY";
    public static final String ACTION_WRITE = "write";
    public static final String ACTION_READ = "read";
    private final JobDefinitionDocument jd;

    public UpdateInfo(Configuration config, String action) throws IOException {
        this.config = config;
        this.action = action;
        String restartP = this.config.getProperty(RESTART_DIR);
        File restartDirBase = new File(restartP);
        if (!restartDirBase.exists()) {
            throw new IOException("Restart information directory does not exist: " + restartP);
        }
        if (!restartDirBase.isDirectory()) {
            throw new IOException("Not a directory: " + restartP);
        }
        this.restartDirectory = new File(restartP, "JOBS");
        if (!this.restartDirectory.exists()) {
            this.restartDirectory.mkdir();
        }
        this.store = (AbstractActionStore)this.config.getActionStore("JOBS");
        try {
            this.jd = JobDefinitionDocument.Factory.newInstance();
            this.jd.addNewJobDefinition();
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void run() {
        if (ACTION_READ.equalsIgnoreCase(this.action)) {
            this.doUpdate();
        } else if (ACTION_WRITE.equalsIgnoreCase(this.action)) {
            try {
                this.doWrite();
            }
            catch (Exception ex) {
                throw new RuntimeException("Error writing restart info", ex);
            }
        } else {
            throw new RuntimeException("Unknown restart action: " + this.action);
        }
    }

    protected void doWrite() throws PersistenceException, IOException {
        System.out.println("Writing update information to " + this.restartDirectory.getAbsolutePath() + " ... ");
        for (String id : this.store.getUniqueIDs()) {
            Action a = this.store.get(id);
            this.writeUpdateInfo(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeUpdateInfo(Action a) throws IOException {
        File f = new File(this.restartDirectory, a.getUUID());
        Properties p = new Properties();
        System.out.println("Writing " + a.getUUID());
        p.setProperty("UUID", a.getUUID());
        if (a.getBSID() != null) {
            p.setProperty("BSID", a.getBSID());
        }
        p.setProperty("Type", a.getType());
        Client c = a.getClient();
        if (c != null) {
            p.setProperty("Client-DN", c.getDistinguishedName());
            Xlogin xl = c.getXlogin();
            if (xl != null) {
                p.setProperty("Client-Xlogin", xl.getUserName());
                if (xl.getGroup() != null) {
                    p.setProperty("Client-Group", xl.getGroup());
                }
                if (xl.getSelectedSupplementaryGroups() != null && xl.getSelectedSupplementaryGroups().length > 0) {
                    p.setProperty("Client-SupplementaryGroups", xl.getEncodedSelectedSupplementaryGroups());
                }
            }
            if (c.getVo() != null) {
                p.setProperty("Client-SelectedVO", c.getVo());
            }
        }
        List<String> log = a.getLog();
        int i = 0;
        for (String l : log) {
            p.setProperty("Log-" + i, l);
            ++i;
        }
        if (a.getResult() != null) {
            int code = a.getResult().getStatusCode();
            p.setProperty("Result-Code", String.valueOf(code));
            String msg = a.getResult().getErrorMessage();
            if (msg != null) {
                p.setProperty("Result-Message", msg);
            }
            if (a.getResult().isSuccessful()) {
                p.setProperty("Result-ExitCode", String.valueOf(a.getResult().getExitCode()));
            }
        }
        String jobName = null;
        if ("JSDL".equals(a.getType())) {
            try {
                JobDefinitionDocument jdd = (JobDefinitionDocument)a.getAjd();
                jobName = jdd.getJobDefinition().getJobDescription().getJobIdentification().getJobName();
            }
            catch (Exception ex) {
                try {
                    jobName = "Job " + a.getLog().get(0);
                }
                catch (Exception ex2) {
                    jobName = "Job saved at " + new Date();
                }
            }
        }
        p.setProperty("Job-Name", jobName);
        String comments = "XNJS activity info" + new Date();
        FileOutputStream fos = new FileOutputStream(f);
        try {
            p.store(fos, comments);
            fos.flush();
        }
        finally {
            fos.close();
        }
    }

    protected void doUpdate() {
        System.out.println("Reading restart information from " + this.restartDirectory.getAbsolutePath() + " ... ");
        try {
            for (File file : this.restartDirectory.listFiles()) {
                this.restoreAction(file);
            }
            this.store.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreAction(File restartInfo) throws IOException, PersistenceException {
        Action action = new Action();
        Properties p = new Properties();
        FileInputStream is = new FileInputStream(restartInfo);
        try {
            p.load(is);
        }
        finally {
            ((InputStream)is).close();
        }
        action.setUUID(p.getProperty("UUID"));
        String bsID = p.getProperty("BSID");
        if (bsID != null) {
            action.setBSID(bsID);
        }
        action.setType(p.getProperty("Type"));
        action.setStatus(7);
        System.out.println("Reading " + action.getUUID());
        String dn = p.getProperty("Client-DN");
        if (dn != null) {
            Client c = new Client();
            SecurityTokens secTokens = new SecurityTokens();
            secTokens.setUserName(X500NameUtils.getX500Principal((String)dn));
            secTokens.setConsignorTrusted(true);
            c.setAuthenticatedClient(secTokens);
            Xlogin xlogin = null;
            String userName = p.getProperty("Client-Xlogin");
            if (userName != null) {
                String group = p.getProperty("Client-Group");
                String supGroupsEncoded = p.getProperty("Client-SupplementaryGroups");
                String[] supGroups = supGroupsEncoded != null ? supGroupsEncoded.split(":") : new String[]{};
                if (group != null) {
                    String[] allGroups = Arrays.copyOf(supGroups, supGroups.length + 1);
                    allGroups[allGroups.length - 1] = group;
                    xlogin = new Xlogin(new String[]{userName}, allGroups);
                    xlogin.setSelectedGroup(group);
                    if (supGroupsEncoded != null) {
                        xlogin.setSelectedSupplementaryGroups(supGroups);
                    }
                } else {
                    xlogin = new Xlogin(new String[]{userName});
                }
                c.setXlogin(xlogin);
                String selectedVo = p.getProperty("Client-SelectedVO");
                if (selectedVo != null) {
                    c.setVo(selectedVo);
                }
            }
            action.setClient(c);
        }
        ArrayList<String> logkeys = new ArrayList<String>();
        for (Object oKey : p.keySet()) {
            String key = (String)oKey;
            if (!key.startsWith("Log-")) continue;
            logkeys.add(key);
        }
        Object[] logs = logkeys.toArray(new String[logkeys.size()]);
        Arrays.sort(logs);
        for (Object a : logs) {
            action.addLogTrace(p.getProperty((String)a));
        }
        String codeS = p.getProperty("Result-Code");
        if (codeS != null) {
            ActionResult result = new ActionResult();
            result.setStatusCode(Integer.valueOf(codeS));
            String msg = p.getProperty("Result-Message");
            if (msg != null) {
                result.setErrorMessage(msg);
            }
            if (result.isSuccessful()) {
                try {
                    int exitCode = Integer.valueOf(p.getProperty("Result-ExitCode"));
                    result.setExitCode(exitCode);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            action.setResult(result);
        }
        action.setAjd((Serializable)this.jd.copy());
        String jobName = p.getProperty("Job-Name", "Job restored at " + new Date());
        try {
            JobDefinitionDocument jdd = (JobDefinitionDocument)action.getAjd();
            jdd.getJobDefinition().addNewJobDescription().addNewJobIdentification().setJobName(jobName);
        }
        catch (Exception ex) {
            // empty catch block
        }
        action.setOriginalAjd((Serializable)action.getAjd());
        try {
            this.config.getExecutionContextMgr().getContext(action);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.store.put(action.getUUID(), action);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.out.println("Need three arguments : ");
            System.out.println(" 1) write|read ");
            System.out.println(" 2) path to xnjs config file");
            System.out.println(" 3) directory for storing data");
            System.exit(1);
        }
        String dir = args[2];
        String config = args[1];
        String action = args[0];
        Configuration c = new Configuration(new FileInputStream(new File(config)));
        c.init();
        c.setProperty("XNJS.numberofworkers", "0");
        c.setProperty(RESTART_DIR, dir);
        c.start();
        UpdateInfo u = new UpdateInfo(c, action);
        u.run();
        c.stop();
    }
}

