/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.util;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.ActionResult;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.tsi.TSI;
import de.fzj.unicore.xnjs.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;

public class ResultHolder {
    private final Action a;
    private final Configuration config;
    public static final int LIMIT = 256000;

    public ResultHolder(Action a, Configuration config) {
        this.config = config;
        this.a = a;
    }

    public void done() throws ExecutionException {
        this.config.getExecutionContextMgr().destroyUSpace(this.a);
    }

    public Integer getExitCode() {
        return this.a.getExecutionContext().getExitCode();
    }

    public ActionResult getResult() {
        return this.a.getResult();
    }

    public String getStdErr() throws IOException, ExecutionException {
        return this.readOutcomeFile(this.a.getExecutionContext().getStderr());
    }

    public InputStream getInputStream(String stream) throws IOException, ExecutionException {
        TSI tsi = this.config.getTargetSystemInterface(this.a.getClient());
        return tsi.getInputStream(stream);
    }

    public String readFile(String file) throws IOException, ExecutionException {
        String name = this.a.getExecutionContext().getWorkingDirectory() + "/" + file;
        return this.doReadFile(name);
    }

    public String readOutcomeFile(String file) throws IOException, ExecutionException {
        String name = this.a.getExecutionContext().getOutcomeDirectory() + "/" + file;
        return this.doReadFile(name);
    }

    public Action getAction() {
        return this.a;
    }

    private String doReadFile(String name) throws IOException, ExecutionException {
        TSI tsi = this.config.getTargetSystemInterface(this.a.getClient());
        return IOUtils.readTSIFile(tsi, name, 256000);
    }
}

