/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.util;

import de.fzj.unicore.xnjs.ems.Action;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;

public class LogUtil {
    public static final String XNJS = "unicore.xnjs";
    public static final String PERSISTENCE = "unicore.persistence";
    public static final String JOBS = "unicore.services.jobexecution";
    public static final String TSI = "unicore.xnjs.tsi";
    public static final String IO = "unicore.xnjs.io";

    private LogUtil() {
    }

    public static Logger getLogger(String prefix, Class<?> clazz) {
        return Logger.getLogger((String)(prefix + "." + clazz.getSimpleName()));
    }

    public static Logger getLogger(String prefix, String name) {
        return Logger.getLogger((String)(prefix + "." + name));
    }

    public static void logException(String message, Throwable cause) {
        LogUtil.logException(message, cause, Logger.getLogger((String)XNJS));
    }

    public static void logException(String message, Throwable cause, Logger logger) {
        logger.error((Object)message);
        if (cause != null) {
            logger.error((Object)("The root error was: " + LogUtil.getDetailMessage(cause)));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Stack trace", cause);
            } else {
                logger.error((Object)("To see the full error stack trace, set log4j.logger." + logger.getName() + "=DEBUG"));
            }
        }
    }

    public static String getDetailMessage(Throwable throwable) {
        StringBuilder sb = new StringBuilder();
        Throwable cause = throwable;
        String message = null;
        String type = null;
        type = cause.getClass().getName();
        do {
            type = cause.getClass().getName();
            message = cause.getMessage();
        } while ((cause = cause.getCause()) != null);
        sb.append(type).append(" ");
        if (message != null) {
            sb.append(message);
        } else {
            sb.append(" (no further message available)");
        }
        return sb.toString();
    }

    public static String createFaultMessage(String message, Throwable cause) {
        return message + ": " + LogUtil.getDetailMessage(cause);
    }

    public static void fillLogContext(Action a) {
        MDC.put((String)"jobID", (Object)a.getUUID());
        if (a.getClient() != null && a.getClient().getDistinguishedName() != null) {
            MDC.put((String)"clientName", (Object)a.getClient().getDistinguishedName());
        }
    }

    public static void clearLogContext() {
        MDC.remove((String)"jobID");
        MDC.remove((String)"clientName");
    }
}

