/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.util;

import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.simple.UsernamePassword;
import de.fzj.unicore.xnjs.tsi.TSI;
import eu.unicore.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class IOUtils {
    private static final boolean nonUnix = File.separatorChar != '/';
    private static final NumberFormat format = NumberFormat.getNumberInstance();

    public static boolean isNonUnix() {
        return nonUnix;
    }

    public static String md5String(MessageDigest digest) {
        byte[] messageDigest = digest.digest();
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < messageDigest.length; ++i) {
            String hex = Integer.toHexString(0xFF & messageDigest[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static String getRelativePath(String absolutePath, String root) {
        return IOUtils.getRelativePath(new File(absolutePath), root);
    }

    public String getFullPath(String root, String relativePath) {
        return null;
    }

    static List<String> getRelativePathList(File f, String root) {
        if (IOUtils.isNonUnix()) {
            return IOUtils.getRelativePathListNonUnix(f, root);
        }
        if (root.length() != 1 && root.endsWith("/")) {
            root = root.substring(0, root.lastIndexOf(47));
        }
        while (root.contains("//")) {
            root = root.replace("//", "/");
        }
        ArrayList<String> l = new ArrayList<String>();
        File r = f;
        int skip = 0;
        try {
            while (f != null && !root.equals(f.getPath())) {
                String name = f.getName();
                if ("..".equals(name)) {
                    ++skip;
                } else if (!".".equals(name)) {
                    if (skip > 0) {
                        --skip;
                    } else {
                        l.add(name);
                    }
                }
                f = f.getParentFile();
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid path: <" + r.getPath() + ">");
        }
        if (skip > 0) {
            throw new IllegalArgumentException("Invalid path: <" + r.getPath() + ">: too many '..'");
        }
        return l;
    }

    static List<String> getRelativePathListNonUnix(File f, String root) {
        int skip = 0;
        ArrayList<String> l = new ArrayList<String>();
        File r = f;
        try {
            File rootFile = new File(root).getCanonicalFile();
            for (f = f.getCanonicalFile(); f != null && !rootFile.getPath().equals(f.getPath()); f = f.getParentFile()) {
                String name = f.getName();
                if ("..".equals(name)) {
                    ++skip;
                    continue;
                }
                if (".".equals(name)) continue;
                if (skip > 0) {
                    --skip;
                    continue;
                }
                l.add(name);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        if (skip > 0) {
            throw new IllegalArgumentException("Invalid path: <" + r.getPath() + ">: too many '..'");
        }
        return l;
    }

    public static String getRelativePath(File f, String root) {
        List<String> list = IOUtils.getRelativePathList(f, root);
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            sb.insert(0, s);
            sb.insert(0, "/");
        }
        if (sb.length() == 0) {
            sb.append("/");
        }
        return sb.toString();
    }

    public static String md5(InputStream in) throws IOException {
        int len;
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ne) {
            throw new IOException("Algorithm MD5 not availble.");
        }
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) >= 0) {
            md5.update(buf, 0, len);
        }
        return IOUtils.md5String(md5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String md5(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            String string = IOUtils.md5(fis);
            return string;
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            IOUtils.copy(fis, os, 131072);
            String string = os.toString();
            return string;
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTSIFile(TSI tsi, String name, int limit) throws IOException, ExecutionException {
        InputStream is = null;
        try {
            is = tsi.getInputStream(name);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            IOUtils.copy(is, bos, limit);
            String string = bos.toString();
            return string;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public static void copy(InputStream is, OutputStream os, int limit) throws IOException {
        int c = 0;
        int total = 0;
        byte[] buf = new byte[8192];
        while ((c = is.read(buf)) != -1) {
            os.write(buf, 0, c);
            if ((total += c) <= limit) continue;
            os.write("***** length limit exceeded, result is truncated! ****".getBytes());
        }
    }

    public static String toString(InputStream is, int limit) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtils.copy(is, bos, limit);
        return bos.toString();
    }

    public static URL addFTPCredentials(URL original, UsernamePassword creds) {
        if (creds != null && creds.getUser() != null) {
            return IOUtils.addFTPCredentials(original, creds.getUser(), creds.getPassword());
        }
        return original;
    }

    public static URL addFTPCredentials(URL original, String user, String password) {
        try {
            int port = original.getPort();
            StringBuilder sb = new StringBuilder();
            sb.append(original.getProtocol()).append("://");
            if (user != null) {
                sb.append(user);
                if (password != null) {
                    sb.append(":").append(password);
                }
                sb.append("@");
            }
            sb.append(original.getHost());
            if (port != -1) {
                sb.append(":").append(port);
            }
            sb.append(original.getFile());
            return new URL(sb.toString());
        }
        catch (Exception e) {
            Log.logException((String)("Could not construct URL with credentials from <" + original.toString() + ">"), (Throwable)e);
            return original;
        }
    }

    public static String makeSCPAddress(String original, String user) throws Exception {
        try {
            URI uri = new URI(original);
            StringBuilder sb = new StringBuilder();
            if (user != null) {
                sb.append(user);
                sb.append("@");
            }
            String spec = uri.getSchemeSpecificPart();
            while (spec.startsWith("/")) {
                spec = spec.substring(1);
            }
            sb.append(uri.getHost());
            if (uri.getPort() > -1) {
                // empty if block
            }
            sb.append(":");
            sb.append(uri.getPath());
            return sb.toString();
        }
        catch (Exception e) {
            Log.logException((String)("Could not construct URL with user name from <" + original + ">"), (Throwable)e);
            return original.toString();
        }
    }

    public static synchronized String format(Object number, int numDigits) {
        format.setMaximumFractionDigits(numDigits);
        return format.format(number);
    }
}

