/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.util;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.XnjsFile;
import de.fzj.unicore.xnjs.io.XnjsFileWithACL;
import de.fzj.unicore.xnjs.tsi.TSI;
import de.fzj.unicore.xnjs.util.LogUtil;
import de.fzj.unicore.xnjs.util.Observer;
import eu.unicore.security.Client;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class FileMonitor
implements Runnable {
    private static final Logger log = LogUtil.getLogger("unicore.xnjs", FileMonitor.class);
    private final Client client;
    private final String workingDirectory;
    private final String target;
    private final long updateInterval;
    private final TimeUnit timeUnit;
    private XnjsFile info;
    private volatile boolean interrupt;
    private final Set<Observer<XnjsFile>> observers = new HashSet<Observer<XnjsFile>>();
    private final Configuration configuration;

    public FileMonitor(String workingDirectory, String target, Client client, Configuration config) {
        this(workingDirectory, target, client, config, 5L, TimeUnit.SECONDS);
    }

    private void init() {
        this.run();
        this.configuration.getScheduledExecutor().scheduleWithFixedDelay(this, this.updateInterval, this.updateInterval, this.timeUnit);
    }

    public FileMonitor(String workingDirectory, String target, Client client, Configuration config, long updateInterval, TimeUnit timeUnit) {
        this.workingDirectory = workingDirectory;
        this.target = target;
        this.client = client;
        this.updateInterval = updateInterval;
        this.timeUnit = timeUnit;
        this.configuration = config;
        this.init();
    }

    @Override
    public synchronized void run() {
        try {
            if (this.interrupt) {
                throw new RuntimeException();
            }
            TSI tsi = this.configuration.getTargetSystemInterface(this.client);
            tsi.setStorageRoot(this.workingDirectory);
            XnjsFileWithACL newInfo = tsi.getProperties(this.target);
            if (newInfo != null) {
                if (this.info == null || newInfo.getLastModified().compareTo(this.info.getLastModified()) != 0) {
                    this.info = newInfo;
                    this.notifyObservers();
                }
            } else {
                log.debug((Object)("File not found: " + this.target + " in working directory " + this.workingDirectory));
                this.info = null;
            }
        }
        catch (ExecutionException e) {
            log.error((Object)e);
        }
    }

    public void dispose() {
        this.interrupt = true;
    }

    public synchronized XnjsFile getInfo() {
        return this.info;
    }

    public void registerObserver(Observer<XnjsFile> obs) {
        this.observers.add(obs);
    }

    private void notifyObservers() {
        for (Observer<XnjsFile> obs : this.observers) {
            obs.update(this.info);
        }
    }
}

