/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.util;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.ExecutionContext;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.tsi.TSI;
import de.fzj.unicore.xnjs.tsi.TSIBusyException;
import de.fzj.unicore.xnjs.util.ResultHolder;
import eu.unicore.security.Client;

public class ExecuteScript {
    private ExecuteScript() {
    }

    public static ResultHolder executeScript(String script, Client client, Configuration config) throws ExecutionException, TSIBusyException {
        TSI tsi = config.getTargetSystemInterface(client);
        Action action = new Action();
        action.setType("Execute IDB script");
        ExecutionContext ec = config.getExecutionContextMgr().getContext(action);
        tsi.execAndWait(script, ec);
        return new ResultHolder(action, config);
    }

    public static ResultHolder executeIDBScript(String scriptName, Client client, Configuration config) throws ExecutionException, TSIBusyException {
        String script = config.getIDB().getScript(scriptName);
        if (script == null) {
            throw new IllegalArgumentException("Script <" + scriptName + "> is not defined in the IDB.");
        }
        return ExecuteScript.executeScript(script, client, config);
    }

    public static ResultHolder executeIDBScript(String scriptName, Action action, Configuration config) throws ExecutionException, TSIBusyException {
        return ExecuteScript.executeIDBScript(scriptName, action.getClient(), config);
    }

    public static void executeAsync(String script, Action action, Configuration config) throws ExecutionException, TSIBusyException {
    }
}

