/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.util;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.ems.InternalAction;
import de.fzj.unicore.xnjs.ems.InternalManager;
import de.fzj.unicore.xnjs.ems.processors.AsyncCommandProcessor;
import de.fzj.unicore.xnjs.tsi.ApplicationInfo;
import de.fzj.unicore.xnjs.util.ResultHolder;
import eu.unicore.security.Client;

public class AsyncCommandHelper {
    protected final Configuration configuration;
    protected final String parentActionID;
    protected final Client client;
    protected final AsyncCommandProcessor.SubCommand subCommand;
    private String subActionID;
    private String preferredExecutionHost;
    private ResultHolder result;

    public AsyncCommandHelper(Configuration config, String cmd, String id, String parentActionID, Client client) {
        this(config, cmd, id, parentActionID, client, null);
    }

    public AsyncCommandHelper(Configuration config, String cmd, String id, String parentActionID, Client client, String workingDir) {
        this.configuration = config;
        this.parentActionID = parentActionID;
        this.subCommand = new AsyncCommandProcessor.SubCommand();
        this.client = client;
        this.subCommand.id = id;
        this.subCommand.cmd = cmd;
        this.subCommand.workingDir = workingDir;
    }

    public void submit(String preferredExecutionHost) throws ExecutionException {
        this.subCommand.preferredExecutionHost = preferredExecutionHost;
        this.subActionID = this.createAction();
    }

    public void submit() throws ExecutionException {
        this.submit(null);
    }

    public boolean isDone() throws ExecutionException {
        if (this.subActionID == null) {
            throw new IllegalStateException("Not submitted yet.");
        }
        Action sub = this.configuration.getInternalManager().getAction(this.subActionID);
        if (7 == sub.getStatus()) {
            this.result = new ResultHolder(sub, this.configuration);
            return true;
        }
        return false;
    }

    protected String createAction() throws ExecutionException {
        InternalManager manager = this.configuration.getInternalManager();
        if (this.parentActionID != null) {
            Action parent = manager.getAction(this.parentActionID);
            if (parent == null) {
                throw new ExecutionException("Cannot create sub-action: parent action does not exist (any more).");
            }
            return manager.addSubAction(this.subCommand, "ASYNC_COMMAND", parent, true);
        }
        InternalAction a = new InternalAction();
        a.setAjd(this.subCommand);
        a.setType("ASYNC_COMMAND");
        a.setClient(this.client);
        a.setApplicationInfo(new ApplicationInfo());
        this.configuration.getExecutionContextMgr().getContext(a);
        String id = (String)manager.addInternalAction(a);
        return id;
    }

    public String getParentActionID() {
        return this.parentActionID;
    }

    public String getActionID() {
        return this.subActionID;
    }

    public ResultHolder getResult() {
        return this.result;
    }

    public void setEnvironmentVariable(String key, String value) {
        this.subCommand.env.put(key, value);
    }

    public String getPreferredExecutionHost() {
        return this.preferredExecutionHost;
    }

    public void setPreferredExecutionHost(String preferredExecutionHost) {
        this.preferredExecutionHost = preferredExecutionHost;
    }

    public String getStdout() {
        return this.subCommand.stdout;
    }

    public void setStdout(String stdout) {
        this.subCommand.stdout = stdout;
    }

    public String getStderr() {
        return this.subCommand.stderr;
    }

    public void setStderr(String stderr) {
        this.subCommand.stderr = stderr;
    }

    public void abort() throws ExecutionException {
        if (this.subActionID != null) {
            this.configuration.getEMSManager().abort(this.subActionID, this.client);
        }
    }
}

