/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.simple;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.beans.idb.IDBApplicationDocument;
import de.fzj.unicore.xnjs.beans.idb.IDBDocument;
import de.fzj.unicore.xnjs.jsdl.BaseIDBImpl;
import de.fzj.unicore.xnjs.management.Lifecycle;
import de.fzj.unicore.xnjs.util.XmlBeansUtils;
import eu.unicore.jsdl.extensions.ExecutionEnvironmentDocument;
import java.io.File;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlObject;

@Lifecycle(isSingleton=true)
public class SimpleIDB
extends BaseIDBImpl {
    private long lastModified = System.currentTimeMillis();
    private File idbFile;
    private boolean isDirectory;
    private boolean dirWasModified = true;
    private boolean haveMainIDBFile;
    private byte[] dirChangedHash = new byte[0];

    public SimpleIDB(Configuration config) {
        super(config);
        this.idbFile = new File(config.getProperty("XNJS.idbfile", "conf/simpleidb"));
        this.isDirectory = this.idbFile.isDirectory();
        if (this.isDirectory) {
            logger.info((Object)("Using IDB directory <" + this.idbFile.getAbsolutePath() + ">"));
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    SimpleIDB.this.checkDirectoryChanged();
                }
            };
            config.getScheduledExecutor().scheduleWithFixedDelay(r, 5000L, 5000L, TimeUnit.MILLISECONDS);
        } else {
            logger.info((Object)("Using IDB file <" + this.idbFile.getAbsolutePath() + ">"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateIDB() throws Exception {
        this.lastModified = this.idbFile.lastModified();
        this.dirWasModified = false;
        this.haveMainIDBFile = false;
        Map map = this.idb;
        synchronized (map) {
            this.idb.clear();
            this.executionEnvironments.clear();
            if (this.isDirectory) {
                for (File file : this.idbFile.listFiles()) {
                    if (file.isDirectory() || file.isHidden()) continue;
                    try {
                        this.handleFile(file);
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error processing IDB file <" + file + ">"), (Throwable)ex);
                    }
                }
            } else {
                this.handleFile(this.idbFile);
            }
        }
    }

    protected void handleFile(File file) throws Exception {
        logger.info((Object)("Reading from " + file));
        XmlObject o = XmlObject.Factory.parse((File)file);
        QName q = XmlBeansUtils.getQNameFor(o);
        if (IDBDocument.type.getDocumentElementName().equals(q)) {
            if (this.haveMainIDBFile) {
                throw new Exception("Detected two main IDB files, ignoring <" + file.getAbsolutePath() + ">");
            }
            this.haveMainIDBFile = true;
            IDBDocument idbd = IDBDocument.Factory.parse(file);
            IDBDocument.IDB xmlidb = idbd.getIDB();
            this.readIDB(xmlidb);
        } else if (IDBApplicationDocument.type.getDocumentElementName().equals(q)) {
            this.readApplication(file);
        } else if (ExecutionEnvironmentDocument.type.getDocumentElementName().equals(q)) {
            this.readExecutionEnvironment(file);
        } else {
            logger.warn((Object)("Unknown XML IDB document type <" + q + "> found in file <" + file.getAbsolutePath() + ">, ignoring this file."));
        }
    }

    @Override
    protected synchronized boolean idbWasModified() {
        if (this.lastModified != this.idbFile.lastModified()) {
            return true;
        }
        if (this.isDirectory) {
            return this.dirWasModified;
        }
        return false;
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastModified;
    }

    private void readApplication(File file) throws Exception {
        IDBApplicationDocument app = IDBApplicationDocument.Factory.parse(file);
        this.addApplication(app.getIDBApplication());
        logger.info((Object)("Registered application <" + app.getIDBApplication().getApplicationName() + ">"));
    }

    private void readExecutionEnvironment(File file) throws Exception {
        ExecutionEnvironmentDocument eed = ExecutionEnvironmentDocument.Factory.parse((File)file);
        ExecutionEnvironmentDocument.ExecutionEnvironment ee = eed.getExecutionEnvironment();
        String name = ee.getName();
        this.executionEnvironments.put(name, ee);
        logger.info((Object)("Registered execution environment <" + name + ">"));
    }

    private void checkDirectoryChanged() {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            for (File f : this.idbFile.listFiles()) {
                md.update(String.valueOf(f.lastModified()).getBytes());
            }
            byte[] newD = md.digest();
            boolean eq = Arrays.equals(this.dirChangedHash, newD);
            if (!eq) {
                this.dirChangedHash = newD;
                this.dirWasModified = true;
            }
        }
        catch (Exception ex) {
            logger.warn((Object)"Error checking for IDB modification", (Throwable)ex);
        }
    }
}

