/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.simple;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.ActionResult;
import de.fzj.unicore.xnjs.ems.ProcessingException;
import de.fzj.unicore.xnjs.ems.processors.DefaultProcessor;
import de.fzj.unicore.xnjs.io.DataStageInInfo;
import de.fzj.unicore.xnjs.io.DataStageOutInfo;
import de.fzj.unicore.xnjs.io.DataStagingCredentials;
import de.fzj.unicore.xnjs.io.DataStagingInfo;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.util.LogUtil;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class SimpleDataStagingProcessor
extends DefaultProcessor {
    private static final Logger logger = LogUtil.getLogger("unicore.services.jobexecution", SimpleDataStagingProcessor.class);
    private static final String fileTransferKey = "FILETRANSFERS";
    public static final String KEY_DELETEONTERMINATION = "JSDL_DELETEFILES";
    private static final Map<String, IFileTransfer> map = new ConcurrentHashMap<String, IFileTransfer>();
    private static Executor exec = null;

    public SimpleDataStagingProcessor(Configuration c) {
        super(c);
    }

    @Override
    protected void begin() throws ProcessingException {
    }

    @Override
    protected void handleCreated() throws ProcessingException {
        logger.debug((Object)("Adding file transfers for " + this.action.getUUID()));
        try {
            List dstInfo = (List)this.action.getAjd();
            ArrayList<String> ftList = new ArrayList<String>();
            ArrayList<IFileTransfer> ftInstances = new ArrayList<IFileTransfer>();
            this.action.getProcessingContext().put(fileTransferKey, ftList);
            String uspace = this.action.getExecutionContext().getWorkingDirectory();
            if (dstInfo == null) {
                logger.info((Object)"Data staging expected but not found. File transfers failed.");
                this.setToDoneAndFailed("Internal server error.");
            } else {
                ArrayList<String> filesToDelete = new ArrayList<String>();
                for (DataStagingInfo dst : dstInfo) {
                    try {
                        IFileTransfer ft = null;
                        IFileTransfer.OverwritePolicy overwrite = dst.getOverwritePolicy();
                        String workingDirectory = uspace;
                        String fsName = dst.getFileSystemName();
                        if (fsName != null) {
                            String fs = this.configuration.getIDB().getFilespace(fsName);
                            if (fs == null) {
                                throw new Exception("Requested file system <" + fsName + "> is not available at this site.");
                            }
                            workingDirectory = this.configuration.getTargetSystemInterface(this.action.getClient()).resolve(fs);
                        }
                        if (dst instanceof DataStageInInfo) {
                            DataStageInInfo in = (DataStageInInfo)dst;
                            URI source = in.getSources()[0];
                            String target = dst.getFileName();
                            ft = this.createImport(workingDirectory, source, target, overwrite, in.getCredentials());
                        } else {
                            DataStageOutInfo out = (DataStageOutInfo)dst;
                            URI target = out.getTarget();
                            String source = dst.getFileName();
                            ft = this.createExport(workingDirectory, source, target, overwrite, out.getCredentials());
                        }
                        ft.setParentActionID(this.action.getRootActionID());
                        ft.setIgnoreFailure(dst.isIgnoreFailure());
                        ftInstances.add(ft);
                        map.put(ft.getUniqueId(), ft);
                        boolean deleteOnTermination = dst.isDeleteOnTermination();
                        if (!deleteOnTermination) continue;
                        filesToDelete.add(dst.getFileName());
                    }
                    catch (Exception e) {
                        if (!dst.isIgnoreFailure()) {
                            String msg = LogUtil.createFaultMessage("Error adding filetransfer " + dst, e);
                            LogUtil.logException("Error adding filetransfer", e);
                            this.setToDoneAndFailed(msg);
                            return;
                        }
                        this.action.addLogTrace("Ignoring failure to setup filetransfer");
                    }
                }
                if (filesToDelete.size() > 0) {
                    this.action.getProcessingContext().put(KEY_DELETEONTERMINATION, filesToDelete);
                }
                for (IFileTransfer ft : ftInstances) {
                    try {
                        this.getExecutor().execute(ft);
                        this.action.addLogTrace("Started filetransfer " + ft.getSource() + " -> " + ft.getTarget());
                        ftList.add(ft.getUniqueId());
                    }
                    catch (RejectedExecutionException e) {
                        LogUtil.logException("Error starting filetransfer: " + ft.getSource() + "->" + ft.getTarget(), e);
                        this.setToDoneAndFailed("Error starting filetransfer (internal work queue too full)");
                        return;
                    }
                }
                this.action.setStatus(5);
            }
        }
        catch (Exception ex) {
            throw new ProcessingException(ex);
        }
    }

    protected IFileTransfer createImport(String workingDirectory, URI source, String target, IFileTransfer.OverwritePolicy overwrite, DataStagingCredentials credentials) throws IOException {
        IFileTransfer ft = this.configuration.getFileTransferEngine().createFileImport(this.action.getClient(), workingDirectory, source, target, overwrite, credentials);
        return ft;
    }

    protected IFileTransfer createExport(String workingDirectory, String source, URI target, IFileTransfer.OverwritePolicy overwrite, DataStagingCredentials credentials) throws IOException {
        IFileTransfer ft = this.configuration.getFileTransferEngine().createFileExport(this.action.getClient(), workingDirectory, source, target, overwrite, credentials);
        return ft;
    }

    @Override
    protected void handleAborting() throws ProcessingException {
        ArrayList ftList = (ArrayList)this.action.getProcessingContext().get(fileTransferKey);
        if (ftList == null) {
            throw new IllegalStateException("Filetransfer list not found in context");
        }
        for (String ftId : ftList) {
            IFileTransfer ft = map.get(ftId);
            if (ft == null) continue;
            logger.debug((Object)("ABORT: " + ft.getSource() + "->" + ft.getTarget()));
            ft.abort();
        }
        super.handleAborting();
    }

    @Override
    protected void handleRemoving() throws ProcessingException {
    }

    @Override
    protected void handleRunning() throws ProcessingException {
        ArrayList ftList = (ArrayList)this.action.getProcessingContext().get(fileTransferKey);
        if (ftList == null) {
            throw new IllegalStateException("Filetransfer list not found in context");
        }
        Iterator iter = ftList.iterator();
        while (iter.hasNext()) {
            String message;
            String ftId = (String)iter.next();
            IFileTransfer ft = map.get(ftId);
            if (ft == null) {
                throw new IllegalStateException("Internal server error: File transfer '" + ftId + "' not found!");
            }
            if (ft.getStatus() == IFileTransfer.Status.DONE) {
                logger.debug((Object)("File transfer " + ft.getUniqueId() + " successful."));
                map.remove(ftId);
                iter.remove();
                this.action.setDirty();
                continue;
            }
            if (ft.getStatus() != IFileTransfer.Status.FAILED) continue;
            logger.debug((Object)("File transfer " + ft.getUniqueId() + " failed."));
            if (!ft.isIgnoreFailure()) {
                message = "Filetransfer FAILED: " + ft.getSource() + " -> " + ft.getTarget() + ", error message: " + ft.getStatusMessage();
                this.action.addLogTrace(message);
                this.setToDoneAndFailed(message);
                this.cleanup();
                return;
            }
            message = "Ignoring FAILED filetransfer: " + ft.getSource() + " -> " + ft.getTarget();
            this.action.addLogTrace(message);
            iter.remove();
        }
        if (ftList.size() == 0) {
            this.action.setStatus(7);
            this.action.setResult(new ActionResult(3));
        }
    }

    protected void cleanup() throws ProcessingException {
        ArrayList ftList = (ArrayList)this.action.getProcessingContext().get(fileTransferKey);
        if (ftList == null) {
            throw new IllegalStateException("Filetransfer list not found in context");
        }
        for (String ftId : ftList) {
            map.remove(ftId);
        }
    }

    protected synchronized Executor getExecutor() {
        if (exec == null) {
            ThreadFactory tf = new ThreadFactory(){
                private final AtomicInteger number = new AtomicInteger(0);

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r);
                    t.setName("XNJS-Filetransfers-" + this.number.incrementAndGet());
                    return t;
                }
            };
            ThreadPoolExecutor exec1 = new ThreadPoolExecutor(this.getNumberOfFiletransferThreads(), this.getNumberOfFiletransferThreads(), 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), tf);
            exec1.allowCoreThreadTimeOut(true);
            exec = exec1;
        }
        return exec;
    }

    protected int getNumberOfFiletransferThreads() {
        return 2;
    }
}

