/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.simple;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.ExecutionContext;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.ChangeACL;
import de.fzj.unicore.xnjs.io.ChangePermissions;
import de.fzj.unicore.xnjs.io.FileFilter;
import de.fzj.unicore.xnjs.io.Permissions;
import de.fzj.unicore.xnjs.io.XnjsFile;
import de.fzj.unicore.xnjs.io.XnjsFileImpl;
import de.fzj.unicore.xnjs.io.XnjsFileWithACL;
import de.fzj.unicore.xnjs.io.XnjsStorageInfo;
import de.fzj.unicore.xnjs.management.Lifecycle;
import de.fzj.unicore.xnjs.simple.LocalExecution;
import de.fzj.unicore.xnjs.tsi.TSI;
import de.fzj.unicore.xnjs.tsi.TSIBusyException;
import de.fzj.unicore.xnjs.util.ErrorCode;
import de.fzj.unicore.xnjs.util.IOUtils;
import de.fzj.unicore.xnjs.util.LogUtil;
import eu.unicore.security.Client;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.UUID;
import java.util.concurrent.RejectedExecutionException;
import org.apache.log4j.Logger;

@Lifecycle(isSingleton=false)
public class LocalTS
implements TSI {
    private static final Logger logger = LogUtil.getLogger("unicore.xnjs.tsi", LocalTS.class);
    private Client client;
    private final Configuration configuration;
    private String storageRoot;
    private boolean[] invertedUmask = new boolean[]{true, true, true, false, false, false};
    private static final boolean[] DEFAULT_FILE_PERMS = new boolean[]{true, true, false, true, true, false};
    private static final boolean[] DEFAULT_DIR_PERMS = new boolean[]{true, true, true, true, true, true};

    public LocalTS(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public void setClient(Client client) {
        this.client = client;
    }

    @Override
    public void chmod(String file, Permissions perm) throws ExecutionException {
        File target = this.makeTarget(file);
        target.setExecutable(perm.isExecutable());
        target.setReadable(perm.isReadable());
        target.setWritable(perm.isWritable());
    }

    @Override
    public void cp(String source, String target) throws ExecutionException {
        FileOutputStream fos = null;
        FileInputStream fis = null;
        try {
            File tFile = this.makeTarget(target);
            File sFile = this.makeTarget(source);
            logger.debug((Object)("cp: " + sFile + "->" + tFile));
            if (tFile.isDirectory()) {
                tFile = new File(tFile, sFile.getName());
            }
            fos = new FileOutputStream(tFile);
            FileChannel out = fos.getChannel();
            fis = new FileInputStream(sFile);
            FileChannel in = fis.getChannel();
            out.write(in.map(FileChannel.MapMode.READ_ONLY, 0L, sFile.length()));
            in.close();
            out.close();
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new ExecutionException(ex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    @Override
    public void rename(String source, String target) throws ExecutionException {
        boolean success = true;
        try {
            File tFile = this.makeTarget(target);
            File sFile = this.makeTarget(source);
            logger.debug((Object)("rename: " + sFile + "->" + tFile));
            success = sFile.renameTo(tFile);
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new ExecutionException(ex);
        }
        if (!success) {
            String msg = "Could not rename file.";
            ErrorCode ec = new ErrorCode(12, msg);
            throw new ExecutionException(ec);
        }
    }

    @Override
    public void rmdir(String target) throws ExecutionException {
        File f = this.makeTarget(target);
        logger.debug((Object)("rmdir: " + f));
        this._rmdir(f);
    }

    private void _rmdir(File f) throws ExecutionException {
        File[] children;
        if (f.isDirectory() && (children = f.listFiles()) != null) {
            for (File child : children) {
                this._rmdir(child);
            }
        }
        if (!f.delete()) {
            String msg = "Could not delete.";
            ErrorCode ec = new ErrorCode(12, msg);
            throw new ExecutionException(ec);
        }
    }

    @Override
    public void mkdir(String dir) throws ExecutionException {
        try {
            File f = this.makeTarget(dir);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("making directory: " + f));
            }
            if (f.exists()) {
                return;
            }
            if (!f.mkdirs() && !f.isDirectory()) {
                logger.error((Object)("Failed to create directory <" + f.getAbsolutePath() + ">"));
                throw new IOException("Could not create dir <" + dir + ">");
            }
            this.setPermissions(f);
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new ExecutionException(ex);
        }
    }

    @Override
    public void mkfifo(String dir) throws ExecutionException {
        try {
            File f = this.makeTarget(dir);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("making fifo: " + f));
            }
            if (IOUtils.isNonUnix()) {
                throw new ExecutionException("FIFO can not be created on a non-UNIX operating system.");
            }
            this.execAndWait("mkfifo " + f.getAbsolutePath(), new ExecutionContext(UUID.randomUUID().toString()));
            this.setPermissions(f);
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new ExecutionException(ex);
        }
    }

    @Override
    public void link(String target, String linkName) throws ExecutionException {
        try {
            File newLink = this.makeTarget(linkName);
            File targetFile = this.makeTarget(target);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("linking: " + newLink + " -> " + targetFile));
            }
            if (IOUtils.isNonUnix()) {
                throw new ExecutionException("Link can not be created on a non-UNIX operating system.");
            }
            this.execAndWait("ln -s " + targetFile.getAbsolutePath() + " " + newLink.getAbsolutePath(), new ExecutionContext(UUID.randomUUID().toString()));
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new ExecutionException(ex);
        }
    }

    @Override
    public String getFileSeparator() {
        return File.separator;
    }

    @Override
    public String getHomePath() throws ExecutionException {
        return System.getProperty("user.home");
    }

    @Override
    public String getEnvironment(String name) throws ExecutionException {
        return null;
    }

    @Override
    public String resolve(String name) throws ExecutionException {
        return name;
    }

    @Override
    public void rm(String target) throws ExecutionException {
        File f = this.makeTarget(target);
        try {
            logger.debug((Object)("Delete: " + f));
            boolean OK = f.delete();
            if (!OK) {
                throw new IOException("Did not delete file.");
            }
        }
        catch (Exception ex) {
            throw new ExecutionException(ex);
        }
    }

    @Override
    public XnjsFile[] ls(String base) throws ExecutionException {
        return this.ls(base, 0, Integer.MAX_VALUE, false);
    }

    @Override
    public XnjsFile[] ls(String base, int offset, int limit, boolean filter) throws ExecutionException {
        try {
            logger.trace((Object)("listing " + base));
            File dir = this.makeTarget(base);
            if (!dir.isDirectory()) {
                throw new IOException("Not a directory.");
            }
            File[] fs = dir.listFiles();
            if (offset > fs.length) {
                throw new IllegalArgumentException("Specified offset <" + offset + "> is larger than the total number of results <" + fs.length + ">");
            }
            int numResults = Math.min(fs.length, limit);
            XnjsFile[] res = new XnjsFileImpl[numResults];
            for (int i = 0; i < numResults; ++i) {
                File f = fs[offset + i];
                Permissions permissions = Permissions.getPermissions(f);
                if (filter && !permissions.isAccessible()) continue;
                res[i] = new XnjsFileImpl(this.makePathRelativeToRoot(f.getAbsolutePath()), f.length(), f.isDirectory(), f.lastModified(), permissions, true);
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)res[i].toString());
            }
            return res;
        }
        catch (Exception e) {
            String msg = "Could not list files.";
            ErrorCode ec = new ErrorCode(12, msg);
            throw new ExecutionException(ec);
        }
    }

    protected String makePathRelativeToRoot(String absolutePath) {
        return IOUtils.getRelativePath(new File(absolutePath), this.getStorageRoot());
    }

    @Override
    public XnjsFileWithACL getProperties(String file) throws ExecutionException {
        try {
            File f = this.makeTarget(file);
            if (!f.exists()) {
                return null;
            }
            XnjsFileImpl res = new XnjsFileImpl();
            res.setDirectory(f.isDirectory());
            Calendar lastModified = Calendar.getInstance();
            lastModified.setTimeInMillis(f.lastModified());
            res.setLastModified(lastModified);
            res.setPath(this.makePathRelativeToRoot(f.getAbsolutePath()));
            res.setSize(f.length());
            Permissions permissions = Permissions.getPermissions(f);
            res.setPermissions(permissions);
            return res;
        }
        catch (Exception e) {
            String msg = "Could not get properties for <" + file + ">";
            ErrorCode ec = new ErrorCode(12, msg);
            throw new ExecutionException(ec);
        }
    }

    @Override
    public XnjsFile[] find(String path, FileFilter options, int offset, int limit) throws ExecutionException {
        try {
            File dir = new File(this.getStorageRoot(), path);
            if (!dir.isDirectory()) {
                throw new IOException("Not a directory: " + path);
            }
            File[] fs = dir.listFiles();
            if (fs == null) {
                throw new IOException("IO problem when listing files in <" + path + ">");
            }
            ArrayList<XnjsFile> res = new ArrayList<XnjsFile>();
            for (int i = 0; i < fs.length; ++i) {
                if (options.recurse() && fs[i].isDirectory()) {
                    XnjsFile[] subResult;
                    for (XnjsFile f : subResult = this.find(path + this.getFileSeparator() + fs[i].getName(), options, offset, limit)) {
                        res.add(f);
                    }
                    continue;
                }
                Permissions permissions = Permissions.getPermissions(fs[i]);
                XnjsFileImpl f = new XnjsFileImpl(this.makePathRelativeToRoot(fs[i].getAbsolutePath()), fs[i].length(), fs[i].isDirectory(), fs[i].lastModified(), permissions, true);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)((Object)f).toString());
                }
                if (!options.accept(f, this)) continue;
                res.add(f);
            }
            return res.toArray(new XnjsFile[res.size()]);
        }
        catch (IOException e) {
            throw new ExecutionException("Could not execute find", e);
        }
    }

    @Override
    public void exec(String orig, ExecutionContext ec) throws TSIBusyException, ExecutionException {
        try {
            LocalExecution ex = new LocalExecution(this.configuration, orig, ec.getWorkingDirectory(), ec);
            ex.execute();
        }
        catch (RejectedExecutionException re) {
            throw new TSIBusyException("Execution currently not possible.");
        }
        catch (Exception ex) {
            throw new ExecutionException("Error while executing <" + orig + ">", ex);
        }
    }

    @Override
    public void execAndWait(String orig, ExecutionContext ec) throws TSIBusyException, ExecutionException {
        try {
            LocalExecution ex = new LocalExecution(this.configuration, orig, ec.getWorkingDirectory(), ec);
            ex.execute(false);
            Integer exitCode = LocalExecution.getExitCode(ec.getActionID());
            if (exitCode != null) {
                ec.setExitCode(exitCode);
            }
        }
        catch (RejectedExecutionException re) {
            throw new TSIBusyException("Execution currently not possible.");
        }
        catch (Exception ex) {
            throw new ExecutionException("Error while executing <" + orig + ">", ex);
        }
    }

    private File makeTarget(String target) throws ExecutionException {
        File f;
        if (IOUtils.isNonUnix() && (f = new File(target = target.replace('/', File.separatorChar))).isAbsolute()) {
            return f;
        }
        f = new File(this.getStorageRoot(), target);
        return f;
    }

    @Override
    public InputStream getInputStream(String file) throws ExecutionException {
        try {
            return new FileInputStream(this.makeTarget(file));
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public OutputStream getOutputStream(String file, boolean append) throws ExecutionException {
        try {
            File f = this.makeTarget(file);
            if (!f.exists()) {
                f.createNewFile();
                this.setPermissions(f);
            }
            return new FileOutputStream(f, append);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public OutputStream getOutputStream(String file) throws ExecutionException {
        return this.getOutputStream(file, false);
    }

    public void setPreferredBufferSize(int size) {
    }

    public RandomAccessFile getRandomAccessFile(String file) throws ExecutionException {
        try {
            return new RandomAccessFile(this.makeTarget(file), "rws");
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public String getFileSystemIdentifier() {
        try {
            return "LOCAL TSI at " + InetAddress.getLocalHost().getHostName();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public XnjsStorageInfo getAvailableDiskSpace(String path) {
        XnjsStorageInfo x = new XnjsStorageInfo();
        File f = new File(path);
        long total = f.getTotalSpace();
        if (total > -1L) {
            x.setTotalSpace(total);
            x.setFreeSpace(f.getFreeSpace());
            x.setUsableSpace(f.getUsableSpace());
        }
        return x;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public String getStorageRoot() {
        if (this.storageRoot == null) {
            this.storageRoot = this.getRoot();
        }
        return this.storageRoot;
    }

    private String getRoot() {
        if (IOUtils.isNonUnix()) {
            return new File("/").getAbsolutePath();
        }
        return "/";
    }

    @Override
    public void setStorageRoot(String storageRoot) {
        this.storageRoot = new File(storageRoot).getAbsolutePath();
    }

    @Override
    public String[] getGroups() throws TSIBusyException, ExecutionException {
        return new String[0];
    }

    @Override
    public void chmod2(String file, ChangePermissions[] perm, boolean recursive) throws ExecutionException {
        if (recursive) {
            throw new ExecutionException("Recursive permissions manipulation is unsupported in Java TSI.");
        }
        for (ChangePermissions p : perm) {
            if (p.getClazz().equals((Object)ChangePermissions.PermissionsClass.OWNER)) continue;
            throw new ExecutionException("Extended permissions manipulation is unsupported in Java TSI - only owner permissions can be set.");
        }
        File f = this.makeTarget(file);
        for (ChangePermissions pSpec : perm) {
            Permissions current;
            boolean x;
            String p = pSpec.getPermissions();
            boolean r = p.charAt(0) == 'r';
            boolean w = p.charAt(1) == 'w';
            boolean bl = x = p.charAt(2) == 'x';
            if (!pSpec.getMode().equals((Object)ChangePermissions.Mode.SET)) {
                current = Permissions.getPermissions(f);
                boolean newValue = pSpec.getMode().equals((Object)ChangePermissions.Mode.ADD);
                if (r) {
                    current.setReadable(newValue);
                }
                if (w) {
                    current.setWritable(newValue);
                }
                if (x) {
                    current.setExecutable(newValue);
                }
            } else {
                current = new Permissions(r, w, x);
            }
            this.chmod(file, current);
        }
    }

    @Override
    public void chgrp(String file, String newGroup, boolean recursive) throws ExecutionException {
        throw new ExecutionException("Owning group manipulation is unsupported in Java TSI");
    }

    @Override
    public boolean isACLSupported(String path) {
        return false;
    }

    @Override
    public void setfacl(String file, boolean clearAll, ChangeACL[] changeACL, boolean recursive) throws ExecutionException {
        throw new ExecutionException("ACL manipulation is unsupported in Java TSI");
    }

    private void setPermissions(File file) {
        boolean[] perms = file.isDirectory() ? DEFAULT_DIR_PERMS : DEFAULT_FILE_PERMS;
        file.setReadable(perms[3] && this.invertedUmask[3], false);
        file.setWritable(perms[4] && this.invertedUmask[4], false);
        file.setExecutable(perms[5] && this.invertedUmask[5], false);
        file.setReadable(perms[0] && this.invertedUmask[0], true);
        file.setWritable(perms[1] && this.invertedUmask[1], true);
        file.setExecutable(perms[2] && this.invertedUmask[2], true);
    }

    @Override
    public void setUmask(String umaskStr) {
        int i;
        int mask = umaskStr == null ? 63 : Integer.parseInt(umaskStr, 8);
        for (i = 0; i < 3; ++i) {
            if ((mask & 1 << i) == (mask >>> 3 & 1 << i)) continue;
            throw new IllegalArgumentException("In Java TSI umask must contain exactly the same value for the group and others (i.e. the two last octal digits must be equal). Got: " + umaskStr);
        }
        for (i = 0; i < 6; ++i) {
            this.invertedUmask[i] = (mask & 1 << 8 - i) == 0;
        }
    }

    @Override
    public String getUmask() {
        int ret = 0;
        int i = 0;
        int v = 4;
        while (i < 3) {
            ret += (this.invertedUmask[i] ? 0 : 1) * v * 64;
            ++i;
            v /= 2;
        }
        i = 3;
        v = 4;
        while (i < 6) {
            ret += (this.invertedUmask[i] ? 0 : 1) * v * 8;
            ++i;
            v /= 2;
        }
        i = 3;
        v = 4;
        while (i < 6) {
            ret += (this.invertedUmask[i] ? 0 : 1) * v;
            ++i;
            v /= 2;
        }
        return "0" + Integer.toOctalString(ret);
    }
}

