/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.simple;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.ExecutionContext;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.ems.InternalManager;
import de.fzj.unicore.xnjs.ems.event.ContinueProcessingEvent;
import de.fzj.unicore.xnjs.util.LogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class LocalExecution
implements Runnable {
    private static final Logger logger = LogUtil.getLogger("unicore.services.jobexecution", LocalExecution.class);
    private final String actionID;
    private final String cmd;
    private final String workDir;
    private final ExecutionContext ec;
    private final Configuration configuration;
    private static int rejected = 0;
    private boolean readOutput = true;
    public static final int DEFAULT_EXECUTOR_POOLSIZE = 4;
    private static final AtomicInteger completedTasks = new AtomicInteger(0);
    private static final AtomicInteger runningTasks = new AtomicInteger(0);
    private static final AtomicInteger totalTasks = new AtomicInteger(0);
    private static ThreadPoolExecutor es;
    private static ThreadPoolExecutor es2;
    private static final Set<String> runningJobs;
    private static final Map<String, Integer> exitCodes;
    private static final Map<String, Process> processes;

    public static int getExecutorPoolMinSize() {
        return es.getCorePoolSize();
    }

    public static int getExecutorPoolMaxSize() {
        return es.getMaximumPoolSize();
    }

    public static long getCompletedTasks() {
        return completedTasks.longValue();
    }

    public static int getActiveTasks() {
        return es.getActiveCount();
    }

    public static boolean isRunning(String actionID) {
        return runningJobs.contains(actionID);
    }

    public static Integer getExitCode(String actionID) {
        Integer exit;
        if (actionID != null && (exit = exitCodes.get(actionID)) != null) {
            exitCodes.remove(actionID);
            return exit;
        }
        return null;
    }

    private synchronized void initPool() {
        if (es != null) {
            return;
        }
        es = new ThreadPoolExecutor(4, 4, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        es2 = new ThreadPoolExecutor(8, 8, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public LocalExecution(Configuration config, String cmd, String workDir, ExecutionContext ec) {
        this.configuration = config;
        this.actionID = ec.getActionID();
        this.cmd = cmd;
        this.workDir = workDir;
        this.ec = ec;
        this.initPool();
    }

    public void execute() throws Exception {
        this.execute(true);
    }

    public void execute(boolean async) throws Exception {
        totalTasks.incrementAndGet();
        if (async) {
            es.execute(this);
            if (this.actionID != null) {
                runningJobs.add(this.actionID);
            }
        } else {
            if (this.actionID != null) {
                runningJobs.add(this.actionID);
            }
            this.run();
        }
    }

    @Override
    public void run() {
        FileOutputStream stdout = null;
        FileOutputStream stderr = null;
        FileInputStream stdin = null;
        FileOutputStream stdinDummy = null;
        boolean redirectInput = false;
        try {
            long start = System.currentTimeMillis();
            runningTasks.incrementAndGet();
            String what = this.replaceEnvVars(this.cmd, this.ec.getEnvironment());
            logger.info((Object)("[" + this.actionID + "] Executing '" + what + "' in " + this.workDir));
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.directory(new File(this.workDir));
            this.copyEnv(this.ec.getEnvironment(), pb.environment());
            if (this.ec.getStdin() != null) {
                stdin = new FileInputStream(this.ec.getWorkingDirectory() + File.separator + this.ec.getStdin());
                redirectInput = true;
                logger.debug((Object)("Redirected input from '" + this.ec.getStdin() + "'"));
                stdinDummy = new FileOutputStream(this.ec.getWorkingDirectory() + File.separator + this.ec.getStdin(), true);
            }
            pb.command(this.createCommandArray(what));
            Process p = pb.start();
            if (this.actionID != null) {
                processes.put(this.actionID, p);
            }
            try {
                ContinueProcessingEvent cpe = new ContinueProcessingEvent(this.actionID);
                this.configuration.getInternalManager().handleEvent(cpe);
            }
            catch (Exception ex) {
                LogUtil.logException("Error sending continue event", ex);
            }
            if (redirectInput) {
                DataMover in = new DataMover(stdin, p.getOutputStream());
                es2.execute(in);
            }
            DataMover out = null;
            DataMover err = null;
            if (this.readOutput) {
                stderr = new FileOutputStream(this.ec.getOutcomeDirectory() + File.separator + this.ec.getStderr());
                err = new DataMover(p.getErrorStream(), stderr);
                while (true) {
                    try {
                        es2.execute(err);
                    }
                    catch (RejectedExecutionException re) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ignored) {}
                        continue;
                    }
                    break;
                }
                stdout = new FileOutputStream(this.ec.getOutcomeDirectory() + File.separator + this.ec.getStdout());
                out = new DataMover(p.getInputStream(), stdout);
                out.run();
            }
            int exit = p.waitFor();
            if (this.readOutput) {
                while (!out.isDone() || !err.isDone()) {
                    Thread.sleep(10L);
                }
            }
            long diff = System.currentTimeMillis() - start;
            logger.info((Object)("[" + this.actionID + "] Done with '" + what + "' exit code " + exit + ", took " + diff + " ms."));
            completedTasks.incrementAndGet();
            this.ec.setExitCode(exit);
            if (this.actionID != null) {
                exitCodes.put(this.actionID, exit);
            }
            try {
                p.destroy();
            }
            catch (Exception e) {
                logger.warn((Object)"Error while destroying process.", (Throwable)e);
            }
            pb = null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (this.actionID != null) {
                runningJobs.remove(this.actionID);
                runningTasks.decrementAndGet();
                totalTasks.decrementAndGet();
            }
            if (stdout != null) {
                try {
                    stdout.close();
                }
                catch (IOException e) {}
            }
            if (stderr != null) {
                try {
                    stderr.close();
                }
                catch (IOException e) {}
            }
            if (stdin != null) {
                try {
                    stdin.close();
                }
                catch (IOException e) {}
            }
            if (stdinDummy != null) {
                try {
                    stdinDummy.close();
                }
                catch (IOException e) {}
            }
            if (this.actionID != null) {
                try {
                    InternalManager m = this.configuration.getInternalManager();
                    m.handleEvent(new ContinueProcessingEvent(this.actionID));
                }
                catch (Exception ex) {
                    logger.error((Object)"Could not send status change notification", (Throwable)ex);
                }
            }
        }
    }

    protected String[] createCommandArray(String commandLine) {
        return commandLine.split(" +");
    }

    private String replaceEnvVars(String original, Map<String, String> env) {
        String sb = original;
        Object[] keys = env.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        for (int i = keys.length - 1; i >= 0; --i) {
            Object e = keys[i];
            sb = sb.replaceAll("\\$" + (String)e, this.ec.getEnvironment().get(e));
            sb = sb.replaceAll("\\$\\{" + (String)e + "\\}", this.ec.getEnvironment().get(e));
        }
        return sb;
    }

    private void copyEnv(Map<String, String> from, Map<String, String> to) {
        for (Map.Entry<String, String> e : from.entrySet()) {
            to.put(e.getKey(), e.getValue());
        }
    }

    public static Set<String> getRunningJobs() {
        return runningJobs;
    }

    public static int getNumberOfRejectedTasks() {
        return rejected;
    }

    public static int getNumberOfRunningJobs() {
        return runningTasks.get();
    }

    public static int getTotalNumberOfJobs() {
        return totalTasks.get();
    }

    public static void abort(String uuid) throws ExecutionException {
        try {
            Process p = processes.get(uuid);
            if (p != null) {
                p.destroy();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Could not destroy process.", (Throwable)e);
            throw new ExecutionException(e);
        }
    }

    public boolean isReadOutput() {
        return this.readOutput;
    }

    public void setReadOutput(boolean readOutput) {
        this.readOutput = readOutput;
    }

    static {
        runningJobs = Collections.synchronizedSet(new HashSet());
        exitCodes = new ConcurrentHashMap<String, Integer>();
        processes = new ConcurrentHashMap<String, Process>();
    }

    public static class DataMover
    implements Runnable {
        private final InputStream source;
        private final OutputStream target;
        private final byte[] buf = new byte[1024];
        private Exception exception;
        private boolean done = false;

        public DataMover(InputStream source, OutputStream target) {
            this.source = source;
            this.target = target;
        }

        public boolean isDone() throws Exception {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.done;
        }

        @Override
        public void run() {
            while (!this.done) {
                try {
                    int c = this.source.read(this.buf);
                    if (c == -1) {
                        this.done = true;
                    } else if (c > 0) {
                        this.target.write(this.buf, 0, c);
                    } else {
                        Thread.yield();
                    }
                    this.target.flush();
                }
                catch (Exception e) {
                    this.exception = e;
                    this.done = true;
                }
            }
        }
    }
}

