/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.simple;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.ExecutionContext;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.ems.IExecutionContextManager;
import de.fzj.unicore.xnjs.simple.BasicTSIFactory;
import de.fzj.unicore.xnjs.tsi.TSI;
import de.fzj.unicore.xnjs.tsi.TSIFactory;
import de.fzj.unicore.xnjs.util.LogUtil;
import java.io.File;
import org.apache.log4j.Logger;

public class LocalECManager
implements IExecutionContextManager {
    private static final Logger logger = LogUtil.getLogger("unicore.services.jobexecution", BasicTSIFactory.class);
    private final TSIFactory tsiFactory;
    private final Configuration configuration;

    public LocalECManager(Configuration config) {
        this(null, config);
    }

    public LocalECManager(TSIFactory tsif, Configuration config) {
        this.configuration = config;
        this.tsiFactory = tsif;
    }

    @Override
    public ExecutionContext getContext(Action action) throws ExecutionException {
        ExecutionContext ec = action.getExecutionContext();
        if (ec == null) {
            TSI targetSystem = this.tsiFactory.getTSI(action.getClient());
            if (targetSystem == null) {
                throw new RuntimeException("Critical error: no TSI can be loaded.");
            }
            String baseDirectory = targetSystem.resolve(this.configuration.getProperty("XNJS.filespace"));
            if (targetSystem.isLocal()) {
                baseDirectory = new File(baseDirectory).getAbsolutePath();
            }
            targetSystem.setStorageRoot(baseDirectory);
            String wd = action.getUUID();
            String uspace = baseDirectory + targetSystem.getFileSeparator() + wd + targetSystem.getFileSeparator();
            if (targetSystem.getProperties(wd) == null) {
                logger.info((Object)("Creating new uspace for " + action.getUUID() + "\nclient: " + action.getClient()));
                targetSystem.setUmask(action.getUmask());
                targetSystem.mkdir(wd);
            } else {
                logger.info((Object)("Re-connecting to existing uspace " + uspace));
            }
            ec = new ExecutionContext(action.getUUID());
            this.initContext(ec, uspace, false, null, action.getUmask());
            action.setExecutionContext(ec);
        }
        return ec;
    }

    private void initContext(ExecutionContext ec, String wd, boolean isChild, String childUID, String umask) {
        ec.setWorkingDirectory(wd);
        ec.setUmask(umask);
        if (isChild) {
            ec.setStdout("stdout-" + childUID);
            ec.setStderr("stderr-" + childUID);
        }
    }

    @Override
    public ExecutionContext createChildContext(Action parentAction, Action childAction) throws ExecutionException {
        String wd;
        ExecutionContext pc = this.getContext(parentAction);
        if (pc == null) {
            throw new IllegalStateException("Cannot create child context, parent context does not exist");
        }
        ExecutionContext childEc = new ExecutionContext(childAction.getUUID());
        String cwd = wd = pc.getWorkingDirectory();
        this.initContext(childEc, cwd, true, childAction.getUUID(), pc.getUmask());
        childAction.setExecutionContext(childEc);
        return childEc;
    }

    @Override
    public void destroyUSpace(Action action) throws ExecutionException {
        logger.info((Object)("Destroying uspace for " + action.getUUID() + "\nclient: " + action.getClient()));
        TSI targetSystem = this.tsiFactory.getTSI(action.getClient());
        if (targetSystem == null) {
            throw new RuntimeException("Critical error: no TSI can be loaded.");
        }
        try {
            String wd = action.getExecutionContext().getWorkingDirectory();
            targetSystem.rmdir(wd);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public String createUSpace(Action action, String baseDirectory) throws ExecutionException {
        TSI targetSystem = this.tsiFactory.getTSI(action.getClient());
        if (targetSystem == null) {
            throw new RuntimeException("Critical error: no TSI can be loaded.");
        }
        if (targetSystem.isLocal()) {
            baseDirectory = new File(baseDirectory).getAbsolutePath();
        }
        targetSystem.setStorageRoot(baseDirectory);
        String wd = action.getUUID();
        String uspace = baseDirectory + targetSystem.getFileSeparator() + wd + targetSystem.getFileSeparator();
        if (targetSystem.getProperties(wd) == null) {
            logger.info((Object)("Creating new uspace for " + action.getUUID() + "\nclient: " + action.getClient()));
            targetSystem.setUmask(action.getUmask());
            targetSystem.mkdir(wd);
        } else {
            logger.info((Object)("Re-connecting to existing uspace " + uspace));
        }
        return uspace;
    }
}

