/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.simple;

import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.ActionResult;
import de.fzj.unicore.xnjs.ems.ActionStateChangeListener;
import de.fzj.unicore.xnjs.ems.ActionStatus;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.ems.InternalAction;
import de.fzj.unicore.xnjs.ems.InternalManager;
import de.fzj.unicore.xnjs.ems.JobRunner;
import de.fzj.unicore.xnjs.ems.Manager;
import de.fzj.unicore.xnjs.ems.SubAction;
import de.fzj.unicore.xnjs.ems.event.ContinueProcessingEvent;
import de.fzj.unicore.xnjs.ems.event.StartJobEvent;
import de.fzj.unicore.xnjs.ems.event.SubActionDoneEvent;
import de.fzj.unicore.xnjs.ems.event.XnjsEvent;
import de.fzj.unicore.xnjs.management.ManagedComponent;
import de.fzj.unicore.xnjs.persistence.IActionStore;
import de.fzj.unicore.xnjs.simple.BasicManagerMBean;
import de.fzj.unicore.xnjs.tsi.ApplicationInfo;
import de.fzj.unicore.xnjs.tsi.IExecutionSystemInformation;
import de.fzj.unicore.xnjs.util.LogUtil;
import eu.unicore.security.Client;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

@ManagedComponent(mbean=BasicManager.class, name="BasicManager", singleton=false)
public class BasicManager
implements Manager,
InternalManager,
BasicManagerMBean {
    private static final Logger logger = LogUtil.getLogger("unicore.xnjs", BasicManager.class);
    public static final String XNJSWORKERS = "XNJS.numberofworkers";
    private IActionStore jobs;
    private JobRunner[] workers;
    private volatile boolean isAcceptingNewActions = false;
    private volatile boolean isPaused = false;
    private static String GENERAL_LISTENERS = "__generallisteners__";
    private final Map<String, List<ActionStateChangeListener>> eventChangeListeners = new HashMap<String, List<ActionStateChangeListener>>();
    private final AtomicLong storeOperations = new AtomicLong(0L);
    private final Configuration configuration;

    public BasicManager(Configuration config) {
        this.configuration = config;
    }

    @Override
    public Object add(Action action, Client client) throws ExecutionException {
        if (action == null) {
            throw new NullPointerException("Can't add 'null' action.");
        }
        if (!this.isAcceptingNewActions) {
            throw new ExecutionException(1, "XNJS does not accept new actions.");
        }
        try {
            if (this.configuration.getGrounder() != null && client != null) {
                String group;
                String uid = this.configuration.getGrounder().getUserLogin(client, action.getAjd());
                if (uid != null) {
                    client.getXlogin().setSelectedLogin(uid);
                }
                if ((group = this.configuration.getGrounder().getUserGroup(client, action.getAjd())) != null) {
                    client.getXlogin().setSelectedGroup(group);
                }
            }
            action.setClient(client);
            action.addLogTrace("Created with type '" + action.getType() + "'");
            action.addLogTrace("Client: " + client);
            this.configuration.getExecutionContextMgr().getContext(action);
            boolean process = !action.isWaiting();
            this.jobs.put(action.getUUID(), action, process);
        }
        catch (Exception e) {
            if (e instanceof ExecutionException) {
                throw (ExecutionException)e;
            }
            throw new ExecutionException(e);
        }
        this.stateChanged(action.getUUID(), 0);
        return action.getUUID();
    }

    @Override
    public String[] list(Client client) throws ExecutionException {
        Set<String> jobids;
        HashSet<String> list = new HashSet<String>();
        try {
            jobids = this.jobs.getUniqueIDs();
        }
        catch (PersistenceException e) {
            throw new ExecutionException(e);
        }
        for (String id : jobids) {
            if (!this.isAcceptable(client, id)) continue;
            list.add(id);
        }
        return list.toArray(new String[list.size()]);
    }

    protected boolean isAcceptable(Client c, String id) {
        return true;
    }

    public synchronized void start() {
        this.jobs = this.configuration.getActionStore("JOBS");
        int nWorkers = 1;
        try {
            nWorkers = Integer.parseInt(this.configuration.getProperty(XNJSWORKERS, "4"));
        }
        catch (NumberFormatException ex) {
            logger.warn((Object)"Property format error, expected an integer number.", (Throwable)ex);
        }
        this.workers = new JobRunner[nWorkers];
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i] = new JobRunner(this.configuration);
            this.workers[i].start();
        }
        logger.info((Object)("Started " + this.workers.length + " worker threads."));
        this.startAcceptingNewActions();
    }

    public synchronized void stop() {
        this.stopAcceptingNewActions();
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i].interrupt();
        }
    }

    @Override
    public Integer getStatus(String id, Client client) throws ExecutionException {
        try {
            Action a = this.jobs.get(id);
            if (a == null) {
                throw new ExecutionException(3, "No such action: " + id);
            }
            return a.getStatus();
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public Action getAction(String id) throws ExecutionException {
        try {
            Action a = this.jobs.get(id);
            return a;
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    public Action getActionForUpdate(String id) throws TimeoutException, PersistenceException {
        Action a = this.jobs.getForUpdate(id);
        return a;
    }

    @Override
    public Action getNextActionForProcessing() throws InterruptedException, ExecutionException {
        try {
            return this.jobs.getNextActionForProcessing();
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception te) {
            throw new ExecutionException(te);
        }
    }

    public void doneProcessing(Action a) {
        this.doneProcessing(a, true);
    }

    @Override
    public void doneProcessing(Action a, boolean notify) {
        block11: {
            if (a != null) {
                try {
                    this.storeOperations.incrementAndGet();
                    String id = a.getUUID();
                    if (a.getStatus() == 7) {
                        this.jobs.put(id, a, false);
                        if (a instanceof SubAction && notify) {
                            String parent = ((SubAction)a).getParentID();
                            try {
                                this.handleEvent(new SubActionDoneEvent(parent));
                            }
                            catch (Exception ex) {
                                LogUtil.logException("Error sending notification", ex);
                            }
                        }
                        break block11;
                    }
                    if (a.getStatus() != 8) {
                        boolean process = !a.isWaiting();
                        this.jobs.put(id, a, process);
                        if (a.isWaiting() && notify) {
                            this.suspendingAction(id);
                        }
                        break block11;
                    }
                    this.jobs.remove(a);
                    logger.info((Object)("[" + id + "] Action is destroyed."));
                }
                catch (PersistenceException e) {
                    logger.error((Object)"Persistence problem", (Throwable)e);
                }
                catch (TimeoutException te) {
                    logger.error((Object)("Internal Error: can't remove job <" + a.getUUID() + ">"));
                }
            } else {
                logger.warn((Object)"Internal Error: doneProcessing() called with non-existent action?");
            }
        }
    }

    @Override
    public void errorProcessing(Action a, Throwable t) {
        if (a != null) {
            a.addLogTrace("Processing failed, aborting");
            a.addLogTrace(t.getMessage());
            a.setStatus(7);
            a.setResult(new ActionResult(2, t.getMessage()));
            try {
                this.jobs.put(a.getUUID(), a, false);
            }
            catch (PersistenceException pe) {
                logger.error((Object)"Persistence problem", (Throwable)pe);
            }
            if (a instanceof SubAction) {
                String parent = ((SubAction)a).getParentID();
                try {
                    this.handleEvent(new SubActionDoneEvent(parent));
                }
                catch (Exception ex) {
                    LogUtil.logException("Error sending notification", ex);
                }
            }
        } else {
            logger.error((Object)"Internal Error: errorProcessing() called with non-existent action?");
        }
    }

    @Override
    public Object pause(String id, Client client) throws ExecutionException {
        Action a = null;
        try {
            a = this.getActionForUpdate(id);
            if (!ActionStatus.canPause(a.getStatus())) {
                throw new ExecutionException(2, "Cannot pause the action.");
            }
            a.setTransitionalStatus(3);
            String string = "Action will be paused";
            return string;
        }
        catch (Exception te) {
            throw new ExecutionException(te);
        }
        finally {
            if (a != null) {
                try {
                    this.jobs.put(id, a, true);
                }
                catch (PersistenceException pe) {
                    throw new ExecutionException(pe);
                }
            }
        }
    }

    @Override
    public Object resume(String id, Client client) throws ExecutionException {
        Action a = null;
        try {
            a = this.getActionForUpdate(id);
            if (ActionStatus.canResume(a.getStatus())) {
                throw new ExecutionException(2, "Cannot resume the action.");
            }
            a.setTransitionalStatus(4);
            String string = "Action will be resumed";
            return string;
        }
        catch (Exception te) {
            throw new ExecutionException(te);
        }
        finally {
            if (a != null) {
                try {
                    this.jobs.put(id, a, true);
                }
                catch (PersistenceException pe) {
                    throw new ExecutionException(pe);
                }
            }
        }
    }

    @Override
    public Object abort(String id, Client client) throws ExecutionException {
        Action a = null;
        try {
            a = this.getActionForUpdate(id);
            if (a == null) {
                Object var4_4 = null;
                return var4_4;
            }
            if (a.getStatus() == 7) {
                String string = "Action is done.";
                return string;
            }
            if (!ActionStatus.canAbort(a.getStatus())) {
                throw new ExecutionException(2, "Cannot abort the action.");
            }
            a.setTransitionalStatus(2);
            String string = "Action will be aborted";
            return string;
        }
        catch (Exception te) {
            throw new ExecutionException(te);
        }
        finally {
            if (a != null) {
                try {
                    this.jobs.put(id, a, true);
                }
                catch (PersistenceException e) {
                    throw new ExecutionException(e);
                }
            }
        }
    }

    @Override
    public Object run(String id, Client client) throws ExecutionException {
        Action a = null;
        try {
            a = this.getAction(id);
            if (a == null) {
                throw new ExecutionException(3, "Action with id=" + id + " could not be found.");
            }
            int s = a.getStatus();
            if (!ActionStatus.canRun(s)) {
                return null;
            }
            this.handleEvent(new StartJobEvent(id));
        }
        catch (Exception te) {
            throw new ExecutionException(te);
        }
        return 21;
    }

    @Override
    public void stateChanged(String id, Integer newState) {
        List<ActionStateChangeListener> l = this.eventChangeListeners.get(id);
        if (l != null) {
            for (ActionStateChangeListener a : l) {
                try {
                    if (!a.accept(newState)) continue;
                    a.stateChanged(id, newState);
                }
                catch (Exception ex) {
                    logger.warn((Object)"Error sending notifications", (Throwable)ex);
                }
            }
        }
        if ((l = this.eventChangeListeners.get(GENERAL_LISTENERS)) != null) {
            for (ActionStateChangeListener a : l) {
                try {
                    if (!a.accept(newState)) continue;
                    a.stateChanged(id, newState);
                }
                catch (Exception ex) {
                    logger.warn((Object)"Error sending notifications", (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void resumingAction(String id) {
        List<ActionStateChangeListener> l = this.eventChangeListeners.get(id);
        if (l != null) {
            for (ActionStateChangeListener a : l) {
                try {
                    a.resumingAction(id);
                }
                catch (Exception ex) {
                    logger.warn((Object)"Error sending notifications", (Throwable)ex);
                }
            }
        }
        if ((l = this.eventChangeListeners.get(GENERAL_LISTENERS)) != null) {
            for (ActionStateChangeListener a : l) {
                try {
                    a.resumingAction(id);
                }
                catch (Exception ex) {
                    logger.warn((Object)"Error sending notifications", (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void suspendingAction(String id) {
        List<ActionStateChangeListener> l = this.eventChangeListeners.get(id);
        if (l != null) {
            for (ActionStateChangeListener a : l) {
                try {
                    a.suspendingAction(id);
                }
                catch (Exception ex) {
                    logger.warn((Object)"Error sending notifications", (Throwable)ex);
                }
            }
        }
        if ((l = this.eventChangeListeners.get(GENERAL_LISTENERS)) != null) {
            for (ActionStateChangeListener a : l) {
                try {
                    a.suspendingAction(id);
                }
                catch (Exception ex) {
                    logger.warn((Object)"Error sending notifications", (Throwable)ex);
                }
            }
        }
    }

    @Override
    public boolean accept(Integer s) {
        return true;
    }

    @Override
    public synchronized void addChangeListener(String id, ActionStateChangeListener listener) {
        List<ActionStateChangeListener> l;
        if (id == null) {
            id = GENERAL_LISTENERS;
        }
        if ((l = this.eventChangeListeners.get(id)) == null) {
            l = new ArrayList<ActionStateChangeListener>();
            this.eventChangeListeners.put(id, l);
        }
        if (!l.contains(listener)) {
            l.add(listener);
        }
    }

    @Override
    public synchronized void removeChangeListener(String id, ActionStateChangeListener listener) {
        List<ActionStateChangeListener> l;
        if (id == null) {
            id = GENERAL_LISTENERS;
        }
        if ((l = this.eventChangeListeners.get(id)) == null) {
            return;
        }
        l.remove(listener);
    }

    @Override
    public String addSubAction(Serializable jobDescription, String type, Action parentAction, boolean notifyDone) throws ExecutionException {
        String parentUUID = parentAction.getUUID();
        SubAction soa = new SubAction(parentUUID, notifyDone);
        soa.setType(type);
        soa.setRootActionID(parentAction.getRootActionID());
        soa.setClient(parentAction.getClient());
        soa.setAjd(jobDescription);
        soa.setProcessingContext(parentAction.getProcessingContext());
        this.configuration.getExecutionContextMgr().createChildContext(parentAction, soa);
        ApplicationInfo childAppInfo = new ApplicationInfo();
        soa.setApplicationInfo(childAppInfo);
        if (parentAction.getApplicationInfo() != null) {
            childAppInfo.getEnvironment().putAll(parentAction.getApplicationInfo().getEnvironment());
        }
        this.addInternalAction(soa);
        return soa.getUUID();
    }

    @Override
    public Object addInternalAction(InternalAction a) throws ExecutionException {
        a.addLogTrace("Created with type '" + a.getType() + "'");
        a.addLogTrace("Client: " + a.getClient());
        try {
            this.jobs.put(a.getUUID(), a, true);
        }
        catch (PersistenceException pe) {
            throw new ExecutionException(pe);
        }
        logger.debug((Object)("Added new internal action with id=" + a.getUUID() + " into the EMS."));
        return a.getUUID();
    }

    @Override
    public boolean isActionDone(String actionID) throws ExecutionException {
        try {
            Action a = this.jobs.get(actionID);
            if (a == null) {
                throw new ExecutionException(3, "No such action.");
            }
            return a.getStatus() == 7;
        }
        catch (PersistenceException pe) {
            throw new ExecutionException(pe);
        }
    }

    @Override
    public void destroy(String actionID, Client client) throws ExecutionException {
        Action a = null;
        try {
            a = this.jobs.getForUpdate(actionID);
            a.setTransitionalStatus(5);
            logger.debug((Object)("Destroying " + actionID));
        }
        catch (Exception te) {
            throw new ExecutionException(te);
        }
        finally {
            try {
                if (a != null) {
                    this.jobs.put(actionID, a, true);
                }
            }
            catch (PersistenceException pe) {
                LogUtil.logException("Error storing action", pe, logger);
            }
        }
    }

    @Override
    public int getAllJobs() {
        try {
            return this.jobs.size();
        }
        catch (PersistenceException e) {
            LogUtil.logException("Error getting number of actions", e, logger);
            return -1;
        }
    }

    @Override
    public int getDoneJobs() {
        try {
            return this.jobs.size(7);
        }
        catch (PersistenceException e) {
            return -1;
        }
    }

    @Override
    public int getTotalJobsOnSystem() {
        try {
            return this.configuration.getComponentInstanceOfType(IExecutionSystemInformation.class).getTotalNumberOfJobs();
        }
        catch (Exception e) {
            logger.warn((Object)"Could not get number of jobs on the system.", (Throwable)e);
            return -1;
        }
    }

    @Override
    public synchronized void addWorkerThread() {
        try {
            JobRunner[] newWorkers = new JobRunner[this.workers.length + 1];
            for (int j = 0; j < this.workers.length; ++j) {
                newWorkers[j] = this.workers[j];
            }
            newWorkers[this.workers.length] = new JobRunner(this.configuration);
            newWorkers[this.workers.length].start();
            this.workers = newWorkers;
        }
        catch (Exception ex) {
            logger.warn((Object)"Could not add worker.", (Throwable)ex);
        }
    }

    @Override
    public synchronized void removeWorkerThread() {
        if (this.workers.length < 2) {
            throw new IndexOutOfBoundsException("Must have at least one worker.");
        }
        this.workers[this.workers.length - 1].interrupt();
        try {
            JobRunner[] newWorkers = new JobRunner[this.workers.length - 1];
            for (int j = 0; j < newWorkers.length; ++j) {
                newWorkers[j] = this.workers[j];
            }
            this.workers = newWorkers;
        }
        catch (Exception ex) {
            logger.warn((Object)"Could not remove worker.", (Throwable)ex);
        }
    }

    @Override
    public synchronized int getNumberOfWorkerThreads() {
        return this.workers.length;
    }

    @Override
    public boolean getIsAcceptingNewActions() {
        return this.isAcceptingNewActions;
    }

    @Override
    public void stopAcceptingNewActions() {
        this.isAcceptingNewActions = false;
    }

    @Override
    public void startAcceptingNewActions() {
        this.isAcceptingNewActions = true;
    }

    @Override
    public boolean isPaused() {
        return this.isPaused;
    }

    @Override
    public void pauseProcessing() {
        this.isPaused = true;
    }

    @Override
    public void resumeProcessing() {
        this.isPaused = false;
    }

    @Override
    public long getNumberOfStoreOperations() {
        return this.storeOperations.get();
    }

    public IActionStore getActionStore() {
        return this.jobs;
    }

    @Override
    public void handleEvent(final XnjsEvent event) throws ExecutionException {
        if (event == null) {
            return;
        }
        final String actionID = event.getActionID();
        if (event instanceof ContinueProcessingEvent) {
            if (actionID == null) {
                throw new NullPointerException("Can't have ContinueProcessingEvent with null action ID");
            }
        } else {
            throw new IllegalArgumentException("Unknown event type <" + event.getClass().getName() + ">");
        }
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (BasicManager.this.configuration.isStopped()) {
                    return;
                }
                Action a = null;
                try {
                    a = BasicManager.this.getActionForUpdate(actionID);
                    if (a != null) {
                        event.callback(a);
                        BasicManager.this.resumingAction(actionID);
                    }
                }
                catch (Exception ex) {
                    LogUtil.logException("Error processing continue event for action  <" + actionID + ">", ex, logger);
                    if (logger.isDebugEnabled()) {
                        try {
                            Action d = BasicManager.this.getAction(actionID);
                            if (d != null) {
                                logger.debug((Object)d.toString());
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    logger.info((Object)("Re-queue continue event for <" + actionID + ">, reason: " + LogUtil.createFaultMessage("Error processing continue event for action  <" + actionID + ">", ex)));
                    BasicManager.this.configuration.getScheduledExecutor().schedule(this, 5000L, TimeUnit.MILLISECONDS);
                }
                finally {
                    if (a != null) {
                        try {
                            BasicManager.this.jobs.put(actionID, a, true);
                        }
                        catch (PersistenceException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
        };
        this.configuration.getScheduledExecutor().schedule(r, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void scheduleEvent(final XnjsEvent event, int time, TimeUnit units) throws RejectedExecutionException {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    BasicManager.this.configuration.getInternalManager().handleEvent(event);
                }
                catch (Exception ex) {
                    logger.error((Object)"Error processing event", (Throwable)ex);
                }
            }
        };
        this.configuration.getScheduledExecutor().schedule(r, (long)time, units);
    }
}

