/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.simple;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.ActionResult;
import de.fzj.unicore.xnjs.ems.ExecutionContext;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.incarnation.ITweaker;
import de.fzj.unicore.xnjs.io.XnjsFileWithACL;
import de.fzj.unicore.xnjs.jsdl.IncarnationDataBase;
import de.fzj.unicore.xnjs.legacy.TSIUtils;
import de.fzj.unicore.xnjs.management.ManagedComponent;
import de.fzj.unicore.xnjs.simple.LocalExecution;
import de.fzj.unicore.xnjs.simple.jmx.LocalExecutionJmx;
import de.fzj.unicore.xnjs.tsi.ApplicationInfo;
import de.fzj.unicore.xnjs.tsi.IExecution;
import de.fzj.unicore.xnjs.tsi.IExecutionSystemInformation;
import de.fzj.unicore.xnjs.tsi.TSI;
import de.fzj.unicore.xnjs.tsi.TSIBusyException;
import de.fzj.unicore.xnjs.util.LogUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

@ManagedComponent(mbean=LocalExecutionJmx.class, name="LocalExecution", singleton=true)
public class BasicExecution
implements IExecution,
IExecutionSystemInformation {
    protected static final Logger jobExecLogger = LogUtil.getLogger("unicore.services.jobexecution", "Execution");
    protected static final String emailRE = "([[\\w-]\\.]+)@([\\w-]+\\.)([\\w-]+)(\\.[\\w-]+)*";
    public static final Pattern pattern = Pattern.compile("([[\\w-]\\.]+)@([\\w-]+\\.)([\\w-]+)(\\.[\\w-]+)*");
    public static final String PROPERTY_USE_EMAIL_FROM_CERT = "XNJS.use.email.from.certificate";
    public static final String PROPERTY_USE_SHELL = "XNJS.localtsi.useShell";
    public static final String PROPERTY_SHELL = "XNJS.localtsi.shell";
    public static final String PROPERTY_STAGING_FS_GRACE = "XNJS.staging.filesystem.grace";
    public static final String DEFAULT_SHELL = "/bin/bash";
    protected final ITweaker incarnationTweaker;
    protected final Configuration configuration;
    public static final String CUSTOM_GRACE_PERIOD = "CLASSICTSI.statusupdate.grace.custom";
    public static final String GRACE_PERIOD = "CLASSICTSI.statusupdate.grace";
    protected static final String GRACE_PERIOD_start = "CLASSICTSI.statusupdate.grace.start";
    protected static final String EXITCODE_RECHECK = "CLASSICTSI.statusupdate.exitcode.recheck";

    public BasicExecution(Configuration config) {
        this.configuration = config;
        this.incarnationTweaker = config.getComponentInstanceOfType(ITweaker.class);
    }

    @Override
    public void submit(Action job) throws TSIBusyException, ExecutionException {
        ApplicationInfo appDescription = job.getApplicationInfo();
        this.incarnationTweaker.preScript(appDescription, job, this.configuration.getIDB());
        TSI tsi = this.configuration.getTargetSystemInterface(job.getClient());
        ExecutionContext ec = job.getExecutionContext();
        tsi.exec(this.buildCommand(job, this.configuration.getIDB()), ec);
        job.addLogTrace("Submitted executable: " + appDescription.getExecutable());
    }

    public static String getEmailAddress(String source) {
        Matcher m = pattern.matcher(source);
        if (m.find()) {
            return m.group();
        }
        return null;
    }

    private String buildCommand(Action job, IncarnationDataBase idb) throws ExecutionException {
        String result;
        boolean useShell = Boolean.parseBoolean(this.configuration.getIDB().getProperty(PROPERTY_USE_SHELL));
        if (useShell && System.getProperty("os.name").toLowerCase().indexOf("windows") == -1) {
            result = this.buildShellWrappedCommand(job, idb);
            job.getProcessingContext().put("localts.mode.shell", Boolean.TRUE);
            job.setDirty();
        } else {
            result = this.buildDirectCommand(job, idb);
        }
        return this.incarnationTweaker.postScript(job.getApplicationInfo(), job, idb, result);
    }

    private String buildShellWrappedCommand(Action jsdlAction, IncarnationDataBase idb) throws ExecutionException {
        String workDir = jsdlAction.getExecutionContext().getWorkingDirectory();
        File wd = new File(workDir);
        if (!wd.isAbsolute()) {
            workDir = wd.getAbsolutePath();
            jsdlAction.getExecutionContext().setWorkingDirectory(workDir);
        }
        String tmpName = "TSI_submit_" + System.currentTimeMillis();
        String cmdFile = workDir + tmpName;
        String cmd = TSIUtils.makeSubmitCommand(jsdlAction, this.configuration);
        OutputStreamWriter writer = null;
        try {
            TSI tsi = this.configuration.getTargetSystemInterface(jsdlAction.getClient());
            writer = new OutputStreamWriter(tsi.getOutputStream(cmdFile));
            writer.write(cmd);
            writer.close();
        }
        catch (IOException ioe) {
            throw new ExecutionException(ioe);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ioe) {
                throw new ExecutionException(ioe);
            }
        }
        String shell = this.configuration.getIDB().getProperty(PROPERTY_SHELL, DEFAULT_SHELL);
        return shell + " " + cmdFile;
    }

    protected String buildDirectCommand(Action job, IncarnationDataBase idb) {
        ApplicationInfo appDescription = job.getApplicationInfo();
        StringBuffer res = new StringBuffer();
        res.append(appDescription.getExecutable());
        for (String at : appDescription.getArguments()) {
            res.append(" " + at);
        }
        return res.toString();
    }

    @Override
    public void abort(Action job) throws ExecutionException {
        try {
            if (job.getStatus() == 5 && LocalExecution.isRunning(job.getUUID())) {
                LocalExecution.abort(job.getUUID());
                job.addLogTrace("User aborted.");
                job.setStatus(7);
                job.addLogTrace("Status set to DONE.");
                job.setResult(new ActionResult(1));
            }
        }
        catch (Exception ex) {
            throw new ExecutionException(ex);
        }
    }

    @Override
    public void pause(Action job) throws ExecutionException {
        throw new IllegalStateException("Operation is not supported.");
    }

    @Override
    public void resume(Action job) throws ExecutionException {
        throw new IllegalStateException("Operation is not supported.");
    }

    @Override
    public void checkpoint(Action job) throws ExecutionException {
        throw new IllegalStateException("Operation is not supported.");
    }

    @Override
    public void restart(Action job) throws ExecutionException {
        throw new IllegalStateException("Operation is not supported.");
    }

    @Override
    public void updateStatus(Action job) throws ExecutionException {
        try {
            if (job.getStatus() == 22) {
                job.setStatus(5);
            } else if (job.getStatus() == 5) {
                boolean shellMode;
                this.updateProgress(job);
                boolean bl = shellMode = job.getProcessingContext().get("localts.mode.shell") != null;
                if (shellMode) {
                    this.updateExitCodeShellMode(job);
                } else {
                    this.updateExitCodeLocal(job);
                }
            }
        }
        catch (Exception ex) {
            throw new ExecutionException(ex);
        }
    }

    private void updateExitCodeLocal(Action job) {
        String uid = job.getUUID();
        if (!LocalExecution.isRunning(uid)) {
            Integer exit = LocalExecution.getExitCode(uid);
            if (exit == null) {
                job.fail();
            } else {
                job.getExecutionContext().setExitCode(exit);
                job.setStatus(6);
                jobExecLogger.debug((Object)("[" + uid + "] Status set to POSTPROCESSING."));
                job.addLogTrace("Status set to POSTPROCESSING.");
            }
        }
    }

    private void updateExitCodeShellMode(Action job) throws Exception {
        String uid = job.getUUID();
        if (LocalExecution.isRunning(uid)) {
            return;
        }
        boolean haveExitCode = this.getExitCode(job);
        if (!haveExitCode) {
            Integer g;
            int myGracePeriod = 0;
            Long timeOfFirstStatusCheck = (Long)job.getProcessingContext().get(GRACE_PERIOD_start);
            if (timeOfFirstStatusCheck == null) {
                timeOfFirstStatusCheck = System.currentTimeMillis();
                job.getProcessingContext().put(GRACE_PERIOD_start, timeOfFirstStatusCheck);
                job.setDirty();
            }
            if ((g = (Integer)job.getProcessingContext().get(CUSTOM_GRACE_PERIOD)) != null) {
                myGracePeriod = g;
            }
            if (System.currentTimeMillis() < timeOfFirstStatusCheck + (long)myGracePeriod) {
                if (jobExecLogger.isDebugEnabled()) {
                    jobExecLogger.debug((Object)("No exit code found for " + uid + ", assuming it is still running."));
                }
            } else {
                if (jobExecLogger.isDebugEnabled()) {
                    jobExecLogger.debug((Object)("No BSS status found for " + uid + ", assuming it is completed."));
                }
                job.setStatus(6);
            }
        } else {
            if (jobExecLogger.isDebugEnabled()) {
                jobExecLogger.debug((Object)("Have exit code for " + uid + ", assuming it is completed."));
            }
            job.setStatus(6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean getExitCode(Action job) throws Exception {
        TSI tsi = this.configuration.getTargetSystemInterface(job.getClient());
        ExecutionContext ctx = job.getExecutionContext();
        InputStream is = null;
        BufferedReader br = null;
        try {
            tsi.setStorageRoot(ctx.getOutcomeDirectory());
            XnjsFileWithACL f = tsi.getProperties(ctx.getExitCodeFileName());
            if (f == null) {
                boolean bl = false;
                return bl;
            }
            is = tsi.getInputStream(ctx.getExitCodeFileName());
            br = new BufferedReader(new InputStreamReader(is));
            try {
                String s = br.readLine();
                if (s != null) {
                    int i = Integer.parseInt(s);
                    ctx.setExitCode(i);
                    job.addLogTrace("Exit code " + i);
                    jobExecLogger.debug((Object)("Script exited with code <" + i + ">"));
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e) {
                jobExecLogger.debug((Object)"Could not retrieve exit code.", (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    protected void updateProgress(Action job) {
        try {
            Integer j = (Integer)job.getProcessingContext().get("UNICORE_PROGRESS_INDICATION_UNAVAILABLE");
            if (j != null && j > 3) {
                return;
            }
            TSI tsi = this.configuration.getTargetSystemInterface(job.getClient());
            InputStream is = tsi.getInputStream(job.getExecutionContext().getWorkingDirectory() + "/" + ".UNICORE_PROGRESS_INDICATION");
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String s = br.readLine();
            br.close();
            if (s != null) {
                Float f = Float.valueOf(Float.parseFloat(s));
                jobExecLogger.info((Object)("Found progress value <" + f + "> for job " + job.getUUID()));
                job.getExecutionContext().setProgress(f);
                job.setDirty();
            } else {
                if (j == null) {
                    j = 1;
                }
                Integer n = j;
                Integer n2 = j = Integer.valueOf(j + 1);
                job.getProcessingContext().put("UNICORE_PROGRESS_INDICATION_UNAVAILABLE", j);
                job.setDirty();
            }
        }
        catch (NumberFormatException nfe) {
            jobExecLogger.warn((Object)("Application wrote faulty progress file for action " + job.getUUID()));
        }
        catch (ExecutionException ee) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int getNumberOfQueuedJobs() {
        return this.getTotalNumberOfJobs() - this.getNumberOfRunningJobs();
    }

    @Override
    public int getNumberOfRunningJobs() {
        return LocalExecution.getNumberOfRunningJobs();
    }

    @Override
    public int getTotalNumberOfJobs() {
        return LocalExecution.getTotalNumberOfJobs();
    }

    @Override
    public Map<String, Integer> getQueueFill() {
        return null;
    }
}

