/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.resources;

import de.fzj.unicore.xnjs.resources.BaseResource;
import de.fzj.unicore.xnjs.resources.Resource;
import java.util.ArrayList;
import java.util.List;

public class ValueListResource
extends BaseResource {
    private static final long serialVersionUID = 1L;
    protected final List<String> validValues = new ArrayList<String>();
    protected String selectedValue;

    public ValueListResource(String name, String val, List<String> allowed, Resource.Category category) {
        super(name, category);
        this.validValues.addAll(allowed);
        this.selectedValue = val;
    }

    public void setSelectedValue(String val) {
        this.selectedValue = val;
    }

    @Override
    public void setStringValue(String val) {
        this.selectedValue = val;
    }

    public void setValidValues(List<String> values) {
        this.validValues.addAll(values);
    }

    public String[] getValidValues() {
        return this.validValues.toArray(new String[this.validValues.size()]);
    }

    @Override
    public Object getValue() {
        return this.selectedValue;
    }

    @Override
    public boolean isInRange(Object otherValue) {
        String otherSelected;
        if (otherValue instanceof String) {
            otherSelected = (String)otherValue;
        } else {
            if (!(otherValue instanceof ValueListResource)) {
                return false;
            }
            ValueListResource otherList = (ValueListResource)otherValue;
            otherSelected = otherList.selectedValue;
        }
        return otherSelected == null || this.validValues.contains(otherSelected);
    }

    @Override
    public Resource copy() {
        return new ValueListResource(this.name, this.selectedValue, this.validValues, this.category);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append("[choice, category=").append((Object)this.category).append("] ").append(this.selectedValue);
        sb.append(" choices=").append(this.validValues);
        return sb.toString();
    }
}

