/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.resources;

import de.fzj.unicore.xnjs.resources.BaseResource;
import de.fzj.unicore.xnjs.resources.Resource;

public class StringResource
extends BaseResource {
    private static final long serialVersionUID = 1L;
    private String value;

    public StringResource(String name, String value, Resource.Category category) {
        super(name, category);
        this.value = value;
    }

    public StringResource(String name, String value) {
        this(name, value, null);
    }

    @Override
    public Resource copy() {
        return new StringResource(this.name, this.value, this.category);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setStringValue(String val) {
        this.value = val;
    }

    @Override
    public boolean isInRange(Object otherValue) {
        if (!otherValue.getClass().isAssignableFrom(StringResource.class) && !(otherValue instanceof String)) {
            throw new IllegalArgumentException("Need StringResource, found " + otherValue.getClass());
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append("[string, category=").append((Object)this.category).append("] ").append(this.value);
        return sb.toString();
    }
}

