/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.resources;

import de.fzj.unicore.xnjs.resources.Resource;
import de.fzj.unicore.xnjs.resources.ResourceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourceSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Map<String, Resource> resources = new HashMap<String, Resource>();
    private final List<String> unmatched = new ArrayList<String>();
    protected final List<ResourceRequest> resourceRequests = new ArrayList<ResourceRequest>();

    public ResourceSet copy() {
        ResourceSet s = new ResourceSet();
        for (Map.Entry<String, Resource> e : this.resources.entrySet()) {
            s.resources.put(e.getKey(), e.getValue().copy());
        }
        return s;
    }

    public Resource getResource(String name) {
        return this.resources.get(name);
    }

    public void putResource(Resource value) {
        this.resources.put(value.getName(), value);
    }

    public Resource removeResource(String name) {
        return this.resources.remove(name);
    }

    public Collection<Resource> getResources() {
        return Collections.unmodifiableCollection(this.resources.values());
    }

    public boolean checkBounds(ResourceSet other) {
        boolean ok = true;
        for (Resource r : other.resources.values()) {
            Resource def = this.resources.get(r.getName());
            if (def == null || def.isInRange(r)) continue;
            other.markUnmatchedResource(r.getName());
            ok = false;
        }
        return ok;
    }

    public boolean containsResource(Resource.Category category) {
        boolean result = false;
        for (Resource r : this.resources.values()) {
            if (!category.equals((Object)r.getCategory())) continue;
            result = true;
            break;
        }
        return result;
    }

    public void markUnmatchedResource(String name) {
        this.unmatched.add(name);
    }

    public List<String> getUnmatchedResourceNames() {
        return this.unmatched;
    }

    public List<ResourceRequest> getResourceRequests() {
        return this.resourceRequests;
    }

    public String printAsRequest() {
        StringBuilder sb = new StringBuilder();
        for (Resource r : this.resources.values()) {
            sb.append(r.getName() + " = " + r.getStringValue()).append("\n");
        }
        return sb.toString();
    }

    public String printSelected() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Resource r : this.resources.values()) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(r.getName()).append(" = ").append(r.getStringValue());
        }
        return sb.toString();
    }
}

