/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.resources;

import de.fzj.unicore.xnjs.resources.BaseResource;
import de.fzj.unicore.xnjs.resources.RangeResource;
import de.fzj.unicore.xnjs.resources.Resource;

public class IntResource
extends BaseResource
implements RangeResource {
    private static final long serialVersionUID = 1L;
    private Integer value;
    private final Integer upper;
    private final Integer lower;

    public IntResource(String name, Integer value, Integer upper, Integer lower, Resource.Category category) {
        super(name, category);
        this.value = value;
        this.upper = upper;
        this.lower = lower;
    }

    public IntResource(String name, Integer value) {
        this(name, value, null, null, null);
    }

    @Override
    public Resource copy() {
        return new IntResource(this.name, this.value, this.upper, this.lower, this.category);
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public void setStringValue(String v) {
        this.value = Integer.parseInt(v);
    }

    @Override
    public boolean isInRange(Object otherValue) {
        Integer v;
        if (otherValue instanceof String) {
            try {
                v = Integer.parseInt((String)otherValue);
            }
            catch (NumberFormatException ex) {
                return false;
            }
        } else if (otherValue instanceof Integer) {
            v = (Integer)otherValue;
        } else {
            if (!otherValue.getClass().isAssignableFrom(IntResource.class)) {
                throw new IllegalArgumentException("Can't check range, need Float value, found " + otherValue.getClass());
            }
            v = ((IntResource)otherValue).getValue();
            if (v == null) {
                return true;
            }
        }
        if (this.upper != null && this.upper.compareTo(v) < 0) {
            return false;
        }
        return this.lower == null || this.lower.compareTo(v) <= 0;
    }

    @Override
    public Integer getUpper() {
        return this.upper;
    }

    @Override
    public Integer getLower() {
        return this.lower;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append("[int, category=").append((Object)this.category).append("] ").append(this.value);
        sb.append(" lower=").append(this.lower);
        sb.append(" upper=").append(this.upper);
        return sb.toString();
    }
}

