/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.resources;

import de.fzj.unicore.xnjs.resources.BaseResource;
import de.fzj.unicore.xnjs.resources.RangeResource;
import de.fzj.unicore.xnjs.resources.Resource;

public class DoubleResource
extends BaseResource
implements RangeResource {
    private static final long serialVersionUID = 1L;
    private Double value;
    private final Double upper;
    private final Double lower;

    public DoubleResource(String name, Double value, Double upper, Double lower, Resource.Category category) {
        super(name, category);
        this.value = value;
        this.upper = upper;
        this.lower = lower;
    }

    public DoubleResource(String name, Double value) {
        this(name, value, null, null, null);
    }

    @Override
    public Resource copy() {
        return new DoubleResource(this.name, this.value, this.upper, this.lower, this.category);
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public void setStringValue(String v) {
        this.value = Double.parseDouble(v);
    }

    @Override
    public boolean isInRange(Object otherValue) {
        Double v;
        if (otherValue instanceof String) {
            try {
                v = Double.parseDouble((String)otherValue);
            }
            catch (NumberFormatException ex) {
                return false;
            }
        } else if (otherValue instanceof Double) {
            v = (Double)otherValue;
        } else {
            if (!otherValue.getClass().isAssignableFrom(DoubleResource.class)) {
                throw new IllegalArgumentException("Can't check range, need Double value, found " + otherValue.getClass());
            }
            v = ((DoubleResource)otherValue).getValue();
            if (v == null) {
                return true;
            }
        }
        if (this.upper != null && this.upper.compareTo(v) < 0) {
            return false;
        }
        return this.lower == null || this.lower.compareTo(v) <= 0;
    }

    @Override
    public Double getUpper() {
        return this.upper;
    }

    @Override
    public Double getLower() {
        return this.lower;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append("[double, category=").append((Object)this.category).append("] ").append(this.value);
        sb.append(" lower=").append(this.lower);
        sb.append(" upper=").append(this.upper);
        return sb.toString();
    }
}

