/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.resources;

import de.fzj.unicore.xnjs.resources.BaseResource;
import de.fzj.unicore.xnjs.resources.Resource;

public class BooleanResource
extends BaseResource {
    private static final long serialVersionUID = 1L;
    private Boolean value;

    public BooleanResource(String name, Boolean value, Resource.Category category) {
        super(name, category);
        this.value = value;
    }

    @Override
    public Resource copy() {
        return new BooleanResource(this.name, this.value, this.category);
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public boolean isInRange(Object otherValue) {
        if (otherValue instanceof String) {
            String v = (String)otherValue;
            return "true".equalsIgnoreCase(v) || "false".equalsIgnoreCase(v);
        }
        return otherValue instanceof BooleanResource || otherValue instanceof Boolean;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append("=").append(this.value);
        return sb.toString();
    }

    @Override
    public void setStringValue(String value) {
        this.value = Boolean.parseBoolean(value);
    }
}

