/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.persistence;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.XNJSException;
import de.fzj.unicore.xnjs.management.Dependency;
import de.fzj.unicore.xnjs.persistence.IActionStore;
import de.fzj.unicore.xnjs.persistence.IActionStoreFactory;
import de.fzj.unicore.xnjs.persistence.JDBCActionStore;
import de.fzj.unicore.xnjs.util.LogUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

@Dependency(classes={JDBCActionStore.class})
public class JDBCActionStoreFactory
implements IActionStoreFactory {
    private static final Logger logger = LogUtil.getLogger("unicore.persistence", JDBCActionStoreFactory.class);
    private final Map<String, IActionStore> map = new HashMap<String, IActionStore>();

    @Override
    public IActionStore getInstance(String id, Configuration config) throws XNJSException {
        IActionStore m = this.map.get(id);
        if (m == null) {
            try {
                m = config.getComponentInstanceOfType(JDBCActionStore.class);
            }
            catch (Exception e) {
                String msg = "Could not create persistence class <" + JDBCActionStore.class.getName() + ">";
                logger.error((Object)msg, (Throwable)e);
                throw new XNJSException(msg, e);
            }
            try {
                m.setName(id);
                m.start();
                this.map.put(id, m);
            }
            catch (Exception e) {
                String msg = "Could not start persistence class <" + JDBCActionStore.class.getName() + ">";
                logger.error((Object)msg, (Throwable)e);
                throw new XNJSException(msg, e);
            }
        }
        return m;
    }
}

