/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.persistence;

import de.fzj.unicore.persist.DataVersionException;
import de.fzj.unicore.persist.Persist;
import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.persist.PersistenceFactory;
import de.fzj.unicore.persist.PersistenceProperties;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.management.JMX;
import de.fzj.unicore.xnjs.management.ManagedComponent;
import de.fzj.unicore.xnjs.persistence.AbstractActionStore;
import de.fzj.unicore.xnjs.persistence.DoneAction;
import de.fzj.unicore.xnjs.persistence.JDBCActionStoreMBean;
import eu.unicore.util.Log;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

@ManagedComponent(mbean=JDBCActionStore.class, name="ActionStorage")
public class JDBCActionStore
extends AbstractActionStore
implements JDBCActionStoreMBean {
    private Persist<Action> activeJobs;
    private Persist<DoneAction> doneJobs;
    private int getForUpdateTimeoutPeriod = 5;

    public JDBCActionStore(Configuration config) {
        super(config);
    }

    @Override
    public void start() {
        super.start();
        JMX.registerMBean(this);
    }

    @Override
    public void stop() {
        try {
            this.activeJobs.shutdown();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.doneJobs.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.stop();
    }

    @Override
    protected Action doGet(String id) throws PersistenceException {
        Action a = null;
        DoneAction da = (DoneAction)this.doneJobs.read(id);
        if (da != null) {
            a = da.getAction();
        }
        if (a == null) {
            a = (Action)this.activeJobs.read(id);
        }
        return a;
    }

    @Override
    protected Action doGetForUpdate(String id) throws PersistenceException, TimeoutException {
        try {
            Action a = null;
            DoneAction da = (DoneAction)this.doneJobs.getForUpdate(id, (long)this.getForUpdateTimeoutPeriod, TimeUnit.SECONDS);
            if (da != null) {
                a = da.getAction();
            }
            if (a != null) {
                return a;
            }
            a = (Action)this.activeJobs.getForUpdate(id, (long)this.getForUpdateTimeoutPeriod, TimeUnit.SECONDS);
            return a;
        }
        catch (InterruptedException te) {
            throw new TimeoutException(te.getMessage());
        }
    }

    @Override
    protected void doInit() throws PersistenceException {
        String stateDir = this.configuration.getProperty("XNJS.statedir");
        if (stateDir != null) {
            this.configuration.setProperty("persistence.directory.JOBS", stateDir);
            this.configuration.setProperty("persistence.directory.FINISHED_JOBS", stateDir);
        }
        PersistenceProperties config = new PersistenceProperties(this.configuration.getProperties());
        this.activeJobs = PersistenceFactory.get((PersistenceProperties)config).getPersist(Action.class);
        this.checkVersion(this.activeJobs, "JOBS");
        this.doneJobs = PersistenceFactory.get((PersistenceProperties)config).getPersist(DoneAction.class);
    }

    protected void checkVersion(Persist<?> p, String tableName) throws PersistenceException {
        block8: {
            Set ids = p.getIDs();
            try {
                if (ids.size() <= 0) break block8;
                p.read((String)ids.iterator().next());
            }
            catch (DataVersionException v) {
                if (!Boolean.getBoolean("unicore.update.force")) {
                    throw v;
                }
                logger.info((Object)("Removing unreadable data from table " + tableName));
                for (String id : ids) {
                    try {
                        p.read(id);
                    }
                    catch (DataVersionException ex) {
                        try {
                            p.remove(id);
                        }
                        catch (PersistenceException pe) {
                            Log.logException((String)("Error removing " + id + " from table " + tableName), (Throwable)pe, (Logger)logger);
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void doRemove(Action a) throws PersistenceException {
        this.activeJobs.remove(a.getUUID());
        this.doneJobs.remove(a.getUUID());
    }

    @Override
    protected void doStore(Action action) throws PersistenceException {
        if (action.isDirty()) {
            if (action.getStatus() != 7) {
                this.activeJobs.write((Object)action);
            } else {
                this.doneJobs.write((Object)new DoneAction(action));
                this.activeJobs.remove(action.getUUID());
            }
        } else if (action.getStatus() != 7) {
            this.activeJobs.unlock((Object)action);
        } else {
            this.doneJobs.unlock((Object)new DoneAction(action));
        }
    }

    @Override
    public Set<String> getUniqueIDs() throws PersistenceException {
        Set all = this.activeJobs.getIDs();
        all.addAll(this.doneJobs.getIDs());
        return all;
    }

    @Override
    public Set<String> getActiveUniqueIDs() throws PersistenceException {
        return this.activeJobs.getIDs();
    }

    @Override
    public int size() throws PersistenceException {
        int all = this.activeJobs.getRowCount();
        return all += this.doneJobs.getRowCount();
    }

    public String toString() {
        try {
            return super.toString() + "\n" + this.printDiagnostics();
        }
        catch (Exception e) {
            return "N/A. An error occurred: [" + e.getClass().getName() + "] message: +" + e.getMessage();
        }
    }

    @Override
    public void setTimeoutPeriod(int time) {
        this.getForUpdateTimeoutPeriod = time;
    }

    @Override
    public void removeAll() throws PersistenceException {
        this.activeJobs.removeAll();
        this.doneJobs.removeAll();
    }
}

