/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.persistence;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.persistence.AbstractActionStore;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class BasicActionStore
extends AbstractActionStore {
    private final Map<String, Action> map = new ConcurrentHashMap<String, Action>();

    public BasicActionStore(Configuration config) {
        super(config);
    }

    @Override
    protected void doInit() {
    }

    @Override
    public Set<String> getUniqueIDs() {
        return this.map.keySet();
    }

    @Override
    public Set<String> getActiveUniqueIDs() {
        return this.getUniqueIDs();
    }

    @Override
    protected Action doGet(String id) {
        return this.map.get(id);
    }

    @Override
    protected Action doGetForUpdate(String id) {
        return this.map.get(id);
    }

    @Override
    protected void doRemove(Action action) {
        this.map.remove(action.getUUID());
    }

    @Override
    protected void doStore(Action action) {
        this.map.put(action.getUUID(), action);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public int size(int actionStatus) {
        int i = 0;
        for (Action action : this.map.values()) {
            if (action.getStatus() != actionStatus) continue;
            ++i;
        }
        return i;
    }

    @Override
    public void removeAll() {
        this.map.clear();
    }
}

