/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.persistence;

import de.fzj.unicore.metrix.IMetric;
import de.fzj.unicore.metrix.MetricRegistry;
import de.fzj.unicore.metrix.exceptions.MetricIDAlreadyExistsException;
import de.fzj.unicore.metrix.metrics.MeanFloatValue;
import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.persistence.IActionStore;
import de.fzj.unicore.xnjs.util.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public abstract class AbstractActionStore
implements IActionStore {
    protected static final Logger logger = LogUtil.getLogger("unicore.persistence", AbstractActionStore.class);
    public static final int QUEUE_DELAY = 50;
    public static final String QUEUE_REFILL_INTERVAL = "xnjs.queue.refill.delay";
    protected String id;
    protected String name;
    protected MeanFloatValue meanReadTime;
    protected MeanFloatValue meanWriteTime;
    private int numberOfRefillOperations = 0;
    private static final AtomicInteger idGenerator = new AtomicInteger(0);
    protected final DelayQueue<QueueEntry> queue = new DelayQueue<QueueEntry>(){

        @Override
        public boolean add(QueueEntry o) {
            if (this.contains(o)) {
                return true;
            }
            return super.add(o);
        }
    };
    protected final Map<String, Integer> states = new ConcurrentHashMap<String, Integer>();
    protected final Configuration configuration;

    public AbstractActionStore(Configuration configuration) {
        this.configuration = configuration;
        this.id = String.valueOf(idGenerator.incrementAndGet());
        this.meanReadTime = new MeanFloatValue("xnjs.store.mean_read_time." + this.id, "ms", new String[]{"performance"});
        this.meanWriteTime = new MeanFloatValue("xnjs.store.mean_write_time." + this.id, "ms", new String[]{"performance"});
        try {
            MetricRegistry.getInstance().registerMetric((IMetric)this.meanWriteTime);
            MetricRegistry.getInstance().registerMetric((IMetric)this.meanReadTime);
        }
        catch (MetricIDAlreadyExistsException me) {
            logger.error((Object)me);
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    protected void doCleanup() throws PersistenceException, TimeoutException {
        for (String key : this.getUniqueIDs()) {
            Action a = this.getForUpdate(key);
            if (a == null) continue;
            this.remove(a);
        }
    }

    public void start() {
        try {
            this.doInit();
        }
        catch (Exception e) {
            logger.error((Object)"Error initialising persistence.", (Throwable)e);
            throw new RuntimeException(e);
        }
        if (this.configuration.getProperty("de.fzj.unicore.xnjs.persistence.clearAllOnStartup") != null || System.getProperty("de.fzj.unicore.xnjs.persistence.clearAllOnStartup") != null) {
            logger.info((Object)"Clearing action store.");
            try {
                this.doCleanup();
            }
            catch (Exception e) {
                logger.error((Object)"Can't cleanup!", (Throwable)e);
            }
        }
        this.refill();
        String delayP = this.configuration.getProperty(QUEUE_REFILL_INTERVAL, "10");
        Integer delay = 10000;
        try {
            delay = 1000 * Integer.parseInt(delayP);
        }
        catch (NumberFormatException nfe) {
            logger.error((Object)("Configuration problem: <" + delayP + "> does not denote an integer. Using fallback value of '10'"));
        }
        if (Boolean.parseBoolean(this.configuration.getProperty("persistence.cluster.enable", "false"))) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    AbstractActionStore.this.refill();
                }
            };
            this.configuration.getScheduledExecutor().scheduleWithFixedDelay(r, delay.intValue(), delay.intValue(), TimeUnit.MILLISECONDS);
        }
    }

    public void stop() {
    }

    protected abstract void doInit() throws Exception;

    @Override
    public Action get(String key) throws PersistenceException {
        return this.doGet(key);
    }

    @Override
    public Action getForUpdate(String key) throws TimeoutException, PersistenceException {
        Action a = this.doGetForUpdate(key);
        if (a != null) {
            this.states.put(key, a.getStatus());
            a.setWaiting(false);
        }
        return a;
    }

    @Override
    public Action getNextActionForProcessing() throws InterruptedException, TimeoutException, PersistenceException {
        long start = System.currentTimeMillis();
        QueueEntry q = (QueueEntry)this.queue.poll(50L, TimeUnit.MILLISECONDS);
        if (q == null) {
            return null;
        }
        String key = q.actionID;
        try {
            Action act = this.getForUpdate(key);
            float duration = System.currentTimeMillis() - start;
            this.meanReadTime.push((Object[])new Float[]{Float.valueOf(duration)});
            if (act != null) {
                act.setWaiting(false);
            }
            return act;
        }
        catch (TimeoutException te) {
            this.queue.offer(q);
            return null;
        }
    }

    public float getMeanReadTime() {
        return ((Float)this.meanReadTime.getValue().getResultObject()).floatValue();
    }

    public float getMeanWriteTime() {
        return ((Float)this.meanWriteTime.getValue().getResultObject()).floatValue();
    }

    public int getNumberOfReads() {
        return this.meanReadTime.getNumberOfDataPoints();
    }

    public int getNumberOfWrites() {
        return this.meanWriteTime.getNumberOfDataPoints();
    }

    public int getActionsInQueue() {
        return this.queue.size();
    }

    public int getTotalActionsInStore() {
        try {
            return this.size();
        }
        catch (PersistenceException pe) {
            return -1;
        }
    }

    public String printStorageOverview() {
        return this.toString();
    }

    @Override
    public void put(String key, Action value) throws PersistenceException {
        this.put(key, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, Action value, boolean process) throws PersistenceException {
        long start = System.currentTimeMillis();
        try {
            this.doStore(value);
            this.states.put(key, value.getStatus());
            if (process) {
                this.queue.add(new QueueEntry(key));
            }
        }
        catch (Throwable throwable) {
            float duration = System.currentTimeMillis() - start;
            this.meanWriteTime.push((Object[])new Float[]{Float.valueOf(duration)});
            throw throwable;
        }
        float duration = System.currentTimeMillis() - start;
        this.meanWriteTime.push((Object[])new Float[]{Float.valueOf(duration)});
    }

    @Override
    public void remove(Action a) throws PersistenceException {
        this.states.remove(a.getUUID());
        this.doRemove(a);
    }

    public void refill() {
        try {
            for (String i : this.getActiveUniqueIDs()) {
                this.queue.add(new QueueEntry(i));
            }
            ++this.numberOfRefillOperations;
        }
        catch (PersistenceException pe) {
            LogUtil.logException("Can't read IDs from persistence.", pe, logger);
        }
    }

    public int getNumberOfQueueRefills() {
        return this.numberOfRefillOperations;
    }

    @Override
    public abstract int size() throws PersistenceException;

    @Override
    public int size(int status) throws PersistenceException {
        int i = 0;
        for (Integer s : this.states.values()) {
            if (s != status) continue;
            ++i;
        }
        return i;
    }

    @Override
    public abstract Set<String> getUniqueIDs() throws PersistenceException;

    public abstract Set<String> getActiveUniqueIDs() throws PersistenceException;

    protected abstract void doStore(Action var1) throws PersistenceException;

    protected abstract Action doGet(String var1) throws PersistenceException;

    protected abstract Action doGetForUpdate(String var1) throws PersistenceException, TimeoutException;

    protected abstract void doRemove(Action var1) throws PersistenceException;

    @Override
    public String printDiagnostics() throws PersistenceException {
        StringBuilder sb = new StringBuilder();
        long start = System.currentTimeMillis();
        String newline = System.getProperty("line.separator");
        sb.append("DIAGONSTIC INFO storage <" + this.name + "." + this.id + ">" + newline);
        sb.append(newline);
        sb.append("Entries in database: " + this.getUniqueIDs().size() + newline);
        sb.append("DONE: " + this.size(7) + newline);
        sb.append("RUNNING: " + this.size(5) + newline);
        sb.append("READY: " + this.size(2) + newline);
        sb.append("PENDING: " + this.size(21) + newline);
        sb.append("QUEUED: " + this.size(22) + newline);
        sb.append("PREPROCESSING: " + this.size(1) + newline);
        sb.append("POSTPROCESSING: " + this.size(6) + newline);
        sb.append("Entries in Queue: " + this.queue.size() + newline);
        long time = System.currentTimeMillis() - start;
        sb.append("Implementation: " + this.getClass().getName() + newline);
        sb.append("Time to generate diagnostic info: " + time + " ms." + newline);
        return sb.toString();
    }

    public static int getActionSize(Action a) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(a);
            oos.close();
            bos.flush();
            return bos.size();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static class QueueEntry
    implements Delayed {
        final String actionID;
        final long lastAccessed;

        public QueueEntry(String actionID, long lastAccessed) {
            this.actionID = actionID;
            this.lastAccessed = lastAccessed;
        }

        public QueueEntry(String actionID) {
            this(actionID, System.currentTimeMillis());
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(50L - System.currentTimeMillis() + this.lastAccessed, TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            return (int)(this.lastAccessed - ((QueueEntry)o).lastAccessed);
        }

        public String toString() {
            return this.actionID + "[remaining:" + this.getDelay(TimeUnit.MILLISECONDS) + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.actionID == null ? 0 : this.actionID.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QueueEntry other = (QueueEntry)obj;
            return !(this.actionID == null ? other.actionID != null : !this.actionID.equals(other.actionID));
        }
    }
}

