/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.legacy;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.ExecutionContext;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.ems.event.ContinueProcessingEvent;
import de.fzj.unicore.xnjs.ems.event.EventHandler;
import de.fzj.unicore.xnjs.io.DataStageInInfo;
import de.fzj.unicore.xnjs.jsdl.IncarnatedExecutionEnvironment;
import de.fzj.unicore.xnjs.jsdl.IncarnationDataBase;
import de.fzj.unicore.xnjs.jsdl.JSDLUtils;
import de.fzj.unicore.xnjs.legacy.Execution;
import de.fzj.unicore.xnjs.resources.Resource;
import de.fzj.unicore.xnjs.resources.ResourceSet;
import de.fzj.unicore.xnjs.tsi.ApplicationInfo;
import de.fzj.unicore.xnjs.tsi.IReservation;
import de.fzj.unicore.xnjs.tsi.TSI;
import de.fzj.unicore.xnjs.util.LogUtil;
import eu.unicore.security.Client;
import eu.unicore.security.Xlogin;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;

public class TSIUtils {
    private static final Logger jobExecLog = LogUtil.getLogger("unicore.services.jobexecution", TSIUtils.class);
    public static final String EXITCODE_FILENAME = "UNICORE_SCRIPT_EXIT_CODE";
    public static final String PID_FILENAME = "UNICORE_SCRIPT_PID";
    private static final String TEMPLATE_COMMAND = "#COMMAND";
    private static final String TEMPLATE_RESOURCES = "#RESOURCES";
    private static final String TEMPLATE_SCRIPT = "#SCRIPT";
    public static final String DEFAULT_TEMPLATE = "#!/bin/sh \n#COMMAND\n#RESOURCES\n#SCRIPT\n";
    private static final int MEGABYTE = 0x100000;
    static boolean _unittestnoexitcode = false;

    private TSIUtils() {
    }

    public static String makeSubmitCommand(Action job, Configuration config) throws ExecutionException {
        String reservationRef;
        IncarnationDataBase idb = config.getIDB();
        ApplicationInfo applicationInfo = job.getApplicationInfo();
        Client client = job.getClient();
        ExecutionContext ec = job.getExecutionContext();
        IncarnatedExecutionEnvironment execEnv = job.getExecutionEnvironment();
        if (execEnv == null) {
            execEnv = IncarnatedExecutionEnvironment.getDefault();
        }
        String template = idb.getSubmitTemplate();
        ResourceSet rt = job.getExecutionContext().getResourceRequest();
        if (template == null) {
            template = DEFAULT_TEMPLATE;
        }
        template = template.replace(TEMPLATE_COMMAND, "#TSI_SUBMIT");
        StringBuilder commands = new StringBuilder();
        if (rt.getResource("ReservationID") != null && (reservationRef = rt.getResource("ReservationID").getStringValue()) != null) {
            commands.append("#TSI_RESERVATION_REFERENCE " + reservationRef + "\n");
        }
        TSIUtils.appendTSIResourceSpec(commands, rt, idb);
        for (String nodesFilter : applicationInfo.getBSSNodesFilter()) {
            commands.append("#TSI_BSS_NODES_FILTER " + nodesFilter + "\n");
        }
        if (ec.isInteractive()) {
            commands.append("#TSI_PREFER_INTERACTIVE true\n");
        }
        String jobName = job.getJobName() != null ? job.getJobName() : "UNICORE_Job";
        commands.append("#TSI_JOBNAME " + jobName + "\n");
        commands.append("#TSI_OUTCOME_DIR " + ec.getOutcomeDirectory() + "\n");
        commands.append("#TSI_USPACE_DIR " + ec.getWorkingDirectory() + "\n");
        String stdout = ec.getStdout() != null ? ec.getStdout() : "stdout";
        commands.append("#TSI_STDOUT " + stdout + "\n");
        String stderr = ec.getStderr() != null ? ec.getStderr() : "stderr";
        commands.append("#TSI_STDERR " + stderr + "\n");
        String email = "NONE";
        if (client != null && client.getUserEmail() != null) {
            email = client.getUserEmail();
        }
        commands.append("#TSI_EMAIL " + email + "\n");
        template = template.replace(TEMPLATE_RESOURCES, commands.toString());
        commands = new StringBuilder();
        commands.append("#TSI_SCRIPT\n");
        TSIUtils.appendEnvironment(commands, ec);
        String executable = applicationInfo.getExecutable();
        commands.append("UC_EXECUTABLE='" + executable + "'; export UC_EXECUTABLE\n");
        if (client != null) {
            String userDN = "'" + client.getDistinguishedName() + "'";
            commands.append("UC_USERDN=" + userDN + "; export UC_USERDN\n");
        }
        commands.append("PATH=$PATH:. ; export PATH\n");
        commands.append("cd " + ec.getWorkingDirectory() + "\n");
        try {
            int timeout;
            try {
                timeout = Integer.parseInt(config.getProperty("XNJS.staging.filesystem.grace", "10"));
            }
            catch (Exception e) {
                timeout = 10;
            }
            List<DataStageInInfo> stageIns = job.getStageIns();
            String uspace = job.getExecutionContext().getWorkingDirectory();
            StringBuffer fileList = new StringBuffer();
            TSI tsi = config.getTargetSystemInterface(job.getClient());
            for (DataStageInInfo dst : stageIns) {
                try {
                    fileList.append(" \"");
                    String workingDirectory = uspace;
                    String fsName = dst.getFileSystemName();
                    if (fsName != null) {
                        String fs = config.getIDB().getFilespace(fsName);
                        if (fs == null) continue;
                        workingDirectory = tsi.resolve(fs);
                        fileList.append(workingDirectory);
                        fileList.append(tsi.getFileSeparator());
                    }
                    String fName = dst.getFileName();
                    while (fName.startsWith("/")) {
                        fName = fName.substring(1);
                    }
                    fileList.append(fName);
                    fileList.append("\"");
                }
                catch (Exception e) {}
            }
            commands.append("\n#  wait for stage-ins to be visible on network file system\n");
            commands.append("end=$((`date +%s`+" + timeout + "))\n");
            commands.append("looping=\"true\"\n");
            commands.append("while [ \"$looping\" = \"true\" ]\n");
            commands.append("do looping=\"false\"\n");
            commands.append("  for file in " + fileList + "\n");
            commands.append("  do if [ ! -e \"${file}\" ]\n");
            commands.append("      then\n");
            commands.append("        looping=\"true\"\n");
            commands.append("        break\n");
            commands.append("      fi\n");
            commands.append("  done\n");
            commands.append("  current=`date +%s`\n");
            commands.append("  if [ $current -gt $end ]\n");
            commands.append("  then\n");
            commands.append("    echo \"Waiting for input files to show up on the (shared) file system timed out.\" >&2 \n");
            commands.append("    break\n");
            commands.append("  fi\n");
            commands.append("  sleep 5\n");
            commands.append("done\n\n");
        }
        catch (Exception e) {
            // empty catch block
        }
        String executableGuess = executable;
        try {
            String[] tok;
            for (String t : tok = executable.split(" ")) {
                if (t.trim().isEmpty()) continue;
                executableGuess = t;
                break;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        commands.append("chmod u+x " + executableGuess + " 2> /dev/null \n");
        for (String pre : applicationInfo.getPreCommands()) {
            commands.append(pre + "\n");
        }
        execEnv.setUserCommand(applicationInfo.getExecutable());
        StringBuilder argBuilder = new StringBuilder();
        for (String a : applicationInfo.getArguments()) {
            argBuilder.append(" " + a);
        }
        execEnv.setUserCommandArguments(argBuilder.toString());
        String input = null;
        String string = input = ec.getStdin() != null ? ec.getStdin() : null;
        if (input != null) {
            execEnv.setRedirectInput(input);
        }
        execEnv.incarnate(commands);
        commands.append("\n");
        if (!_unittestnoexitcode) {
            commands.append("echo $? > " + ec.getOutcomeDirectory() + "/" + ec.getExitCodeFileName() + "\n");
        }
        for (String post : applicationInfo.getPostCommands()) {
            commands.append(post + "\n");
        }
        return template.replace(TEMPLATE_SCRIPT, commands.toString());
    }

    public static String makeExecuteScript(String script, ExecutionContext ec, Configuration config) {
        String template = config.getIDB().getExecuteTemplate();
        if (template == null) {
            template = DEFAULT_TEMPLATE;
        }
        template = template.replace(TEMPLATE_COMMAND, "#TSI_EXECUTESCRIPT");
        StringBuilder commands = new StringBuilder();
        commands.append("#TSI_SCRIPT\n");
        if (ec != null) {
            TSIUtils.appendEnvironment(commands, ec);
        }
        commands.append(script);
        if (ec != null) {
            if (ec.getStdout() != null) {
                commands.append(" > " + ec.getStdout());
            }
            if (ec.getStderr() != null) {
                commands.append(" 2> " + ec.getStderr());
            }
        }
        commands.append("\n");
        if (ec != null) {
            commands.append("echo $? > ").append(ec.getWorkingDirectory()).append("/").append(ec.getExitCodeFileName()).append("\n");
        }
        return template.replace(TEMPLATE_SCRIPT, commands.toString());
    }

    public static String makeExecuteAsyncScript(Action job, Configuration config) {
        String template = config.getIDB().getExecuteTemplate();
        if (template == null) {
            template = DEFAULT_TEMPLATE;
        }
        template = template.replace(TEMPLATE_COMMAND, "#TSI_EXECUTESCRIPT");
        ExecutionContext ec = job.getExecutionContext();
        ApplicationInfo ai = job.getApplicationInfo();
        ec.getEnvironment().putAll(ai.getEnvironment());
        StringBuilder commands = new StringBuilder();
        commands.append("#TSI_SCRIPT\n");
        commands.append("#TSI_DISCARD_OUTPUT true\n");
        TSIUtils.appendEnvironment(commands, ec);
        commands.append("cd " + ec.getWorkingDirectory() + "\n");
        commands.append(" { ");
        commands.append(ai.getExecutable());
        for (String arg : ai.getArguments()) {
            commands.append(" ").append(arg);
        }
        commands.append(" > ").append(ec.getOutcomeDirectory()).append(ec.getStdout());
        commands.append(" 2> ").append(ec.getOutcomeDirectory()).append(ec.getStderr());
        commands.append("; echo $? > ").append(ec.getOutcomeDirectory()).append("/");
        commands.append(ec.getExitCodeFileName());
        commands.append(" ; } & ");
        commands.append("echo $! > ").append(ec.getOutcomeDirectory()).append("/");
        commands.append(ec.getPIDFileName());
        return template.replace(TEMPLATE_SCRIPT, commands.toString());
    }

    public static Execution.BSSSummary updateStatusListing(Map<String, Execution.BSSInfo> statesMap, String tsiReply, List<String> interactiveProcesses, EventHandler handler) throws IOException {
        int running = 0;
        int queued = 0;
        int total = 0;
        BufferedReader br = new BufferedReader(new StringReader(tsiReply.trim() + "\n"));
        String line = br.readLine();
        if (line == null) {
            throw new IOException("Empty reply from TSI");
        }
        if (!(line = line.trim()).equalsIgnoreCase("QSTAT")) {
            throw new IOException("No valid QSTAT listing received. TSI replied: " + line);
        }
        HashSet<String> bssIDs = new HashSet<String>();
        bssIDs.addAll(statesMap.keySet());
        HashSet<String> haveStatusForIDs = new HashSet<String>();
        HashMap<String, Integer> queueFill = new HashMap<String, Integer>();
        String inner = "";
        while (inner != null && (inner = br.readLine()) != null) {
            Execution.BSSInfo oldInfo;
            String[] tok = inner.trim().split(" ");
            if (tok.length < 2) {
                String msg = "Wrong format of QSTAT! Please check the TSI module GetStatusListing.pm!";
                throw new IOException(msg);
            }
            String bssID = tok[0].trim();
            if (haveStatusForIDs.contains(bssID)) continue;
            String newValue = tok[1].trim();
            ++total;
            boolean active = false;
            if ("RUNNING".equals(newValue)) {
                ++running;
                active = true;
            } else if ("QUEUED".equals(newValue)) {
                ++queued;
                active = true;
            }
            String queue = null;
            if (active && tok.length > 2) {
                queue = tok[2];
                Integer fill = (Integer)queueFill.get(queue);
                if (fill == null) {
                    fill = new Integer(0);
                }
                Integer n = fill;
                Integer n2 = fill = Integer.valueOf(fill + 1);
                queueFill.put(queue, fill);
            }
            if ((oldInfo = statesMap.get(bssID)) == null) continue;
            String oldValue = oldInfo.bssState;
            String jobID = oldInfo.jobID;
            Execution.BSSInfo newState = new Execution.BSSInfo(bssID, jobID, newValue);
            newState.queue = queue;
            statesMap.put(bssID, newState);
            haveStatusForIDs.add(bssID);
            if (!newValue.equals(oldValue) && handler != null) {
                try {
                    if (jobExecLog.isDebugEnabled()) {
                        jobExecLog.debug((Object)("BSS status changed: " + oldValue + " -> " + newValue + ", sending 'continue' for : " + jobID));
                    }
                    handler.handleEvent(new ContinueProcessingEvent(jobID));
                }
                catch (Exception ee) {
                    LogUtil.logException("Error sending change event", ee, jobExecLog);
                }
            }
            bssIDs.remove(bssID);
        }
        for (String s : bssIDs) {
            Execution.BSSInfo state = statesMap.get(s);
            if (interactiveProcesses.contains(s)) continue;
            try {
                String uuid;
                if (handler != null && (uuid = state.jobID) != null) {
                    if (jobExecLog.isDebugEnabled()) {
                        jobExecLog.debug((Object)("Entry '" + s + "' disappeared from QSTAT listing, sending 'continue' for uuid=" + uuid));
                    }
                    handler.handleEvent(new ContinueProcessingEvent(uuid));
                }
                if ("COMPLETED".equals(state.bssState)) continue;
                statesMap.remove(s);
            }
            catch (Exception ee) {
                LogUtil.logException("Internal error updating status, bssID=" + s, ee, jobExecLog);
            }
        }
        return new Execution.BSSSummary(running, queued, total, queueFill);
    }

    public static String[] readTSILSLine(BufferedReader br, String tsiVersion) throws ExecutionException {
        String[] lines = new String[2];
        lines[0] = "";
        while (lines[0] != null) {
            try {
                lines[0] = br.readLine();
            }
            catch (IOException ex) {
                throw new ExecutionException(ex);
            }
            if (lines[0] == null) break;
            if (lines[0].startsWith("<") || lines[0].startsWith("-") || lines[0].startsWith("TSI_OK") || lines[0].startsWith("END_LISTING") || lines[0].startsWith("START_LISTING") || lines[0].length() == 0) continue;
            if (TSIUtils.compareVersion(tsiVersion, "6.4.1")) {
                try {
                    lines[1] = br.readLine();
                }
                catch (IOException ex) {
                    throw new ExecutionException(ex);
                }
                if (!lines[1].startsWith("--")) {
                    throw new ExecutionException("Got invalid extended permissions line from TSI: >" + lines[1] + "< for file line >" + lines[0] + "<");
                }
            }
            return lines;
        }
        return lines;
    }

    public static String readTSIDFLine(BufferedReader br) throws ExecutionException {
        String line = "";
        while (line != null) {
            try {
                line = br.readLine();
            }
            catch (IOException ex) {
                throw new ExecutionException(ex);
            }
            if (line == null) break;
            if (line.startsWith("TSI_OK") || line.startsWith("END_DF") || line.startsWith("START_DF") || line.length() == 0) continue;
            return line;
        }
        return null;
    }

    public static String makeAbortCommand(String bssid) {
        StringBuffer commands = new StringBuffer();
        commands.append("#TSI_ABORTJOB\n");
        commands.append("#TSI_BSSID " + bssid + "\n");
        return commands.toString();
    }

    public static String makeCancelCommand(String bssid) {
        StringBuffer commands = new StringBuffer();
        commands.append("#TSI_CANCELJOB\n");
        commands.append("#TSI_BSSID " + bssid + "\n");
        return commands.toString();
    }

    public static String makeGetJobInfoCommand(String bssid) {
        StringBuffer commands = new StringBuffer();
        commands.append("#TSI_GETJOBDETAILS\n");
        commands.append("#TSI_BSSID " + bssid + "\n");
        return commands.toString();
    }

    public static String makeStatusCommand() {
        StringBuffer commands = new StringBuffer();
        commands.append("#TSI_GETSTATUSLISTING\n");
        return commands.toString();
    }

    public static String makeGetFileChunkCommand(String file, long start, long length) {
        StringBuffer commands = new StringBuffer();
        commands.append("#TSI_GETFILECHUNK\n");
        commands.append("#TSI_FILE " + file + "\n");
        commands.append("#TSI_START " + start + "\n");
        commands.append("#TSI_LENGTH " + length + "\n");
        return commands.toString();
    }

    public static String makePutFilesCommand(boolean append) {
        StringBuffer commands = new StringBuffer();
        commands.append("#TSI_PUTFILES\n");
        String action = append ? "3" : "0";
        commands.append("#TSI_FILESACTION " + action + "\n");
        return commands.toString();
    }

    public static String extractReservationID(ResourcesType rt) {
        XmlObject[] xo = rt.selectChildren(IReservation.RESERVATION_REFERENCE);
        if (xo == null || xo.length != 1) {
            return null;
        }
        XmlCursor c = xo[0].newCursor();
        String id = c.getTextValue();
        c.dispose();
        return id;
    }

    public static String makeMakeReservationCommand(ResourceSet rt, Calendar startTime, IncarnationDataBase idb, Client client) {
        StringBuilder commands = new StringBuilder();
        commands.append("#TSI_MAKE_RESERVATION\n");
        if (client != null && client.getXlogin() != null) {
            commands.append("#TSI_RESERVATION_OWNER " + client.getXlogin().getUserName() + "\n");
        }
        DateFormat df = JSDLUtils.getDateFormat();
        commands.append("#TSI_STARTTIME " + df.format(startTime.getTime()) + "\n");
        TSIUtils.appendTSIResourceSpec(commands, rt, idb);
        return commands.toString();
    }

    public static String makeCancelReservationCommand(String reservationID) {
        StringBuffer commands = new StringBuffer();
        commands.append("#TSI_CANCEL_RESERVATION\n");
        commands.append("#TSI_RESERVATION_REFERENCE " + reservationID + "\n");
        return commands.toString();
    }

    public static String makeQueryReservationCommand(String reservationID) {
        StringBuffer commands = new StringBuffer();
        commands.append("#TSI_QUERY_RESERVATION\n");
        commands.append("#TSI_RESERVATION_REFERENCE " + reservationID + "\n");
        return commands.toString();
    }

    public static void appendTSIResourceSpec(StringBuilder commands, ResourceSet orig, IncarnationDataBase idb) {
        ResourceSet rt = orig.copy();
        double memory = 10.0;
        int processors = 1;
        int nodes = -1;
        double run_time = -1.0;
        String queue = "NONE";
        Resource queueResource = rt.getResource("Queue");
        if (queueResource != null) {
            queue = queueResource.getStringValue();
            rt.removeResource("Queue");
        } else if (idb.getQueueName() != null) {
            queue = idb.getQueueName();
        }
        Resource projectResource = rt.getResource("Project");
        if (projectResource != null) {
            String project = projectResource.getStringValue();
            rt.removeResource("Project");
            if (project != null) {
                commands.append("#TSI_PROJECT " + project + "\n");
            }
        }
        String hostname = "none";
        if (rt.getResource("CPUsPerNode") != null) {
            try {
                processors = (int)(rt.getResource("CPUsPerNode").getDoubleValue() + 0.5);
                rt.removeResource("CPUsPerNode");
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            if (rt.getResource("Nodes") != null) {
                try {
                    nodes = (int)(rt.getResource("Nodes").getDoubleValue() + 0.5);
                    rt.removeResource("Nodes");
                }
                catch (RuntimeException e) {}
            } else {
                nodes = 1;
            }
        }
        if (rt.getResource("TotalCPUs") != null) {
            try {
                processors = (int)(rt.getResource("TotalCPUs").getDoubleValue() + 0.5);
                rt.removeResource("TotalCPUs");
                nodes = -1;
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        if (rt.getResource("MemoryPerNode") != null) {
            try {
                memory = (int)((rt.getResource("MemoryPerNode").getDoubleValue() + 0.5) / 1048576.0);
                rt.removeResource("MemoryPerNode");
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        if (rt.getResource("CPUTime") != null) {
            try {
                run_time = (int)(rt.getResource("CPUTime").getDoubleValue() + 0.5);
                rt.removeResource("CPUTime");
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        int total = nodes != -1 ? nodes * processors : processors;
        commands.append("#TSI_TIME " + (int)run_time + "\n");
        commands.append("#TSI_MEMORY " + (int)memory + "\n");
        if (nodes == -1) {
            commands.append("#TSI_NODES NONE\n");
            commands.append("#TSI_TOTAL_PROCESSORS " + total + "\n");
            commands.append("#TSI_PROCESSORS " + processors + "\n");
        } else {
            commands.append("#TSI_NODES " + nodes + "\n");
            commands.append("#TSI_PROCESSORS_PER_NODE " + processors + "\n");
            commands.append("#TSI_TOTAL_PROCESSORS " + total + "\n");
            commands.append("#TSI_PROCESSORS " + processors + "\n");
        }
        commands.append("#TSI_HOST_NAME " + hostname + "\n");
        commands.append("#TSI_QUEUE " + queue + "\n");
        if (nodes != -1) {
            commands.append("UC_NODES=" + nodes + "; export UC_NODES;\n");
            commands.append("UC_PROCESSORS_PER_NODE=" + processors + "; export UC_PROCESSORS_PER_NODE;\n");
            commands.append("UC_PROCESSORS=" + processors + "; export UC_PROCESSORS;\n");
            commands.append("UC_TOTAL_PROCESSORS=" + total + "; export UC_TOTAL_PROCESSORS;\n");
        } else {
            commands.append("UC_PROCESSORS=" + processors + "; export UC_PROCESSORS;\n");
            commands.append("UC_TOTAL_PROCESSORS=" + processors + "; export UC_TOTAL_PROCESSORS;\n");
        }
        commands.append("UC_RUNTIME=" + (int)run_time + "; export UC_RUNTIME;\n");
        commands.append("UC_MEMORY_PER_NODE=" + (int)memory + "; export UC_MEMORY_PER_NODE;\n");
        if (rt != null) {
            TSIUtils.appendSiteSpecificResources(commands, rt);
        }
    }

    public static void appendEnvironment(StringBuilder commands, ExecutionContext ec) {
        if (ec.getUmask() != null) {
            commands.append("#TSI_UMASK " + ec.getUmask() + "\n");
        }
        commands.append("# supplied environment variables begin.\n");
        for (Map.Entry<String, String> env : ec.getEnvironment().entrySet()) {
            String key = env.getKey();
            String value = env.getValue();
            commands.append(key).append("=\"").append(value).append("\"; export " + key + "\n");
        }
        commands.append("# supplied environment variables end.\n");
        if (ec.getUmask() != null) {
            commands.append("umask " + ec.getUmask() + "\n");
        }
    }

    protected static void appendSiteSpecificResources(StringBuilder commands, ResourceSet rs) {
        try {
            for (Resource r : rs.getResources()) {
                try {
                    String name = r.getName().replace(' ', '_');
                    String value = r.getStringValue();
                    commands.append("#TSI_SSR_" + name.toUpperCase() + " " + value + "\n");
                }
                catch (Exception e) {
                    Logger.getLogger((String)"unicore.xnjs").warn((Object)"Resource value not set.", (Throwable)e);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean compareVersion(String tsiVersion, String minRequired) {
        int i;
        if (tsiVersion == null) {
            return false;
        }
        String[] curS = tsiVersion.split("\\.");
        String[] reqS = minRequired.split("\\.");
        int[] cur = new int[curS.length];
        int[] req = new int[reqS.length];
        try {
            for (i = 0; i < curS.length; ++i) {
                cur[i] = Integer.parseInt(curS[i]);
            }
            for (i = 0; i < reqS.length; ++i) {
                req[i] = Integer.parseInt(reqS[i]);
            }
        }
        catch (NumberFormatException ex) {
            return false;
        }
        for (i = 0; i < Math.min(cur.length, req.length); ++i) {
            if (cur[i] < req[i]) {
                return false;
            }
            if (cur[i] <= req[i]) continue;
            return true;
        }
        return cur.length >= req.length;
    }

    public static String prepareGroupsString(Client client, String tsiVersion) {
        if (TSIUtils.compareVersion(tsiVersion, "6.3.2")) {
            Xlogin xlogin = client.getXlogin();
            StringBuilder sb = new StringBuilder();
            String group = xlogin.getGroup();
            if (group == null || group.length() == 0) {
                if (xlogin.isAddDefaultGroups()) {
                    return "NONE";
                }
                return "DEFAULT_GID";
            }
            if (xlogin.isGroupSelected()) {
                sb.append(group);
            } else {
                sb.append("DEFAULT_GID");
            }
            String supGids = xlogin.getEncodedSelectedSupplementaryGroups();
            if (!supGids.equals("")) {
                sb.append(":");
                sb.append(supGids);
            }
            if (xlogin.isAddDefaultGroups()) {
                sb.append(":DEFAULT_GID");
            }
            return sb.toString();
        }
        String group = client.getXlogin().getGroup();
        if (group != null && !"".equals(group)) {
            return group;
        }
        return "NONE";
    }

    public static String prepareAllGroupsString(Client client, String tsiVersion) {
        if (TSIUtils.compareVersion(tsiVersion, "6.3.2")) {
            Xlogin xlogin = client.getXlogin();
            StringBuilder sb = new StringBuilder();
            sb.append("DEFAULT_GID");
            if (xlogin.getEncodedGroups() != null && xlogin.getEncodedGroups().length() > 0) {
                sb.append(":").append(xlogin.getEncodedGroups());
            }
            sb.append(":DEFAULT_GID");
            return sb.toString();
        }
        String group = client.getXlogin().getGroup();
        if (group != null && !"".equals(group)) {
            return group;
        }
        return "NONE";
    }

    public static String makePauseCommand(String bssid) {
        StringBuffer commands = new StringBuffer();
        commands.append("#TSI_HOLDJOB\n");
        commands.append("#TSI_BSSID " + bssid + "\n");
        return commands.toString();
    }

    public static String makeResumeCommand(String bssid) {
        StringBuffer commands = new StringBuffer();
        commands.append("#TSI_RESUMEJOB\n");
        commands.append("#TSI_BSSID " + bssid + "\n");
        return commands.toString();
    }

    public static String getFilePerm(Integer umask) {
        return Integer.toOctalString(0x1B6 & ~umask.intValue());
    }

    public static String getDirPerm(Integer umask) {
        return Integer.toOctalString(0x1FF & ~umask.intValue());
    }
}

