/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.legacy;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.aaa.XNJSSocketFactory;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;

public class TSISocketFactory
extends XNJSSocketFactory {
    private final ServerSocket server;
    private final int myPort;
    private final boolean disableSSL;

    public TSISocketFactory(Configuration config, int myPort) throws Exception {
        super(config);
        this.myPort = myPort;
        this.disableSSL = Boolean.parseBoolean(config.getProperty("CLASSICTSI.ssl.disable", String.valueOf(!super.useSSL())));
        this.server = this.init();
    }

    private ServerSocket init() throws Exception {
        if (this.useSSL()) {
            return this.createSSLServer();
        }
        return this.createPlainServer();
    }

    private ServerSocket createPlainServer() throws IOException {
        return new ServerSocket(this.myPort);
    }

    private ServerSocket createSSLServer() throws Exception {
        SSLServerSocketFactory ssf = this.getSSLContext().getServerSocketFactory();
        ServerSocket s = ssf.createServerSocket(this.myPort);
        SSLServerSocket ssl = (SSLServerSocket)s;
        ssl.setNeedClientAuth(this.security.doSSLAuthn());
        ssl.setEnableSessionCreation(true);
        return s;
    }

    public Socket accept() throws IOException {
        Socket s = this.server.accept();
        if (this.useSSL()) {
            ((SSLSocket)s).startHandshake();
        }
        return s;
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.server.setSoTimeout(timeout);
    }

    public void close() throws IOException {
        this.server.close();
    }

    @Override
    public boolean useSSL() {
        return super.useSSL() && !this.disableSSL;
    }
}

