/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.legacy;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.legacy.TSIConnection;
import de.fzj.unicore.xnjs.legacy.TSIConnectionFactoryMBean;
import de.fzj.unicore.xnjs.legacy.TSISocketFactory;
import de.fzj.unicore.xnjs.legacy.TSIUtils;
import de.fzj.unicore.xnjs.management.ManagedComponent;
import de.fzj.unicore.xnjs.management.Startable;
import de.fzj.unicore.xnjs.tsi.TSIUnavailableException;
import de.fzj.unicore.xnjs.util.LogUtil;
import eu.unicore.security.Client;
import eu.unicore.util.Log;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

@ManagedComponent(mbean=TSIConnectionFactory.class, name="LegacyTSI")
public class TSIConnectionFactory
implements Startable,
TSIConnectionFactoryMBean {
    private static final Logger log = LogUtil.getLogger("unicore.xnjs.tsi", TSIConnectionFactory.class);
    private final List<TSIConnection> pool = new ArrayList<TSIConnection>();
    private String[] tsiHostnames;
    private InetAddress[] tsiAddressPool;
    private int[] tsiPortPool;
    private int pos = 0;
    private TSISocketFactory server = null;
    private String machine = "";
    private String tsiDescription = "";
    private int replyport = -1;
    public static final String TSI_MACHINE = "CLASSICTSI.machine";
    public static final String TSI_PORT = "CLASSICTSI.port";
    public static final String TSI_MYPORT = "CLASSICTSI.replyport";
    public static final String TSI_BSSUSER = "CLASSICTSI.priveduser";
    public static final String TSI_CONNECT_TIMEOUT = "CLASSICTSI.socket.connect.timeout";
    private int count = 0;
    private final AtomicInteger liveConnections = new AtomicInteger(0);
    private volatile boolean isShutdown = false;
    private String tsiVersion = null;
    private final Configuration configuration;

    public TSIConnectionFactory(Configuration config) {
        this.configuration = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSIConnection getTSIConnection(String user, String group, String preferredHost) throws TSIUnavailableException {
        if (user == null) {
            throw new IllegalArgumentException("Required UNIX user ID is null (security setup problem?)");
        }
        TSIConnection conn = null;
        List<TSIConnection> list = this.pool;
        synchronized (list) {
            if (this.pool.size() > 0) {
                if (preferredHost == null) {
                    conn = this.pool.remove(0);
                } else {
                    InetAddress preferred = null;
                    try {
                        preferred = InetAddress.getByName(preferredHost);
                    }
                    catch (UnknownHostException uhe) {
                        throw new IllegalArgumentException("Unknown host: " + preferredHost, uhe);
                    }
                    Iterator<TSIConnection> iterator = this.pool.iterator();
                    while (iterator.hasNext()) {
                        TSIConnection s = iterator.next();
                        if (!preferred.equals(s.getTSIAddress())) continue;
                        conn = s;
                        iterator.remove();
                    }
                }
            }
        }
        if (conn != null && !conn.isAlive()) {
            conn.dead();
            conn = null;
        }
        if (conn == null) {
            conn = this.createNewTSIConnection(preferredHost);
        }
        if (conn != null) {
            if (group == null) {
                group = "NONE";
            }
            conn.setIdLine(user + " " + group);
            conn.startUse();
        }
        return conn;
    }

    public TSIConnection getTSIConnection(String user, String group) throws TSIUnavailableException {
        return this.getTSIConnection(user, group, null);
    }

    public TSIConnection getTSIConnection(Client client, String preferredHost) throws TSIUnavailableException {
        if (this.isShutdown) {
            throw new TSIUnavailableException("Legacy TSI is shutting down.");
        }
        String user = client.getXlogin().getUserName();
        String group = TSIUtils.prepareGroupsString(client, this.tsiVersion);
        return this.getTSIConnection(user, group, preferredHost);
    }

    public TSIConnection getTSIConnection(Client client) throws TSIUnavailableException {
        return this.getTSIConnection(client, null);
    }

    private synchronized TSIConnection createNewTSIConnection(String preferredHost) throws TSIUnavailableException {
        if (log.isDebugEnabled()) {
            String msg = preferredHost == null ? "Creating new TSIConnection, this is number " + this.count : "Creating new TSIConnection to " + preferredHost + ", this is number " + this.count;
            log.debug((Object)msg);
        }
        TSIConnection newConn = null;
        InetAddress tsiHost = null;
        int port = 0;
        String hostName = null;
        if (preferredHost == null) {
            Exception lastException = null;
            for (int i = 0; i < this.tsiAddressPool.length; ++i) {
                tsiHost = this.tsiAddressPool[this.pos];
                port = this.tsiPortPool[this.pos];
                hostName = this.tsiHostnames[this.pos];
                ++this.pos;
                if (this.pos >= this.tsiAddressPool.length) {
                    this.pos = 0;
                }
                try {
                    newConn = this.createNewTSIConnection(tsiHost, port, hostName);
                    return newConn;
                }
                catch (Exception ex) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("TSI at " + tsiHost + " port " + port + " is not available."), (Throwable)ex);
                    }
                    lastException = ex;
                    continue;
                }
            }
            if (this.tsiAddressPool.length > 1) {
                throw new TSIUnavailableException("None of the configured TSIs is available.");
            }
            String message = Log.createFaultMessage((String)"TSI unavailable", lastException);
            throw new TSIUnavailableException(message);
        }
        InetAddress preferred = null;
        try {
            preferred = InetAddress.getByName(preferredHost);
        }
        catch (UnknownHostException uhe) {
            throw new IllegalArgumentException("Unknown host: " + preferredHost, uhe);
        }
        for (int i = 0; i < this.tsiAddressPool.length; ++i) {
            InetAddress s = this.tsiAddressPool[i];
            if (!preferred.equals(s)) continue;
            tsiHost = s;
            port = this.tsiPortPool[i];
            hostName = this.tsiHostnames[i];
        }
        if (tsiHost == null) {
            throw new IllegalArgumentException("No TSI is configured at " + preferredHost);
        }
        try {
            newConn = this.createNewTSIConnection(tsiHost, port, hostName);
            return newConn;
        }
        catch (Exception e) {
            throw new TSIUnavailableException("TSI at " + tsiHost + " port " + port + " is not available.");
        }
    }

    private TSIConnection createNewTSIConnection(InetAddress tsiHost, int port, String hostName) throws IOException {
        TSIConnection newConn = null;
        InetAddress actualTSIAddress = null;
        int connectTimeout = Integer.parseInt(this.configuration.getProperty(TSI_CONNECT_TIMEOUT, "10000"));
        this.server.setSoTimeout(connectTimeout);
        actualTSIAddress = this.signalShepherd(tsiHost, port, "newtsiprocess " + this.replyport + "\n");
        Socket commands_socket = this.server.accept();
        Socket data_socket = this.server.accept();
        if (!commands_socket.getInetAddress().equals(data_socket.getInetAddress())) {
            commands_socket.close();
            data_socket.close();
            throw new IOException("TSI problem: data/command socket address mismatch");
        }
        if (!commands_socket.getInetAddress().equals(actualTSIAddress)) {
            commands_socket.close();
            data_socket.close();
            throw new IOException("Invalid new TSI connection (wrong machine). Contact site administration!");
        }
        newConn = new TSIConnection(commands_socket, data_socket, this, tsiHost, hostName);
        newConn.setSocketTimeouts(5000, true);
        String v = this.doGetVersion(newConn);
        newConn.setSocketTimeouts(0, true);
        newConn.setTSIVersion(v);
        newConn.setConnectionID("TSI__" + tsiHost + "__" + this.count);
        ++this.count;
        this.liveConnections.incrementAndGet();
        return newConn;
    }

    private InetAddress signalShepherd(InetAddress tsiHost, int port, String message) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Signalling TSI at " + tsiHost + ":" + port + " : " + message));
        }
        Socket s = this.server.createSocket(tsiHost, port);
        s.getOutputStream().write(message.getBytes());
        s.getOutputStream().flush();
        InetAddress actualTSIAddress = s.getInetAddress();
        try {
            s.getInputStream().read();
            s.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return actualTSIAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void done(TSIConnection connection) {
        List<TSIConnection> list = this.pool;
        synchronized (list) {
            try {
                if (connection != null) {
                    connection.endUse();
                    this.pool.add(connection);
                }
            }
            catch (Exception ex) {
                log.error((Object)ex);
            }
        }
    }

    public void dead(TSIConnection connection) {
        this.liveConnections.decrementAndGet();
    }

    public void start() {
        try {
            int port = -1;
            this.machine = this.configuration.getProperty(TSI_MACHINE);
            String portS = this.configuration.getProperty(TSI_PORT);
            if (portS != null) {
                port = Integer.parseInt(portS);
                if (!this.machine.contains(":")) {
                    this.machine = this.machine + ":" + port;
                }
            }
            String replyportS = this.configuration.getProperty(TSI_MYPORT);
            this.replyport = Integer.parseInt(replyportS);
            String[] tsiSpec = this.machine.split("[ ,]+");
            this.tsiHostnames = new String[tsiSpec.length];
            this.tsiAddressPool = new InetAddress[tsiSpec.length];
            this.tsiPortPool = new int[tsiSpec.length];
            for (int i = 0; i < tsiSpec.length; ++i) {
                String[] split = tsiSpec[i].split(":");
                String host = split[0];
                int p = port;
                if (split.length > 1) {
                    p = Integer.parseInt(split[1]);
                }
                this.tsiAddressPool[i] = InetAddress.getByName(host);
                this.tsiPortPool[i] = p;
                this.tsiHostnames[i] = host;
            }
            this.server = new TSISocketFactory(this.configuration, this.replyport);
            boolean ssl = this.server.useSSL();
            log.info((Object)("\"TSI\" connection factory starting:\n  ** Talking to TSI at " + this.machine + " on port " + port + "\n" + "  ** SSL is " + (ssl ? "enabled" : "disabled") + "\n" + "  ** Listening on port " + this.replyport + "\n" + "  ** User id for querying list of jobs on BSS: '" + this.getBSSUser() + "'"));
            this.tsiDescription = this.machine + " port=" + port + ", XNJS listens on port " + this.replyport;
            log.info((Object)("TSI connection: " + this.getConnectionStatus()));
        }
        catch (Exception ex) {
            log.error((Object)"Cannot setup TSI Connection Factory", (Throwable)ex);
            throw new Error("Config is messed up, cannot setup TSI Connection factory.", ex);
        }
    }

    protected String getBSSUser() {
        return this.configuration.getIDB().getProperty(TSI_BSSUSER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.isShutdown = true;
        try {
            log.info((Object)"Shutting down TSI listener socket");
            this.server.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<TSIConnection> list = this.pool;
        synchronized (list) {
            for (TSIConnection c : this.pool) {
                try {
                    c.dead();
                }
                catch (Exception ex) {}
            }
            this.pool.clear();
        }
    }

    @Override
    public int getNumberOfPooledConnections() {
        return this.pool.size();
    }

    @Override
    public String getTSIMachine() {
        return this.machine;
    }

    @Override
    public int getLocalPort() {
        return this.replyport;
    }

    @Override
    public int getTotalConnectionsCreated() {
        return this.count;
    }

    @Override
    public int getLiveConnections() {
        return this.liveConnections.intValue();
    }

    @Override
    public String getConnectionStatus() {
        StringBuilder sb = new StringBuilder();
        try {
            String version = this.getTSIConnection("nobody", null).getTSIVersion();
            sb.append("OK [connected to Perl TSI v").append(version).append(" at ").append(this.tsiDescription);
        }
        catch (Exception te) {
            sb.append("NOT OK [").append(Log.createFaultMessage((String)("Perl TSI at " + this.tsiDescription), (Throwable)te));
        }
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getTSIVersion() {
        if (this.tsiVersion == null) {
            TSIConnection c = null;
            try {
                c = this.getTSIConnection("nobody", null);
                String string = this.tsiVersion = c.getTSIVersion();
                return string;
            }
            catch (Exception e) {
                String string = null;
                return string;
            }
            finally {
                if (c != null) {
                    c.done();
                }
            }
        }
        return this.tsiVersion;
    }

    private String doGetVersion(TSIConnection c) throws SocketException {
        String v = null;
        try {
            String reply = c.sendNoUser("#TSI_PING");
            if (reply != null && reply.length() > 0) {
                v = reply.trim();
            }
        }
        catch (SocketException se) {
            throw se;
        }
        catch (Exception e) {
            LogUtil.logException("Can't get TSI version", e, log);
        }
        return v;
    }

    public String[] getTSIHosts() {
        return this.tsiHostnames;
    }
}

