/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.legacy;

import de.fzj.unicore.xnjs.legacy.TSIConnectionFactory;
import de.fzj.unicore.xnjs.util.LogUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.Logger;

public class TSIConnection {
    private static final Logger logger = LogUtil.getLogger("unicore.xnjs.tsi", TSIConnection.class);
    private String idLine;
    private static final int BUFSZ = 64000;
    public static final String TSI_OK = "TSI_OK";
    private Command command;
    private Data data;
    private final TSIConnectionFactory factory;
    private String tsiVersion;
    private static final String lineSep = System.getProperty("line.separator");
    private final InetAddress tsiHost;
    private final String tsiHostName;
    private String connectionID;
    private boolean dead = false;
    private long start;

    public TSIConnection(Socket c_s, Socket d_s, TSIConnectionFactory factory, InetAddress tsiHost, String hostName) throws IOException {
        this.command = new Command(c_s);
        this.data = new Data(d_s);
        this.factory = factory;
        this.tsiHost = tsiHost;
        this.tsiHostName = hostName;
    }

    public InetAddress getTSIAddress() {
        return this.tsiHost;
    }

    public String getTSIHostName() {
        return this.tsiHostName;
    }

    public String send(String message) throws IOException {
        return this.command.send(message);
    }

    public String sendNoUser(String message) throws IOException {
        return this.command.sendNU(message);
    }

    public String getLine() throws IOException {
        return this.command.getLine();
    }

    public void sendData(byte[] buffer, int offset, int number) throws IOException {
        this.data.sendData(buffer, offset, number);
    }

    public void getData(byte[] buffer, int offset, int number) throws IOException {
        this.data.getData(buffer, offset, number);
    }

    public InputStream getDataStream() throws IOException {
        return this.data.getInputStream();
    }

    public void setSocketTimeouts(int timeout, boolean keepAlive) throws SocketException {
        this.data.socket.setSoTimeout(timeout);
        this.data.socket.setKeepAlive(keepAlive);
        this.command.socket.setSoTimeout(timeout);
        this.command.socket.setKeepAlive(keepAlive);
    }

    public boolean isAlive() {
        return this.command != null && this.command.isAlive();
    }

    public void done() {
        if (this.dead) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Connection " + this.connectionID + " is dead."));
            }
            return;
        }
        this.setIdLine("");
        this.factory.done(this);
    }

    public void dead() {
        this.dead = true;
        if (this.command != null) {
            this.command.die();
            this.command = null;
        }
        if (this.data != null) {
            this.data.die();
            this.data = null;
        }
        this.factory.dead(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TSIConnection[").append(this.tsiHost);
        sb.append(" ").append(this.command);
        sb.append(" ").append(this.data);
        sb.append("]");
        return sb.toString();
    }

    private void appendSocketInfo(Socket s, StringBuilder sb) {
        try {
            sb.append("peer=").append(s.getInetAddress());
            sb.append(" peerPort=").append(s.getPort());
            sb.append(" localPort=").append(s.getLocalPort());
            sb.append(" timeout=").append(s.getSoTimeout());
            sb.append(" keepAlive=").append(s.getKeepAlive());
        }
        catch (Exception ex) {
            sb.append("ERROR: ").append(ex);
        }
    }

    public String getIdLine() {
        return this.idLine;
    }

    public void setIdLine(String idLine) {
        this.idLine = idLine;
    }

    public String getTSIVersion() {
        return this.tsiVersion;
    }

    void setTSIVersion(String version) {
        this.tsiVersion = version;
    }

    void startUse() {
        this.start = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Connection " + this.connectionID + " checked out"));
        }
    }

    void endUse() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Connection " + this.connectionID + " was in use for " + (System.currentTimeMillis() - this.start) + " millis."));
        }
    }

    void setConnectionID(String id) {
        this.connectionID = id;
    }

    String getConnectionID() {
        return this.connectionID;
    }

    public class Data {
        private Socket socket;
        private OutputStream output;
        private InputStream input;

        public Data(Socket s) throws IOException {
            this.socket = s;
            this.input = new BufferedInputStream(s.getInputStream(), 64000);
            this.output = new BufferedOutputStream(s.getOutputStream(), 64000);
        }

        public void sendData(byte[] tosend, int offset, int number) throws IOException {
            try {
                this.output.write(tosend, offset, number);
                this.output.flush();
            }
            catch (IOException ex) {
                TSIConnection.this.dead();
                throw ex;
            }
        }

        public void getData(byte[] buffer, int offset, int number) throws IOException {
            try {
                for (int read = 0; read < number; read += this.input.read(buffer, offset + read, number - read)) {
                }
            }
            catch (IOException ex) {
                TSIConnection.this.dead();
                throw ex;
            }
        }

        public void die() {
            try {
                this.output.close();
                this.input.close();
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        InputStream getInputStream() {
            return this.input;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Data[");
            TSIConnection.this.appendSocketInfo(this.socket, sb);
            sb.append("]");
            return sb.toString();
        }
    }

    class Command {
        private Socket socket;
        private BufferedReader input;
        private PrintWriter output;

        public Command(Socket s) throws IOException {
            this.socket = s;
            this.input = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
            this.output = new PrintWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"));
        }

        public String send(String data) throws IOException {
            return this._send(data, true);
        }

        public String sendNU(String data) throws IOException {
            return this._send(data, false);
        }

        private String _send(String data, boolean sendUser) throws IOException {
            StringBuilder reply = new StringBuilder();
            if (data.indexOf("ENDOFMESSAGE") > -1) {
                throw new IOException("TSI message (user data?) contains ENDOFMESSAGE, this is not allowed");
            }
            if (sendUser && data.indexOf("#TSI_IDENTITY") > -1) {
                throw new IOException("TSI message or user's data changes identity far too many times (#TSI_IDENTITY found)");
            }
            try {
                if (logger.isDebugEnabled()) {
                    if (sendUser) {
                        logger.debug((Object)("Sending as [" + TSIConnection.this.idLine + "]\n" + data));
                    } else {
                        logger.debug((Object)data);
                    }
                }
                this.output.print(data);
                if (sendUser) {
                    this.output.print("\n#TSI_IDENTITY " + TSIConnection.this.idLine + "\n");
                }
                this.output.print("\nENDOFMESSAGE\n");
                this.output.flush();
            }
            catch (Exception ex) {
                TSIConnection.this.dead();
                IOException ioex = new IOException("Failure sending data to a (Classic) TSI");
                ioex.initCause(ex);
                throw ioex;
            }
            try {
                String line = this.getALine();
                while (!line.equals("ENDOFMESSAGE")) {
                    reply.append(line).append("\n");
                    line = this.getALine();
                }
            }
            catch (Exception e) {
                TSIConnection.this.dead();
                IOException ioex = new IOException("Failure reading reply data from a (Classic) TSI");
                ioex.initCause(e);
                throw ioex;
            }
            logger.debug((Object)reply);
            return reply.toString();
        }

        public String getLine() throws IOException {
            String reply = null;
            try {
                reply = this.getALine();
            }
            catch (IOException ex) {
                TSIConnection.this.dead();
                throw ex;
            }
            return reply;
        }

        private String getALine() throws IOException {
            String nextLine = this.input.readLine();
            StringBuilder sb = null;
            while (nextLine != null && nextLine.startsWith("TSI_COMMENT")) {
                nextLine = this.input.readLine();
                if (logger.isDebugEnabled()) {
                    sb = new StringBuilder();
                }
                while (nextLine != null && !nextLine.startsWith("END_TSI_COMMENT")) {
                    nextLine = this.input.readLine();
                    if (sb == null || nextLine.startsWith("END_TSI_COMMENT")) continue;
                    sb.append(nextLine).append(lineSep);
                }
                if (sb != null && sb.length() > 0) {
                    logger.debug((Object)sb.toString());
                }
                nextLine = this.input.readLine();
            }
            return nextLine;
        }

        public void die() {
            try {
                this.output.close();
                this.input.close();
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean isAlive() {
            try {
                String rtn;
                this.output.print("#TSI_PING\nENDOFMESSAGE\n");
                this.output.flush();
                do {
                    if ((rtn = this.getALine()) != null) continue;
                    return false;
                } while (!rtn.contains("ENDOFMESSAGE"));
            }
            catch (Exception ex) {
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Command[");
            TSIConnection.this.appendSocketInfo(this.socket, sb);
            sb.append("]");
            return sb.toString();
        }
    }
}

