/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.legacy;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.jsdl.JSDLResourceSet;
import de.fzj.unicore.xnjs.legacy.TSIConnection;
import de.fzj.unicore.xnjs.legacy.TSIConnectionFactory;
import de.fzj.unicore.xnjs.legacy.TSIUtils;
import de.fzj.unicore.xnjs.resources.ResourceSet;
import de.fzj.unicore.xnjs.tsi.IReservation;
import de.fzj.unicore.xnjs.tsi.ReservationStatus;
import de.fzj.unicore.xnjs.util.ErrorCode;
import de.fzj.unicore.xnjs.util.LogUtil;
import eu.unicore.security.Client;
import java.io.BufferedReader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;

public class Reservation
implements IReservation {
    private static final Logger logger = LogUtil.getLogger("unicore.services.jobexecution", Reservation.class);
    private final Configuration configuration;
    public static final String ADMIN_PROPERTY = "CLASSICTSI.reservationAdminUser";

    public Reservation(Configuration config) {
        this.configuration = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelReservation(String reservationID, Client client) throws ExecutionException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cancel reservation " + reservationID + " for client " + client));
            }
            String tsiCmd = TSIUtils.makeCancelReservationCommand(reservationID);
            TSIConnection conn = null;
            String userID = this.getReservationAdmin(client);
            try {
                conn = this.configuration.getComponentInstanceOfType(TSIConnectionFactory.class).getTSIConnection(userID, null);
                String res = conn.send(tsiCmd);
                if (res.contains("TSI_FAILED")) {
                    String msg = "Resource reservation on classic TSI failed. Reply was <" + res + ">";
                    ErrorCode ec = new ErrorCode(12, msg);
                    throw new ExecutionException(ec);
                }
            }
            finally {
                if (conn != null) {
                    conn.done();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Could not cancel reservation.", (Throwable)e);
            throw new ExecutionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeReservation(XmlObject resources, Calendar startTime, Client client) throws ExecutionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Processing resource reservation " + resources.toString() + "\nStart time " + startTime.getTime().toString()));
        }
        ResourcesType resourceRequest = ResourcesDocument.Factory.parse((String)resources.toString()).getResources();
        ResourceSet incarnated = this.configuration.getGrounder().incarnateResources(new JSDLResourceSet(resourceRequest), client);
        String tsiCmd = TSIUtils.makeMakeReservationCommand(incarnated, startTime, this.configuration.getIDB(), client);
        TSIConnection conn = null;
        try {
            String resID;
            String admin = this.getReservationAdmin(client);
            conn = this.configuration.getComponentInstanceOfType(TSIConnectionFactory.class).getTSIConnection(admin, null);
            String res = conn.send(tsiCmd);
            if (res.contains("TSI_FAILED")) {
                String msg = "Resource reservation on classic TSI failed. Reply was <" + res + ">";
                ErrorCode ec = new ErrorCode(12, msg);
                throw new ExecutionException(ec);
            }
            String string = resID = res.replace("TSI_OK", "").trim();
            if (conn != null) {
                conn.done();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (conn != null) {
                    conn.done();
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.error((Object)"Could not reserve resources.", (Throwable)e);
                throw new ExecutionException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReservationStatus queryReservation(String reservationID, Client client) throws ExecutionException {
        ReservationStatus rs = new ReservationStatus();
        rs.setStatus(ReservationStatus.Status.UNKNOWN);
        try {
            String res;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Querying resource reservation " + reservationID + " for client " + client.getDistinguishedName()));
            }
            String tsiCmd = TSIUtils.makeQueryReservationCommand(reservationID);
            TSIConnection conn = null;
            try {
                String admin = this.getReservationAdmin(client);
                conn = this.configuration.getComponentInstanceOfType(TSIConnectionFactory.class).getTSIConnection(admin, null);
                res = conn.send(tsiCmd);
                if (res.contains("TSI_FAILED")) {
                    String msg = "Query resource reservation on classic TSI failed. Reply was <" + res + ">";
                    ErrorCode ec = new ErrorCode(12, msg);
                    throw new ExecutionException(ec);
                }
            }
            finally {
                if (conn != null) {
                    conn.done();
                }
            }
            rs = this.parseTSIReply(res);
        }
        catch (Exception e) {
            LogUtil.logException("Could not query reservation.", e, logger);
            throw new ExecutionException(e);
        }
        return rs;
    }

    protected String getReservationAdmin(Client client) {
        String admin = this.configuration.getIDB().getProperty(ADMIN_PROPERTY);
        if (admin == null && client != null && client.getXlogin() != null) {
            admin = client.getXlogin().getUserName();
        }
        return admin;
    }

    protected ReservationStatus parseTSIReply(String tsiReply) throws Exception {
        ReservationStatus rs = new ReservationStatus();
        BufferedReader br = new BufferedReader(new StringReader(tsiReply));
        String line = br.readLine();
        if (line == null || !"TSI_OK".equals(line)) {
            throw new Exception("TSI reply <" + tsiReply + "> has wrong format: expect TSI_OK as first line");
        }
        line = br.readLine();
        String[] reply = line.trim().split(" ");
        rs.setStatus(ReservationStatus.Status.valueOf(reply[0].trim()));
        if (reply.length > 1) {
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            Calendar c = Calendar.getInstance();
            c.setTime(sf.parse(reply[1]));
            rs.setStartTime(c);
        }
        if ((line = br.readLine()) != null) {
            rs.setDescription(line);
        }
        return rs;
    }
}

