/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.legacy;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.ExecutionContext;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.ACLEntry;
import de.fzj.unicore.xnjs.io.ChangeACL;
import de.fzj.unicore.xnjs.io.ChangePermissions;
import de.fzj.unicore.xnjs.io.FileFilter;
import de.fzj.unicore.xnjs.io.Permissions;
import de.fzj.unicore.xnjs.io.XnjsFile;
import de.fzj.unicore.xnjs.io.XnjsFileImpl;
import de.fzj.unicore.xnjs.io.XnjsFileWithACL;
import de.fzj.unicore.xnjs.io.XnjsStorageInfo;
import de.fzj.unicore.xnjs.jsdl.IncarnationDataBase;
import de.fzj.unicore.xnjs.legacy.TSIConnection;
import de.fzj.unicore.xnjs.legacy.TSIConnectionFactory;
import de.fzj.unicore.xnjs.legacy.TSIUtils;
import de.fzj.unicore.xnjs.management.Dependency;
import de.fzj.unicore.xnjs.management.Lifecycle;
import de.fzj.unicore.xnjs.tsi.MultiNodeTSI;
import de.fzj.unicore.xnjs.tsi.TSIBusyException;
import de.fzj.unicore.xnjs.tsi.TSIUnavailableException;
import de.fzj.unicore.xnjs.util.ErrorCode;
import de.fzj.unicore.xnjs.util.IOUtils;
import de.fzj.unicore.xnjs.util.LogUtil;
import eu.unicore.security.Client;
import eu.unicore.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import org.apache.log4j.Logger;

@Dependency(classes={TSIConnectionFactory.class})
@Lifecycle(isSingleton=false)
public class LegacyTSI
implements MultiNodeTSI {
    private static final Logger tsiLogger = LogUtil.getLogger("unicore.xnjs.tsi", LegacyTSI.class);
    public static final String SUPPORTED_TSI_VERSION = "6.4.2";
    private StringBuilder commands = new StringBuilder();
    private String user = "nobody";
    private String group = "NONE";
    private ExecutionContext ec;
    private boolean autoCommit;
    private Client client;
    private String CD = "cd";
    private String CP = "/bin/cp";
    private String LN = "/bin/ln -s";
    private String MV = "/bin/mv";
    private String RM = "/bin/rm";
    private String RMDIR = "/bin/rm -rf";
    private String MKDIR = "/bin/mkdir -p";
    private String CHMOD = "/bin/chmod";
    private String CHGRP = "/bin/chgrp";
    private String GROUPS = "groups";
    private String MKFIFO = "/bin/mkfifo";
    private String UMASK = "umask";
    private String TSI_LS = "tsi_NOBATCH/tsi_ls";
    private String TSI_DF = null;
    private String PERL = "/usr/bin/perl";
    private String FILESEPARATOR = "/";
    private static final int DEFAULT_BUFSIZE = 0x100000;
    final TSIConnectionFactory factory;
    private int bufsize;
    private final String tsiVersion;
    private final Configuration configuration;
    private String storageRoot = "/";
    private String preferredHost = null;
    private String lastUsedTSIHost = null;
    private int umask = 63;
    private boolean nonACLTSIVersion = false;
    private static boolean issuedWarning = false;

    public LegacyTSI(Configuration config) {
        this.configuration = config;
        IncarnationDataBase idb = this.configuration.getIDB();
        this.factory = this.configuration.getComponentInstanceOfType(TSIConnectionFactory.class);
        this.tsiVersion = this.factory.getTSIVersion();
        this.CD = idb.getProperty("CLASSICTSI.CD", this.CD);
        this.UMASK = idb.getProperty("CLASSICTSI.UMASK", this.UMASK);
        this.CP = idb.getProperty("CLASSICTSI.CP", this.CP);
        this.LN = idb.getProperty("CLASSICTSI.LN", this.LN);
        this.MV = idb.getProperty("CLASSICTSI.MV", this.MV);
        this.RM = idb.getProperty("CLASSICTSI.RM", this.RM);
        this.RMDIR = idb.getProperty("CLASSICTSI.RMDIR", this.RMDIR);
        this.MKDIR = idb.getProperty("CLASSICTSI.MKDIR", this.MKDIR);
        this.CHMOD = idb.getProperty("CLASSICTSI.CHMOD", this.CHMOD);
        this.CHGRP = idb.getProperty("CLASSICTSI.CHGRP", this.CHGRP);
        this.GROUPS = idb.getProperty("CLASSICTSI.GROUPS", this.GROUPS);
        this.MKFIFO = idb.getProperty("CLASSICTSI.MKFIFO", this.MKFIFO);
        this.TSI_LS = idb.getProperty("CLASSICTSI.TSI_LS", this.TSI_LS);
        this.TSI_DF = idb.getProperty("CLASSICTSI.TSI_DF", null);
        this.PERL = idb.getProperty("CLASSICTSI.PERL", this.PERL);
        this.FILESEPARATOR = idb.getProperty("CLASSICTSI.FILESEPARATOR", "/");
        try {
            this.bufsize = Integer.parseInt(idb.getProperty("CLASSICTSI.BUFFERSIZE", "1048576"));
        }
        catch (NumberFormatException e) {
            this.bufsize = 0x100000;
        }
        if (!TSIUtils.compareVersion(this.tsiVersion, SUPPORTED_TSI_VERSION)) {
            this.nonACLTSIVersion = true;
            if (!issuedWarning) {
                tsiLogger.warn((Object)("The TSI version which you use (" + this.tsiVersion + ") is outdated. XNJS will try to work in backwards " + "compatible way but some features won't work. " + "It is strongly suggested to update your TSI."));
                issuedWarning = true;
            }
        }
    }

    @Override
    public void setPreferredTSIHost(String host) {
        this.preferredHost = host;
    }

    @Override
    public String getLastUsedTSIHost() {
        return this.lastUsedTSIHost;
    }

    @Override
    public void setClient(Client client) {
        this.client = client;
        if (client != null) {
            this.user = client.getSelectedXloginName();
            this.group = TSIUtils.prepareGroupsString(client, this.tsiVersion);
        } else {
            this.user = "nobody";
            this.group = "NONE";
        }
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    private void begin() throws ExecutionException {
        this.commands = new StringBuilder();
    }

    private String makeTarget(String target) {
        return this.getStorageRoot() + this.FILESEPARATOR + target;
    }

    private void commit() throws ExecutionException {
        if (this.commands.length() == 0) {
            return;
        }
        String tsiCmd = TSIUtils.makeExecuteScript(this.commands.toString(), this.ec, this.configuration);
        this.doTSICommand(tsiCmd);
    }

    private String doTSICommand(String tsiCmd) throws ExecutionException {
        return this.doTSICommandLowLevel(tsiCmd, this.group);
    }

    private String doTSICommandWithAllGroups(String tsiCmd) throws ExecutionException {
        String groups = null;
        if (this.client != null) {
            groups = TSIUtils.prepareAllGroupsString(this.client, this.tsiVersion);
        }
        return this.doTSICommandLowLevel(tsiCmd, groups);
    }

    private String doTSICommandLowLevel(String tsiCmd, String groups) throws ExecutionException {
        String res = "";
        TSIConnection conn = null;
        try {
            conn = this.factory.getTSIConnection(this.user, groups, this.preferredHost);
            res = conn.send(tsiCmd);
            if (!res.contains("TSI_OK")) {
                String msgShort = "Command execution on TSI failed. Reply was: \n" + res;
                ErrorCode ec = new ErrorCode(12, msgShort);
                throw new ExecutionException(ec);
            }
            if (this.factory.getTSIHosts().length > 0) {
                this.lastUsedTSIHost = conn.getTSIAddress().getHostName();
            }
        }
        catch (IOException ioe) {
            conn.dead();
            String msgShort = Log.createFaultMessage((String)"Command execution on TSI failed.", (Throwable)ioe);
            ErrorCode ec = new ErrorCode(11, msgShort);
            throw new ExecutionException(ec);
        }
        finally {
            this.ec = null;
            this.begin();
            if (conn != null) {
                conn.done();
            }
        }
        return res;
    }

    @Override
    public void chmod(String file, Permissions perm) throws ExecutionException {
        this.begin();
        String target = this.makeTarget(file);
        this.commands.append(this.CHMOD + " u=" + perm.toString() + " \"" + target + "\"\n");
        this.commit();
    }

    private String canonPerms(String original) {
        char[] chars = original.toCharArray();
        StringBuilder ret = new StringBuilder();
        for (char c : chars) {
            if (c != 'r' && c != 'x' && c != 'w' && c != 'X') continue;
            ret.append(c);
        }
        return ret.toString();
    }

    @Override
    public void chmod2(String file, ChangePermissions[] perms, boolean recursive) throws ExecutionException {
        this.begin();
        String target = this.makeTarget(file);
        for (ChangePermissions perm : perms) {
            String pperms = this.canonPerms(perm.getPermissions());
            String rec = recursive ? "-R " : "";
            this.commands.append(this.CHMOD + " " + rec + perm.getClazzSymbol() + perm.getModeOperator() + pperms + " \"" + target + "\"\n");
        }
        this.commit();
    }

    @Override
    public void chgrp(String file, String newGroup, boolean recursive) throws ExecutionException {
        this.begin();
        String target = this.makeTarget(file);
        String rec = recursive ? "-R " : "";
        this.commands.append(this.CHGRP + " " + rec + newGroup + " \"" + target + "\"");
        this.commit();
    }

    @Override
    public void cp(String source, String target) throws ExecutionException {
        this.begin();
        this.commands.append(this.UMASK + " " + Integer.toOctalString(this.umask) + "\n");
        this.commands.append(this.CP + " \"" + this.makeTarget(source) + "\" \"" + this.makeTarget(target) + "\"\n");
        this.commit();
    }

    @Override
    public void link(String target, String linkName) throws ExecutionException {
        this.begin();
        this.commands.append(this.LN + " \"" + this.makeTarget(target) + "\" \"" + this.makeTarget(linkName) + "\"\n");
        this.commit();
    }

    @Override
    public void rename(String source, String target) throws ExecutionException {
        this.begin();
        this.commands.append(this.UMASK + " " + Integer.toOctalString(this.umask) + "\n");
        this.commands.append(this.MV + " \"" + this.makeTarget(source) + "\" \"" + this.makeTarget(target) + "\"\n");
        this.commit();
    }

    @Override
    public void exec(String what, ExecutionContext ec) throws ExecutionException {
        this.begin();
        this.commands.append(this.CD + " \"" + ec.getWorkingDirectory() + "\"\n");
        this.commands.append(this.UMASK + " " + Integer.toOctalString(this.umask) + "\n");
        this.commands.append(what);
        this.ec = ec;
        this.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execAndWait(String what, ExecutionContext ec) throws ExecutionException {
        try {
            this.begin();
            this.commands.append(this.CD + " \"" + ec.getWorkingDirectory() + "\"\n");
            this.commands.append(this.UMASK + " " + Integer.toOctalString(this.umask) + "\n");
            if (ec != null && ec.getStdout() != null) {
                what = what + " > " + ec.getStdout();
            }
            if (ec != null && ec.getStderr() != null) {
                what = what + " 2> " + ec.getStderr();
            }
            this.commands.append(what);
            this.ec = ec;
            ec.setInteractive(true);
            this.commit();
            tsiLogger.debug((Object)("Executed " + what + " in " + ec.getWorkingDirectory()));
            InputStream is = null;
            BufferedReader br = null;
            String oldRoot = this.storageRoot;
            try {
                this.storageRoot = "/";
                is = this.getInputStream(ec.getWorkingDirectory() + "/" + "UNICORE_SCRIPT_EXIT_CODE");
                br = new BufferedReader(new InputStreamReader(is));
                String s = br.readLine();
                int i = Integer.parseInt(s);
                ec.setExitCode(i);
                tsiLogger.debug((Object)("Script exited with code <" + i + ">"));
            }
            finally {
                this.storageRoot = oldRoot;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ignored) {}
                }
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
        catch (Exception e) {
            throw new ExecutionException("Can't execute script.", e);
        }
    }

    public boolean getAutoCommit() throws ExecutionException {
        return this.autoCommit;
    }

    @Override
    public void mkdir(String dir) throws ExecutionException {
        this.begin();
        String target = this.makeTarget(dir);
        this.commands.append(this.MKDIR + " \"" + target + "\"\n");
        this.commands.append(this.CHMOD + " " + TSIUtils.getDirPerm(this.umask) + " \"" + target + "\"\n");
        this.commit();
    }

    @Override
    public void mkfifo(String fifo) throws ExecutionException {
        this.begin();
        String target = this.makeTarget(fifo);
        this.commands.append(this.MKFIFO + " \"" + target + "\"\n");
        this.commands.append(this.CHMOD + " " + TSIUtils.getFilePerm(this.umask) + " \"" + target + "\"\n");
        this.commit();
    }

    @Override
    public String getFileSeparator() {
        return this.FILESEPARATOR;
    }

    @Override
    public String getHomePath() throws ExecutionException {
        return this.getEnvironment("HOME");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEnvironment(String name) throws ExecutionException {
        TSIConnection conn = null;
        try {
            String res;
            try {
                conn = this.factory.getTSIConnection(this.user, this.group);
                String cmd = "echo ${" + name + "}";
                String tsicmd = TSIUtils.makeExecuteScript(cmd, null, this.configuration);
                res = conn.send(tsicmd);
            }
            finally {
                if (conn != null) {
                    conn.done();
                }
            }
            if (!res.contains("TSI_OK")) {
                String msg = "Command execution failed. TSI reply:" + res;
                ErrorCode ec = new ErrorCode(12, msg);
                throw new ExecutionException(ec);
            }
            return res.replace("TSI_OK", "").trim();
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public String resolve(String name) throws ExecutionException {
        TSIConnection conn = null;
        try {
            conn = this.factory.getTSIConnection(this.user, this.group);
            String cmd = "echo " + name;
            String tsicmd = TSIUtils.makeExecuteScript(cmd, null, this.configuration);
            String res = conn.send(tsicmd);
            if (!res.contains("TSI_OK")) {
                String msg = "Command execution failed. TSI reply:" + res;
                ErrorCode ec = new ErrorCode(12, msg);
                throw new ExecutionException(ec);
            }
            String string = res.replace("TSI_OK", "").trim();
            return string;
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
        finally {
            if (conn != null) {
                conn.done();
            }
        }
    }

    @Override
    public void rm(String target) throws ExecutionException {
        this.begin();
        this.commands.append(this.RM + " \"" + this.makeTarget(target) + "\"\n");
        this.commit();
    }

    @Override
    public void rmdir(String target) throws ExecutionException {
        this.begin();
        this.commands.append(this.RMDIR + " \"" + this.makeTarget(target) + "\"\n");
        this.commit();
    }

    public void setAutoCommit(boolean autoCommit) throws ExecutionException {
        this.autoCommit = autoCommit;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public XnjsFile[] ls(String base, int offset, int limit, boolean filter) throws ExecutionException {
        String res = null;
        res = this.doLS(base, true, false);
        ArrayList<XnjsFileImpl> files = new ArrayList<XnjsFileImpl>();
        BufferedReader br = new BufferedReader(new StringReader(res + "\n"));
        int pos = 0;
        while (true) {
            ++pos;
            String[] lines = TSIUtils.readTSILSLine(br, this.tsiVersion);
            if (lines[0] == null) {
                return files.toArray(new XnjsFile[0]);
            }
            if (pos <= offset) continue;
            XnjsFileImpl xFile = this.parseLine(lines);
            if (!filter || xFile.isOwnedByCaller() || xFile.getPermissions().isAccessible()) {
                files.add(xFile);
            }
            if (files.size() == limit) break;
        }
        return files.toArray(new XnjsFile[0]);
    }

    @Override
    public XnjsFile[] ls(String base) throws ExecutionException {
        return this.ls(base, 0, Integer.MAX_VALUE, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public XnjsFile[] find(String path, FileFilter filter, int offset, int limit) throws ExecutionException {
        String res = null;
        boolean recurse = filter != null && filter.recurse();
        res = this.doLS(path, true, recurse);
        ArrayList<XnjsFileImpl> files = new ArrayList<XnjsFileImpl>();
        BufferedReader br = new BufferedReader(new StringReader(res + "\n"));
        int pos = 0;
        while (true) {
            ++pos;
            String[] lines = TSIUtils.readTSILSLine(br, this.tsiVersion);
            if (lines[0] == null) {
                return files.toArray(new XnjsFile[0]);
            }
            if (pos <= offset) continue;
            XnjsFileImpl f = this.parseLine(lines);
            if (filter != null && !filter.accept(f, this)) continue;
            files.add(f);
            if (files.size() == limit) break;
        }
        return files.toArray(new XnjsFile[0]);
    }

    @Override
    public XnjsFileWithACL getProperties(String path) throws ExecutionException {
        String[] lines;
        String res = null;
        String target = path;
        res = this.doLS(target, false, false);
        ArrayList<XnjsFileImpl> files = new ArrayList<XnjsFileImpl>();
        BufferedReader br = new BufferedReader(new StringReader(res + "\n"));
        while ((lines = TSIUtils.readTSILSLine(br, this.tsiVersion))[0] != null) {
            files.add(this.parseLine(lines));
        }
        if (files.size() < 1) {
            return null;
        }
        XnjsFileImpl ret = (XnjsFileImpl)files.get(0);
        this.getfacl(path, ret);
        return ret;
    }

    public String doLS(String file, boolean normal, boolean recurse) throws ExecutionException {
        String loc = this.TSI_LS;
        String cmd = this.PERL + " " + loc;
        String target = this.makeTarget(file);
        cmd = recurse && normal ? cmd + " R \"" + target + "\"" : (normal ? cmd + " N \"" + target + "\"" : cmd + " A \"" + target + "\"");
        if (tsiLogger.isDebugEnabled()) {
            tsiLogger.debug((Object)("Executing tsi ls() command: " + cmd));
        }
        return this.doExecuteScript(cmd);
    }

    String doExecuteScript(String cmd) throws ExecutionException {
        String tsicmd = TSIUtils.makeExecuteScript(cmd, null, this.configuration);
        TSIConnection conn = null;
        try {
            conn = this.factory.getTSIConnection(this.user, this.group);
            String res = conn.send(tsicmd);
            if (res.startsWith("TSI_FAILED")) {
                throw new IOException("TSI ERROR: Could not execute command: <" + cmd + "> TSI reply: " + res);
            }
            String string = res;
            return string;
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
        finally {
            if (conn != null) {
                conn.done();
            }
        }
    }

    protected XnjsFileImpl parseLine(String[] lines) {
        String[] tok = lines[0].substring(7).split(" ", 3);
        int l = tok.length;
        String fullPath = tok[l - 1];
        boolean isDirectory = lines[0].charAt(1) == 'D';
        boolean isReadable = lines[0].charAt(2) == 'R';
        boolean isWritable = lines[0].charAt(3) == 'W';
        boolean isExecutable = lines[0].charAt(4) == 'X';
        boolean isOwnedByCaller = lines[0].charAt(5) == 'O';
        long size = Long.parseLong(tok[l - 3]);
        long lastMod = Long.parseLong(tok[l - 2]) * 1000L;
        Permissions p = new Permissions(isReadable, isWritable, isExecutable);
        String name = IOUtils.getRelativePath(fullPath, this.storageRoot);
        String unixPerms = null;
        String owner = null;
        String owningGroup = null;
        if (lines[1] != null) {
            unixPerms = lines[1].substring(2, 11);
            String[] ownership = lines[1].substring(12).split(" ", 3);
            owner = ownership[0];
            owningGroup = ownership[1];
        }
        XnjsFileImpl f = new XnjsFileImpl(name, size, isDirectory, lastMod, p, isOwnedByCaller, owner, owningGroup, unixPerms);
        return f;
    }

    public XnjsStorageInfo doDF(String path) throws ExecutionException {
        String loc = this.TSI_DF;
        if (loc == null) {
            return XnjsStorageInfo.unknown();
        }
        String cmd = this.PERL + " " + loc + " " + path;
        if (tsiLogger.isDebugEnabled()) {
            tsiLogger.debug((Object)("Executing tsi df() command: " + cmd));
        }
        String res = null;
        try {
            res = this.doExecuteScript(cmd);
            return this.parseDFReply(res);
        }
        catch (Exception ex) {
            throw new ExecutionException("Error executing TSI_DF. Reply was " + res);
        }
    }

    private XnjsStorageInfo parseDFReply(String dfReply) throws ExecutionException {
        String line;
        XnjsStorageInfo info = new XnjsStorageInfo();
        BufferedReader br = new BufferedReader(new StringReader(dfReply + "\n"));
        while ((line = TSIUtils.readTSIDFLine(br)) != null) {
            String[] parts = line.split(" ");
            String key = parts[0];
            long value = Long.valueOf(parts[1]);
            if ("TOTAL".equalsIgnoreCase(key)) {
                info.setTotalSpace(value);
                continue;
            }
            if ("FREE".equalsIgnoreCase(key)) {
                info.setFreeSpace(value);
                continue;
            }
            if (!"USER".equalsIgnoreCase(key)) continue;
            info.setUsableSpace(value);
        }
        return info;
    }

    @Override
    public InputStream getInputStream(final String file) throws ExecutionException {
        final String target = this.makeTarget(file);
        if (tsiLogger.isDebugEnabled()) {
            tsiLogger.debug((Object)("Reading from '" + target + "'"));
        }
        return new InputStream(){
            byte[] buffer;
            int avail;
            int pos;
            long bytesRead;
            long length;
            {
                this.buffer = new byte[LegacyTSI.this.bufsize];
                this.avail = 0;
                this.pos = 0;
                this.bytesRead = 0L;
                this.length = LegacyTSI.this.readLength(file);
            }

            @Override
            public int read() throws IOException {
                try {
                    if (this.avail == 0 && this.bytesRead < this.length) {
                        this.fillBuffer();
                    }
                }
                catch (Exception e) {
                    throw new IOException("Error reading from TSI", e);
                }
                if (this.avail > 0) {
                    --this.avail;
                    ++this.bytesRead;
                    return this.buffer[this.pos++] & 0xFF;
                }
                return -1;
            }

            private void fillBuffer() throws IOException {
                long numBytes = Math.min(this.length - this.bytesRead, (long)this.buffer.length);
                this.avail = LegacyTSI.this.readChunk(target, this.buffer, this.bytesRead, numBytes);
                this.pos = 0;
                tsiLogger.debug((Object)("Read <" + this.avail + "> bytes into buffer."));
            }

            @Override
            public void close() throws IOException {
                super.close();
            }

            @Override
            public long skip(long n) throws IOException {
                if (n <= 0L) {
                    return 0L;
                }
                this.avail = 0;
                if (this.bytesRead + n < this.length) {
                    this.bytesRead += n;
                    return n;
                }
                long skipped = this.length - this.bytesRead;
                this.bytesRead = this.length;
                return skipped;
            }
        };
    }

    protected long readLength(String file) throws ExecutionException {
        long lengthFromLS;
        block0: {
            String res = this.doLS(file, false, false);
            lengthFromLS = 0L;
            BufferedReader br = new BufferedReader(new StringReader(res + "\n"));
            String[] lines = TSIUtils.readTSILSLine(br, this.tsiVersion);
            if (lines[0] == null) break block0;
            lengthFromLS = this.parseLine(lines).getSize();
        }
        return lengthFromLS;
    }

    private int readChunk(String file, byte[] buf, long offset, long length) throws IOException {
        if (tsiLogger.isDebugEnabled()) {
            tsiLogger.debug((Object)("read from <" + file + "> numbytes=" + length));
        }
        String tsicmd = TSIUtils.makeGetFileChunkCommand(file, offset, length);
        TSIConnection conn = null;
        try {
            String l;
            conn = this.factory.getTSIConnection(this.user, this.group);
            String res = conn.send(tsicmd);
            if (!res.contains("TSI_OK")) {
                String msg = "Command execution failed. TSI reply:" + res;
                ErrorCode ec = new ErrorCode(12, msg);
                throw new ExecutionException(ec);
            }
            if (tsiLogger.isDebugEnabled()) {
                tsiLogger.debug((Object)("TSI response: '" + res + "'"));
            }
            int av = 0;
            BufferedReader br = new BufferedReader(new StringReader(res));
            while ((l = br.readLine()) != null) {
                if (!l.startsWith("TSI_LENGTH")) continue;
                av = Integer.parseInt(l.split(" ")[1]);
                break;
            }
            conn.getData(buf, 0, av);
            conn.getLine();
            int n = av;
            return n;
        }
        catch (Exception e) {
            if (conn != null) {
                try {
                    conn.dead();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            IOException io = new IOException("Error reading from TSI");
            io.initCause(e);
            throw io;
        }
        finally {
            if (conn != null) {
                conn.done();
            }
        }
    }

    @Override
    public OutputStream getOutputStream(String file) throws ExecutionException {
        return this.getOutputStream(file, false);
    }

    @Override
    public OutputStream getOutputStream(String file, boolean append) throws ExecutionException {
        String target = this.makeTarget(file);
        if (tsiLogger.isDebugEnabled()) {
            tsiLogger.debug((Object)("file <" + target + "> append=" + append));
        }
        return new LegacyTSIOutputStream(target, append, this.bufsize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeChunk(String file, byte[] buf, int numBytes, boolean append) throws IOException, TSIUnavailableException, ExecutionException {
        if (tsiLogger.isDebugEnabled()) {
            tsiLogger.debug((Object)("Write to " + file + ", append=" + append + ", numBytes=" + numBytes));
        }
        String tsicmd = TSIUtils.makePutFilesCommand(append);
        if (tsiLogger.isDebugEnabled()) {
            tsiLogger.debug((Object)("TSI command: \n" + tsicmd));
        }
        TSIConnection conn = null;
        try {
            conn = this.factory.getTSIConnection(this.user, this.group);
            String res = conn.send(tsicmd);
            if (!res.contains("TSI_OK")) {
                throw new IOException("Execution on legacy TSI failed. Reply was " + res);
            }
            String permissions = this.nonACLTSIVersion ? "6" : TSIUtils.getFilePerm(this.umask);
            res = conn.send(file + " " + permissions + "\n\n");
            if (!res.contains("TSI_OK")) {
                throw new IOException("Execution on legacy TSI failed. Reply was " + res);
            }
            res = conn.send("" + numBytes + "\n");
            if (!res.contains("TSI_OK")) {
                throw new IOException("Execution on legacy TSI failed. Reply was " + res);
            }
            conn.sendData(buf, 0, numBytes);
            res = conn.sendNoUser("-1\n");
            if (res.startsWith("TSI_FAILED")) {
                throw new IOException("Failed to send file: " + res);
            }
            res = conn.sendNoUser("-1\n");
            if (res.startsWith("TSI_FAILED")) {
                throw new IOException("Failed to terminate classic TSI PutFiles sequence.");
            }
        }
        finally {
            if (conn != null) {
                conn.done();
            }
        }
    }

    @Override
    public String getFileSystemIdentifier() {
        try {
            String fsID = this.configuration.getIDB().getProperty("CLASSICTSI.FSID");
            if (fsID != null) {
                return fsID;
            }
            TSIConnectionFactory tcf = this.configuration.getComponentInstanceOfType(TSIConnectionFactory.class);
            return "PERL TSI at " + tcf.getTSIMachine();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public XnjsStorageInfo getAvailableDiskSpace(String path) {
        try {
            return this.doDF(path);
        }
        catch (ExecutionException ex) {
            LogUtil.logException("Could not determine disk space information", ex, tsiLogger);
            return XnjsStorageInfo.unknown();
        }
    }

    @Override
    public void setStorageRoot(String root) {
        this.storageRoot = root;
    }

    @Override
    public String getStorageRoot() {
        return this.storageRoot;
    }

    @Override
    public String[] getGroups() throws TSIBusyException, ExecutionException {
        String cmd = TSIUtils.makeExecuteScript(this.GROUPS, this.ec, this.configuration);
        String reply = this.doTSICommandWithAllGroups(cmd);
        try {
            String groups = TSIUtils.readTSIDFLine(new BufferedReader(new StringReader(reply)));
            return groups.split("\\s+");
        }
        catch (Exception ex) {
            throw new ExecutionException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String faclCommon(String file, String command) throws ExecutionException {
        String res;
        String target = this.makeTarget(file);
        String tsicmd = command + "#TSI_ACL_PATH " + target + "\n";
        tsiLogger.debug((Object)("TSI command: \n" + tsicmd));
        TSIConnection conn = null;
        try {
            conn = this.factory.getTSIConnection(this.user, this.group);
            try {
                res = conn.send(tsicmd);
            }
            catch (IOException e) {
                throw new ExecutionException("Problem sending ACL operation to legacy TSI.", e);
            }
        }
        finally {
            if (conn != null) {
                conn.done();
            }
        }
        if (!res.contains("TSI_OK")) {
            throw new ExecutionException("ACL operation on legacy TSI failed. Reply was " + res);
        }
        return res;
    }

    public void getfacl(String file, XnjsFileImpl ret) throws ExecutionException {
        if (!this.isACLSupported("/")) {
            return;
        }
        String cmd = "#TSI_FILE_ACL\n#TSI_ACL_OPERATION GETFACL\n";
        String res = this.faclCommon(file, cmd);
        String[] entries = res.split("\n");
        ACLEntry[] aclEntries = entries.length > 1 ? new ACLEntry[entries.length - 1] : new ACLEntry[]{};
        for (int i = 1; i < entries.length; ++i) {
            boolean defaultACL;
            String[] subentries = entries[i].split(":");
            int off = 0;
            if (subentries[0].equals("default")) {
                defaultACL = true;
                ++off;
            } else {
                defaultACL = false;
            }
            ACLEntry.Type type = subentries[off].equals("group") ? ACLEntry.Type.GROUP : ACLEntry.Type.USER;
            aclEntries[i - 1] = new ACLEntry(type, subentries[off + 1], subentries[off + 2], defaultACL);
        }
        ret.setACL(aclEntries);
    }

    @Override
    public void setfacl(String file, boolean clearAll, ChangeACL[] changeACL, boolean recursive) throws ExecutionException {
        String recStr;
        if (!this.isACLSupported("/")) {
            throw new ExecutionException("Setting file ACLs is not supported on this storage.");
        }
        String cmdBase = "#TSI_FILE_ACL\n#TSI_ACL_OPERATION SETFACL\n";
        String string = recStr = recursive ? " RECURSIVE" : "";
        if (clearAll) {
            StringBuilder cmd = new StringBuilder();
            cmd.append(cmdBase);
            cmd.append("#TSI_ACL_COMMAND RM_ALL").append(recStr).append("\n");
            this.faclCommon(file, cmd.toString());
        }
        for (ChangeACL entry : changeACL) {
            StringBuilder cmd = new StringBuilder();
            cmd.append(cmdBase);
            cmd.append("#TSI_ACL_COMMAND ");
            if (entry.getChangeMode().equals((Object)ChangeACL.ACLChangeMode.REMOVE)) {
                cmd.append("RM").append(recStr).append("\n");
            } else {
                cmd.append("MODIFY").append(recStr).append("\n");
            }
            cmd.append("#TSI_ACL_COMMAND_SPEC ");
            if (entry.isDefaultACL()) {
                cmd.append("D");
            }
            if (entry.getType().equals((Object)ACLEntry.Type.GROUP)) {
                cmd.append("G ");
            } else {
                cmd.append("U ");
            }
            cmd.append(entry.getSubject());
            cmd.append(" ");
            cmd.append(entry.getPermissions());
            cmd.append("\n");
            this.faclCommon(file, cmd.toString());
        }
    }

    private boolean getACLSupportFromTSI(String path) throws ExecutionException {
        if (tsiLogger.isDebugEnabled()) {
            tsiLogger.debug((Object)("ACL query: " + path + " " + this.getStorageRoot() + " " + this));
        }
        String cmd = "#TSI_FILE_ACL\n#TSI_ACL_OPERATION CHECK_SUPPORT\n";
        String ret = this.faclCommon(path, cmd.toString());
        return ret.contains("true");
    }

    @Override
    public boolean isACLSupported(String path) throws ExecutionException {
        if (this.nonACLTSIVersion) {
            return false;
        }
        Boolean cached = this.configuration.getACLCachedSupport(this.storageRoot, path);
        if (cached != null) {
            return cached;
        }
        boolean fromTSI = this.getACLSupportFromTSI(path);
        this.configuration.cacheACLSupport(this.storageRoot, path, fromTSI);
        return fromTSI;
    }

    @Override
    public void setUmask(String umask) {
        this.umask = umask == null ? 63 : Integer.parseInt(umask, 8);
    }

    @Override
    public String getUmask() {
        return Integer.toOctalString(this.umask);
    }

    private class LegacyTSIOutputStream
    extends OutputStream {
        byte[] buffer = null;
        int pos = 0;
        boolean firstWrite = true;
        private boolean append;
        private String file;

        public LegacyTSIOutputStream(String file, boolean append, int size) {
            this.append = append;
            this.file = file;
            while (this.buffer == null) {
                try {
                    this.buffer = new byte[size];
                }
                catch (OutOfMemoryError mem) {
                    if ((size /= 2) >= 8192) continue;
                    throw new OutOfMemoryError();
                }
            }
        }

        @Override
        public void write(int b) throws IOException {
            if (this.pos >= this.buffer.length) {
                this.flush();
            }
            this.buffer[this.pos] = (byte)b;
            ++this.pos;
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }

        @Override
        public void flush() throws IOException {
            boolean doAppend = this.firstWrite ? this.append : true;
            try {
                LegacyTSI.this.writeChunk(this.file, this.buffer, this.pos, doAppend);
            }
            catch (TSIUnavailableException e) {
                IOException ioe = new IOException("TSI unavailable.");
                ioe.initCause(e);
                throw ioe;
            }
            catch (ExecutionException e) {
                IOException ioe = new IOException("TSI error");
                ioe.initCause(e);
                throw ioe;
            }
            this.firstWrite = false;
            this.pos = 0;
        }
    }
}

