/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.legacy;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.ExecutionContext;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.jsdl.IncarnationDataBase;
import de.fzj.unicore.xnjs.legacy.TSIConnection;
import de.fzj.unicore.xnjs.legacy.TSIConnectionFactory;
import de.fzj.unicore.xnjs.legacy.TSIUtils;
import de.fzj.unicore.xnjs.management.Dependency;
import de.fzj.unicore.xnjs.simple.BasicExecution;
import de.fzj.unicore.xnjs.tsi.ApplicationInfo;
import de.fzj.unicore.xnjs.tsi.TSI;
import de.fzj.unicore.xnjs.tsi.TSIUnavailableException;
import de.fzj.unicore.xnjs.util.ErrorCode;
import de.fzj.unicore.xnjs.util.IOUtils;
import de.fzj.unicore.xnjs.util.LogUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

@Dependency(classes={TSIConnectionFactory.class})
public class Execution
extends BasicExecution {
    private final Map<String, BSSInfo> bssInfo = new ConcurrentHashMap<String, BSSInfo>();
    private volatile BSSSummary summary = new BSSSummary();
    private final Logger tsiLog = LogUtil.getLogger("unicore.xnjs.tsi", Execution.class);
    private final Object lock = new Object();
    private int updateInterval;
    private int gracePeriod;
    private final TSIConnectionFactory factory = this.configuration.getComponentInstanceOfType(TSIConnectionFactory.class);
    public static final String UPDATE_INTERVAL = "CLASSICTSI.statusupdate.interval";
    public static final String DEFAULT_UPDATE_INTERVAL = "10000";
    public static final String DEFAULT_GRACE_PERIOD = "0";
    public static final String MAX_RUNTIME_FOR_INTERACTIVE_APPS = "CLASSICTSI.interactive_execution.maxtime";
    public static final String CLASSICTSI_PS = "CLASSICTSI.PS";
    public static final String CLASSICTSI_PS_DEFAULT = "ps -e";
    private static final Pattern psPattern = Pattern.compile("\\s?(\\d+)\\s*.*");

    public Execution(Configuration config) {
        super(config);
        this.updateConfigParameters();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    Execution.this.updateBSSStates();
                    Execution.this.updateConfigParameters();
                }
                catch (TSIUnavailableException tue) {
                    Execution.this.tsiLog.warn((Object)"TSI is not available.");
                }
                catch (Throwable e) {
                    Execution.this.tsiLog.warn((Object)"Problem updating BSS state", e);
                }
                Execution.this.configuration.getScheduledExecutor().schedule(this, (long)Execution.this.updateInterval, TimeUnit.MILLISECONDS);
            }
        };
        this.configuration.getScheduledExecutor().schedule(r, (long)this.updateInterval, TimeUnit.MILLISECONDS);
    }

    private void updateConfigParameters() {
        int newInterval;
        IncarnationDataBase idb = this.configuration.getIDB();
        try {
            newInterval = Integer.parseInt(idb.getProperty(UPDATE_INTERVAL, DEFAULT_UPDATE_INTERVAL));
        }
        catch (Exception e) {
            this.tsiLog.warn((Object)"Problem parsing property CLASSICTSI.statusupdate.interval, resetting to default.", (Throwable)e);
            newInterval = Integer.parseInt(DEFAULT_UPDATE_INTERVAL);
        }
        if (newInterval != this.updateInterval) {
            this.updateInterval = newInterval;
            this.tsiLog.info((Object)("Batch system state will be queried every <" + this.updateInterval + "> milliseconds."));
        }
        try {
            this.gracePeriod = this.updateInterval * Integer.parseInt(idb.getProperty("CLASSICTSI.statusupdate.grace", DEFAULT_GRACE_PERIOD));
        }
        catch (Exception e) {
            this.tsiLog.warn((Object)"Problem parsing property CLASSICTSI.statusupdate.grace, resetting to default.", (Throwable)e);
            this.gracePeriod = this.updateInterval * Integer.parseInt(DEFAULT_GRACE_PERIOD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(Action job) throws ExecutionException {
        TSIConnection conn = null;
        ApplicationInfo appDescription = job.getApplicationInfo();
        this.incarnationTweaker.preScript(appDescription, job, this.configuration.getIDB());
        ExecutionContext ec = job.getExecutionContext();
        if (ec.isInteractive()) {
            job.addLogTrace("Execution on login node");
        }
        try {
            String msg;
            String tsiCmdInitial = ec.isInteractive() ? TSIUtils.makeExecuteAsyncScript(job, this.configuration) : TSIUtils.makeSubmitCommand(job, this.configuration);
            String tsiCmd = this.incarnationTweaker.postScript(appDescription, job, this.configuration.getIDB(), tsiCmdInitial);
            String preferredTSIHost = ec.getPreferredExecutionHost();
            String tsiHost = null;
            TSIConnectionFactory tsif = this.configuration.getComponentInstanceOfType(TSIConnectionFactory.class);
            String idLine = "";
            Object object = this.lock;
            synchronized (object) {
                String res;
                try {
                    conn = tsif.getTSIConnection(job.getClient(), preferredTSIHost);
                    tsiHost = conn.getTSIHostName();
                    res = conn.send(tsiCmd);
                    idLine = conn.getIdLine();
                    job.addLogTrace("Command is: \n" + tsiCmd);
                    if (res.contains("TSI_FAILED")) {
                        job.addLogTrace("TSI reply: FAILED.");
                        throw new ExecutionException(new ErrorCode(11, "Submission to classic TSI failed. Reply was <" + res + ">"));
                    }
                }
                finally {
                    if (conn != null) {
                        conn.done();
                    }
                }
                job.addLogTrace("TSI reply: submission OK.");
                String bssid = res.trim();
                msg = "Submitted to classic TSI as [" + idLine + "] with BSSID=" + bssid;
                String internalID = bssid;
                String initialState = "QUEUED";
                if (job.getExecutionContext().isInteractive()) {
                    String iPid = this.readPID(job, tsiHost);
                    internalID = "INTERACTIVE_" + tsiHost + "_" + iPid;
                    msg = "Submitted to classic TSI as [" + idLine + "] with PID=" + iPid + " on [" + tsiHost + "]";
                    job.getExecutionContext().setPreferredExecutionHost(tsiHost);
                    initialState = "RUNNING";
                }
                job.setBSID(internalID);
                BSSInfo newJob = new BSSInfo(internalID, job.getUUID(), initialState);
                this.bssInfo.put(internalID, newJob);
            }
            jobExecLogger.debug((Object)msg);
            job.addLogTrace(msg);
        }
        catch (Exception ex) {
            jobExecLogger.error((Object)"Error submitting job.", (Throwable)ex);
            throw new ExecutionException(ex);
        }
    }

    private String readPID(Action job, String preferredTSINode) throws IOException, ExecutionException {
        TSI tsi = this.configuration.getTargetSystemInterface(job.getClient(), preferredTSINode);
        ExecutionContext ec = job.getExecutionContext();
        String pidFile = ec.getOutcomeDirectory() + "/" + ec.getPIDFileName();
        jobExecLogger.debug((Object)("Reading PID from " + pidFile));
        return IOUtils.readTSIFile(tsi, pidFile, 1024).trim();
    }

    @Override
    public void updateStatus(Action job) throws ExecutionException {
        block25: {
            try {
                Integer exitCode;
                String status;
                String bssID = job.getBSID();
                String jobID = job.getUUID();
                if (bssID == null) {
                    throw new Exception("Status check can't be done: action with ID " + job.getUUID() + " does not have a batch system ID.");
                }
                BSSInfo info = this.bssInfo.get(bssID);
                String string = status = info != null ? info.bssState : null;
                if (jobExecLogger.isDebugEnabled()) {
                    jobExecLogger.debug((Object)("Action with bssid=" + bssID + " is " + status));
                }
                if ("QUEUED".equals(status)) {
                    job.setStatus(22);
                } else if ("RUNNING".equals(status)) {
                    this.updateProgress(job);
                    job.setStatus(5);
                } else if ("UNKNOWN".equals(status) || status == null) {
                    boolean haveExitCode = this.getExitCode(job);
                    if (!haveExitCode) {
                        if (!this.hasGracePeriodPassed(job)) {
                            if (jobExecLogger.isDebugEnabled()) {
                                jobExecLogger.debug((Object)("Waiting for " + jobID + " BSS id=" + bssID + " to finish and write exit code file."));
                            }
                            this.bssInfo.put(bssID, new BSSInfo(bssID, jobID, "UNKNOWN"));
                        } else {
                            if (jobExecLogger.isDebugEnabled()) {
                                jobExecLogger.debug((Object)("Assuming job " + jobID + " BSS id =" + bssID + " is completed."));
                            }
                            status = "COMPLETED";
                        }
                    } else {
                        if (jobExecLogger.isDebugEnabled()) {
                            jobExecLogger.debug((Object)("Have exit code for " + jobID + ", assuming it is completed."));
                        }
                        status = "COMPLETED";
                    }
                }
                if (!"COMPLETED".equals(status)) break block25;
                if (job.getExecutionContext().getExitCode() == null) {
                    this.getExitCode(job);
                }
                if ((exitCode = job.getExecutionContext().getExitCode()) != null) {
                    job.addLogTrace("Job completed on BSS.");
                    job.setStatus(6);
                    this.bssInfo.remove(bssID);
                    break block25;
                }
                this.bssInfo.put(bssID, new BSSInfo(bssID, jobID, "UNKNOWN"));
                if (job.getProcessingContext().get("CLASSICTSI.statusupdate.exitcode.recheck") == null) {
                    int timeout;
                    job.getProcessingContext().put("CLASSICTSI.statusupdate.exitcode.recheck", Boolean.TRUE);
                    try {
                        timeout = Integer.parseInt(this.configuration.getIDB().getProperty("XNJS.staging.filesystem.grace"));
                    }
                    catch (Exception e) {
                        timeout = 10;
                    }
                    job.getProcessingContext().put("CLASSICTSI.statusupdate.grace.custom", timeout *= 1000);
                    job.getProcessingContext().put("CLASSICTSI.statusupdate.grace.start", System.currentTimeMillis());
                    job.setDirty();
                    jobExecLogger.debug((Object)("Will allow job " + jobID + " a grace period of " + timeout + " millis for exit code file."));
                    break block25;
                }
                if (!this.hasGracePeriodPassed(job)) break block25;
                if (!job.getExecutionContext().isInteractive()) {
                    try {
                        String details = this.getBSSJobDetails(job);
                        job.addLogTrace("Detailed job information from batch system: " + details);
                    }
                    catch (ExecutionException ee) {
                        // empty catch block
                    }
                    job.fail("Job did not complete normally on BSS, please check standard error file and job log for more information.");
                } else {
                    job.fail("Execution was not completed (no exit code file found), please check standard error file <" + job.getExecutionContext().getStderr() + ">");
                }
                this.bssInfo.remove(bssID);
            }
            catch (Exception ex) {
                jobExecLogger.error((Object)"Error updating job status.", (Throwable)ex);
                throw new ExecutionException(ex);
            }
        }
    }

    private boolean hasGracePeriodPassed(Action job) {
        Integer g;
        int myGracePeriod = this.gracePeriod;
        Long timeOfFirstStatusCheck = (Long)job.getProcessingContext().get("CLASSICTSI.statusupdate.grace.start");
        if (timeOfFirstStatusCheck == null) {
            timeOfFirstStatusCheck = System.currentTimeMillis();
            job.getProcessingContext().put("CLASSICTSI.statusupdate.grace.start", timeOfFirstStatusCheck);
            job.setDirty();
        }
        if ((g = (Integer)job.getProcessingContext().get("CLASSICTSI.statusupdate.grace.custom")) != null) {
            myGracePeriod = g;
        }
        return System.currentTimeMillis() > timeOfFirstStatusCheck + (long)myGracePeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBSSStates() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            TSIConnection conn = null;
            try {
                conn = this.factory.getTSIConnection(this.factory.getBSSUser(), "NONE");
                String res = conn.send(TSIUtils.makeStatusCommand());
                if (this.tsiLog.isDebugEnabled()) {
                    this.tsiLog.debug((Object)("BSS Status listing: \n" + res));
                }
                ArrayList<String> pids = new ArrayList<String>();
                for (String tsiNode : this.factory.getTSIHosts()) {
                    pids.addAll(this.getProcessList(tsiNode));
                }
                this.summary = TSIUtils.updateStatusListing(this.bssInfo, res, pids, this.configuration.getInternalManager());
            }
            finally {
                if (conn != null) {
                    conn.done();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getProcessList(String tsiNode) throws IOException, TSIUnavailableException {
        HashSet<String> result = new HashSet<String>();
        TSIConnection conn = null;
        try {
            conn = this.factory.getTSIConnection(this.factory.getBSSUser(), "NONE");
            String script = this.configuration.getIDB().getProperty(CLASSICTSI_PS, CLASSICTSI_PS_DEFAULT);
            String res = conn.send(TSIUtils.makeExecuteScript(script, null, this.configuration));
            if (res == null || !res.startsWith("TSI_OK")) {
                // empty if block
            }
            if (this.tsiLog.isDebugEnabled()) {
                this.tsiLog.debug((Object)("Process listing on [" + tsiNode + "]: \n" + res));
            }
            BufferedReader br = new BufferedReader(new StringReader(res.trim() + "\n"));
            String line = null;
            while ((line = br.readLine()) != null) {
                Matcher m = psPattern.matcher(line);
                if (!m.matches()) continue;
                result.add("INTERACTIVE_" + tsiNode + "_" + String.valueOf(m.group(1)));
            }
            HashSet<String> hashSet = result;
            return hashSet;
        }
        finally {
            if (conn != null) {
                conn.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort(Action job) throws ExecutionException {
        block8: {
            String bssid = job.getBSID();
            if (bssid == null) {
                throw new IllegalArgumentException("Can't abort: no batch system ID.");
            }
            try {
                String status = null;
                this.updateBSSStates();
                BSSInfo info = this.bssInfo.get(bssid);
                String string = status = info != null ? info.bssState : null;
                if (status == null) break block8;
                jobExecLogger.debug((Object)("Aborting job <" + bssid + "> on legacy TSI"));
                TSIConnection conn = null;
                try {
                    conn = this.configuration.getComponentInstanceOfType(TSIConnectionFactory.class).getTSIConnection(job.getClient());
                    String res = conn.send(TSIUtils.makeAbortCommand(bssid));
                    if (!res.contains("TSI_OK")) {
                        throw new Exception("Abort job on TSI failed.");
                    }
                }
                finally {
                    if (conn != null) {
                        conn.done();
                    }
                }
            }
            catch (Exception ex) {
                jobExecLogger.error((Object)"Error aborting.", (Throwable)ex);
                throw new ExecutionException(ex);
            }
        }
    }

    @Override
    public int getNumberOfQueuedJobs() {
        return this.summary.queued;
    }

    @Override
    public int getNumberOfRunningJobs() {
        return this.summary.running;
    }

    @Override
    public int getTotalNumberOfJobs() {
        return this.summary.total;
    }

    @Override
    public Map<String, Integer> getQueueFill() {
        return this.summary.queueFilling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause(Action job) throws ExecutionException {
        block8: {
            String bssid = job.getBSID();
            if (bssid == null) {
                throw new IllegalArgumentException("Can't abort: no batch system ID.");
            }
            try {
                String status = null;
                this.updateBSSStates();
                BSSInfo info = this.bssInfo.get(bssid);
                String string = status = info != null ? info.bssState : null;
                if (status == null) break block8;
                jobExecLogger.debug((Object)("Pausing job <" + bssid + "> on legacy TSI."));
                TSIConnection conn = null;
                try {
                    conn = this.configuration.getComponentInstanceOfType(TSIConnectionFactory.class).getTSIConnection(job.getClient());
                    String res = conn.send(TSIUtils.makePauseCommand(bssid));
                    if (!res.contains("TSI_OK")) {
                        throw new Exception("Pause job on TSI failed.");
                    }
                }
                finally {
                    if (conn != null) {
                        conn.done();
                    }
                }
            }
            catch (Exception e) {
                jobExecLogger.error((Object)"Error pausing.", (Throwable)e);
                throw new ExecutionException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume(Action job) throws ExecutionException {
        block8: {
            String bssid = job.getBSID();
            if (bssid == null) {
                throw new IllegalArgumentException("Can't abort: no batch system ID.");
            }
            try {
                String status = null;
                this.updateBSSStates();
                BSSInfo info = this.bssInfo.get(bssid);
                String string = status = info != null ? info.bssState : null;
                if (status == null) break block8;
                jobExecLogger.debug((Object)("Resuming job <" + bssid + "> on legacy TSI."));
                TSIConnection conn = null;
                try {
                    conn = this.configuration.getComponentInstanceOfType(TSIConnectionFactory.class).getTSIConnection(job.getClient());
                    String res = conn.send(TSIUtils.makeResumeCommand(bssid));
                    if (!res.contains("TSI_OK")) {
                        throw new Exception("Resume job on TSI failed.");
                    }
                }
                finally {
                    if (conn != null) {
                        conn.done();
                    }
                }
            }
            catch (Exception e) {
                jobExecLogger.error((Object)"Error resuming.", (Throwable)e);
                throw new ExecutionException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBSSJobDetails(Action job) throws ExecutionException {
        String bssid = job.getBSID();
        if (bssid == null || job.getExecutionContext() != null && job.getExecutionContext().isInteractive()) {
            return "N/A";
        }
        jobExecLogger.debug((Object)("Getting details for job <" + bssid + "> from legacy TSI."));
        TSIConnection conn = null;
        try {
            conn = this.configuration.getComponentInstanceOfType(TSIConnectionFactory.class).getTSIConnection(job.getClient());
            String res = conn.send(TSIUtils.makeGetJobInfoCommand(bssid));
            if (!res.contains("TSI_OK")) {
                throw new Exception("Getting job details on TSI failed: reply was " + res);
            }
            String string = res;
            if (conn != null) {
                conn.done();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (conn != null) {
                    conn.done();
                }
                throw throwable;
            }
            catch (Exception e) {
                jobExecLogger.error((Object)"Error getting job details.", (Throwable)e);
                throw new ExecutionException(e);
            }
        }
    }

    public static class BSSSummary {
        final int running;
        final int queued;
        final int total;
        final Map<String, Integer> queueFilling;

        public BSSSummary(int running, int queued, int total, Map<String, Integer> queueFilling) {
            this.running = running;
            this.queued = queued;
            this.total = total;
            this.queueFilling = queueFilling;
        }

        public BSSSummary() {
            this(0, 0, 0, new HashMap<String, Integer>());
        }

        public String toString() {
            String res = "BSS: running=" + this.running + " queued=" + this.queued + " total=" + this.total;
            if (this.queueFilling.size() > 0) {
                res = res + " queueFill=" + this.queueFilling;
            }
            return res;
        }
    }

    public static class BSSInfo {
        String bssID;
        String jobID;
        String bssState;
        String queue;

        public BSSInfo() {
        }

        public BSSInfo(String bssID, String jobID, String bssState) {
            this.bssID = bssID;
            this.jobID = jobID;
            this.bssState = bssState;
        }

        public String toString() {
            return "BSSID=" + this.bssID + " JOBID=" + this.jobID + " STATUS=" + this.bssState + (this.queue != null ? " QUEUE=" + this.queue : "");
        }
    }
}

