/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.jsdl;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.ActionResult;
import de.fzj.unicore.xnjs.ems.ExecutionContext;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.ems.InternalAction;
import de.fzj.unicore.xnjs.ems.ProcessingContext;
import de.fzj.unicore.xnjs.ems.ProcessingException;
import de.fzj.unicore.xnjs.jsdl.JSDLBaseProcessor;
import de.fzj.unicore.xnjs.jsdl.SweepInstanceProcessor;
import de.fzj.unicore.xnjs.util.LogUtil;
import edu.virginia.vcgr.jsdl.sweep.SweepException;
import edu.virginia.vcgr.jsdl.sweep.SweepListener;
import edu.virginia.vcgr.jsdl.sweep.SweepUtility;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.DataStagingType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.w3c.dom.Node;

public class SweepProcessor
extends JSDLBaseProcessor {
    private static final Logger logger = LogUtil.getLogger("unicore.services.jobexecution", SweepProcessor.class);
    public static final String sweepActionType = "jsdl_parameter_sweep";
    public static final String sweepInstanceType = "JSDL-sweep-instance";
    static final String JOBLIST_KEY = SweepProcessor.class.getName() + "_JobList";
    static final String INITIAL_JOBLIST_KEY = SweepProcessor.class.getName() + "_InitialJobList";

    public SweepProcessor(Configuration configuration) {
        super(configuration);
    }

    @Override
    protected void extractFromJSDL() throws ExecutionException {
    }

    @Override
    protected void handleReady() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Handling READY state for Action " + this.action.getUUID()));
        }
        if (this.configuration.isAutoSubmitToBSS()) {
            this.action.setStatus(21);
        } else {
            if (this.action.getProcessingContext().get("EMS_AUTOSUBMIT") == null) {
                this.action.setWaiting(true);
                return;
            }
            this.action.setStatus(21);
        }
    }

    @Override
    protected void handlePending() throws ProcessingException {
        JobDefinitionDocument job = (JobDefinitionDocument)this.action.getAjd();
        List<String> jobs = this.getOrCreateJobList();
        try {
            MySweepListener sl = new MySweepListener(jobs, 1000);
            SweepUtility.performSweep((Node)job.getDomNode(), (SweepListener)sl);
            this.action.addLogTrace("Added " + jobs.size() + " sweep jobs.");
            ArrayList<String> initialList = new ArrayList<String>();
            initialList.addAll(jobs);
            this.action.getProcessingContext().put(INITIAL_JOBLIST_KEY, initialList);
            this.action.setStatus(2);
        }
        catch (Exception e) {
            throw new ProcessingException("Error performing sweep", e);
        }
        this.action.setStatus(5);
    }

    @Override
    protected void handleRunning() throws ProcessingException {
        List<String> jobs = this.getOrCreateJobList();
        logger.info((Object)("Checking status for " + jobs.size() + " sweep instances."));
        Iterator<String> it = jobs.iterator();
        while (it.hasNext()) {
            try {
                String id = it.next();
                Action a = this.manager.getAction(id);
                if (a != null && 7 != a.getStatus()) continue;
                this.action.addLogTrace("Sweep instance " + a.getUUID() + " is DONE.");
                it.remove();
            }
            catch (Exception e) {
                throw new ProcessingException(e);
            }
        }
        if (jobs.size() == 0) {
            this.action.addLogTrace("All sweep jobs done");
            this.action.setStatus(7);
            this.action.setResult(new ActionResult(3, "Success.", 0));
            logger.info((Object)("Action " + this.action.getUUID() + " SUCCESSFUL."));
        } else {
            this.sleep(3000);
        }
    }

    private List<String> getOrCreateJobList() {
        ArrayList subJobs = (ArrayList)this.action.getProcessingContext().get(JOBLIST_KEY);
        if (subJobs == null) {
            subJobs = new ArrayList();
            this.action.getProcessingContext().put(JOBLIST_KEY, subJobs);
        }
        return subJobs;
    }

    protected void adaptJobDescription(JobDefinitionDocument job, Map<String, Object> params) {
        DataStagingType[] staging = job.getJobDefinition().getJobDescription().getDataStagingArray();
        if (staging != null) {
            for (DataStagingType dst : staging) {
                if (dst.getSource() == null) continue;
                String target = dst.getFileName();
                dst.getSource().setURI("link:../" + target);
            }
        }
    }

    protected String submitChild(JobDefinitionDocument job, Map<String, Object> params) throws Exception {
        InternalAction subAction = new InternalAction();
        subAction.setType(sweepInstanceType);
        subAction.setAjd((Serializable)job);
        subAction.setClient(this.action.getClient());
        ProcessingContext pc = subAction.getProcessingContext();
        pc.put("EMS_AUTOSUBMIT", Boolean.TRUE);
        if (params != null) {
            pc.put(SweepInstanceProcessor.SWEEP_PARAMS_KEY, params);
        }
        pc.put(SweepInstanceProcessor.SWEEP_PARENT_JOB_ID_KEY, this.action.getUUID());
        pc.put(SweepInstanceProcessor.SWEEP_PARENT_JOB_USPACE_KEY, this.action.getExecutionContext().getWorkingDirectory());
        ExecutionContext ec = new ExecutionContext(subAction.getUUID());
        subAction.setExecutionContext(ec);
        String base = this.action.getExecutionContext().getWorkingDirectory();
        String uspace = this.configuration.getExecutionContextMgr().createUSpace(subAction, base);
        ec.setWorkingDirectory(uspace);
        String id = (String)this.manager.addInternalAction(subAction);
        return id;
    }

    class MySweepListener
    implements SweepListener {
        final int limit;
        final List<String> jobIDs;

        public MySweepListener(List<String> jobIDs, int limit) {
            this.limit = limit;
            this.jobIDs = jobIDs;
        }

        public void emitSweepInstance(Node jobNode, Map<String, Object> params) throws SweepException {
            try {
                if (this.jobIDs.size() >= this.limit) {
                    throw new SweepException("Sweep limit of <" + this.limit + "> was exceeded!");
                }
                JobDefinitionDocument job = JobDefinitionDocument.Factory.parse((Node)jobNode);
                SweepProcessor.this.adaptJobDescription(job, params);
                String id = SweepProcessor.this.submitChild(job, params);
                this.jobIDs.add(id);
            }
            catch (Exception ex) {
                throw new SweepException("Can't submit sub job", (Throwable)ex);
            }
        }
    }
}

