/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.jsdl;

import de.fzj.unicore.xnjs.beans.idb.AllowedType;
import de.fzj.unicore.xnjs.beans.idb.ResourceDocument;
import de.fzj.unicore.xnjs.beans.idb.ResourceSettingDocument;
import de.fzj.unicore.xnjs.resources.BaseResource;
import de.fzj.unicore.xnjs.resources.BooleanResource;
import de.fzj.unicore.xnjs.resources.DoubleResource;
import de.fzj.unicore.xnjs.resources.IntResource;
import de.fzj.unicore.xnjs.resources.Resource;
import de.fzj.unicore.xnjs.resources.StringResource;
import de.fzj.unicore.xnjs.resources.ValueListResource;
import de.fzj.unicore.xnjs.util.LogUtil;
import de.fzj.unicore.xnjs.util.XmlBeansUtils;
import edu.virginia.vcgr.jsdl.sweep.SweepUtility;
import eu.unicore.jsdl.extensions.ResourceRequestDocument;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ApplicationDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ApplicationType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.DataStagingType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.EnvironmentType;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.GroupNameDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.POSIXApplicationDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.UserNameDocument;
import org.ggf.schemas.jsdl.x2006.x07.jsdlHpcpa.HPCProfileApplicationDocument;
import org.w3c.dom.Node;

public class JSDLUtils {
    private static final Logger logger = LogUtil.getLogger("unicore.xnjs", JSDLUtils.class);
    public static final QName JSDL_JOBDEFINITION = new QName("http://schemas.ggf.org/jsdl/2005/11/jsdl", "JobDefinition");
    public static final QName JSDL_POSIX_APP = POSIXApplicationDocument.type.getDocumentElementName();
    private static String hpcp_ns = HPCProfileApplicationDocument.type.getDocumentElementName().getNamespaceURI();
    private static String hpcp_ns2 = "http://schemas.ogf.org/jsdl/2006/07/jsdl-hpcpa";
    private static String posix_ns = POSIXApplicationDocument.type.getDocumentElementName().getNamespaceURI();

    private JSDLUtils() {
    }

    public static boolean hasStageIn(JobDefinitionDocument jdd) {
        try {
            DataStagingType[] dst;
            for (DataStagingType d : dst = jdd.getJobDefinition().getJobDescription().getDataStagingArray()) {
                if (d.getSource() == null) continue;
                return true;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return false;
    }

    public static boolean hasStageOut(JobDefinitionDocument jdd) {
        try {
            DataStagingType[] dst;
            for (DataStagingType d : dst = jdd.getJobDefinition().getJobDescription().getDataStagingArray()) {
                if (d.getTarget() == null) continue;
                return true;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return false;
    }

    public static List<DataStagingType> getStageInArrayAsList(JobDefinitionDocument jdd) {
        ArrayList<DataStagingType> v = new ArrayList<DataStagingType>();
        try {
            DataStagingType[] dst;
            for (DataStagingType d : dst = jdd.getJobDefinition().getJobDescription().getDataStagingArray()) {
                JSDLUtils.fix(d);
                if (d.getSource() == null) continue;
                v.add(d);
            }
        }
        catch (Exception ex) {
            return new ArrayList<DataStagingType>();
        }
        return v;
    }

    private static void fix(DataStagingType d) {
        String p;
        try {
            String s = d.getSource().getURI();
            URI source = new URI(s);
            if (source.getScheme() == null) {
                p = s.startsWith("/") ? "" : "/";
                source = new URI("file://" + p + s);
                d.getSource().setURI(source.toString());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String t = d.getTarget().getURI();
            URI target = new URI(t);
            if (target.getScheme() == null) {
                p = t.startsWith("/") ? "" : "/";
                target = new URI("file://" + p + t);
                d.getTarget().setURI(target.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List<DataStagingType> getStageOutArrayAsList(JobDefinitionDocument jdd) {
        ArrayList<DataStagingType> v = new ArrayList<DataStagingType>();
        try {
            DataStagingType[] dst;
            for (DataStagingType d : dst = jdd.getJobDefinition().getJobDescription().getDataStagingArray()) {
                if (d.getTarget() == null) continue;
                v.add(d);
            }
        }
        catch (Exception ex) {
            return new ArrayList<DataStagingType>();
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static POSIXApplicationDocument extractPosixApplication(XmlObject ad) {
        XmlCursor cursor = ad.newCursor();
        if (XmlBeansUtils.skipToElement(cursor, POSIXApplicationDocument.type.getDocumentElementName())) {
            try {
                POSIXApplicationDocument pd;
                POSIXApplicationDocument pOSIXApplicationDocument = pd = POSIXApplicationDocument.Factory.parse((Reader)cursor.newReader());
                return pOSIXApplicationDocument;
            }
            catch (Exception exception) {
            }
            finally {
                if (cursor != null) {
                    cursor.dispose();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HPCProfileApplicationDocument extractHpcpApplication(ApplicationDocument ad) {
        String source = ad.toString().replace(hpcp_ns2, hpcp_ns);
        try {
            ad = ApplicationDocument.Factory.parse((String)source);
        }
        catch (XmlException ex) {
            // empty catch block
        }
        XmlCursor cursor = ad.newCursor();
        QName hQ = HPCProfileApplicationDocument.type.getDocumentElementName();
        if (XmlBeansUtils.skipToElement(cursor, hQ)) {
            try {
                HPCProfileApplicationDocument pd;
                HPCProfileApplicationDocument hPCProfileApplicationDocument = pd = HPCProfileApplicationDocument.Factory.parse((Reader)cursor.newReader());
                return hPCProfileApplicationDocument;
            }
            catch (Exception ex) {
            }
            finally {
                if (cursor != null) {
                    cursor.dispose();
                }
            }
        }
        return null;
    }

    public static POSIXApplicationDocument extractUserApplication(ApplicationDocument ad) {
        POSIXApplicationDocument res = JSDLUtils.extractPosixApplication((XmlObject)ad);
        if (res != null) {
            return res;
        }
        try {
            HPCProfileApplicationDocument hAppDoc = JSDLUtils.extractHpcpApplication(ad);
            if (hAppDoc == null) {
                return null;
            }
            res = POSIXApplicationDocument.Factory.parse((String)hAppDoc.toString().replace(hpcp_ns, posix_ns).replace("HPCProfile", "POSIX"));
            return res;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ApplicationType handleHPCP(ApplicationType app) {
        String hpcpS = app.toString().replace(hpcp_ns2, hpcp_ns);
        if (hpcpS.contains(hpcp_ns) && hpcpS.contains("HPCProfile")) {
            String conv = hpcpS.replace(hpcp_ns, posix_ns).replace("HPCProfile", "POSIX");
            try {
                ApplicationType res = ApplicationType.Factory.parse((String)conv);
                return res;
            }
            catch (Exception ex) {
                return null;
            }
        }
        return app;
    }

    public static String getEnvironmentValue(String name, EnvironmentType[] env) {
        for (EnvironmentType e : env) {
            if (!e.getName().equals(name)) continue;
            return e.getStringValue();
        }
        return null;
    }

    public static ResourceSettingDocument.ResourceSetting[] extractSiteSpecificResources(ResourcesType rt) throws XmlException {
        XmlObject[] res = XmlBeansUtils.extractAnyElements((XmlObject)rt, ResourceSettingDocument.type.getDocumentElementName());
        ResourceSettingDocument.ResourceSetting[] result = new ResourceSettingDocument.ResourceSetting[res.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((ResourceSettingDocument)res[i]).getResourceSetting();
        }
        return result;
    }

    public static List<ResourceDocument> extractResourceSpecification(ResourcesType rt) throws XmlException {
        ArrayList<ResourceDocument> result = new ArrayList<ResourceDocument>();
        XmlObject[] resources = XmlBeansUtils.extractAnyElements((XmlObject)rt, ResourceDocument.type.getDocumentElementName());
        for (int i = 0; i < resources.length; ++i) {
            ResourceDocument r = (ResourceDocument)resources[i];
            if (r.getResource().getType() == null) {
                r.getResource().setType(AllowedType.INT);
            }
            result.add(r);
        }
        XmlObject[] resourceSettings = XmlBeansUtils.extractAnyElements((XmlObject)rt, ResourceSettingDocument.type.getDocumentElementName());
        for (int i = 0; i < resourceSettings.length; ++i) {
            ResourceSettingDocument.ResourceSetting r = ((ResourceSettingDocument)resourceSettings[i]).getResourceSetting();
            try {
                ResourceDocument rd = JSDLUtils.convert(r);
                result.add(rd);
                continue;
            }
            catch (Exception ex) {
                LogUtil.logException("Invalid resource specification in IDB : " + r.getName(), ex, logger);
            }
        }
        return result;
    }

    public static List<ResourceRequestDocument> extractResourceRequest(ResourcesType rt) throws XmlException {
        ArrayList<ResourceRequestDocument> result = new ArrayList<ResourceRequestDocument>();
        XmlObject[] resources = XmlBeansUtils.extractAnyElements((XmlObject)rt, ResourceRequestDocument.type.getDocumentElementName());
        for (int i = 0; i < resources.length; ++i) {
            ResourceRequestDocument r = (ResourceRequestDocument)resources[i];
            result.add(r);
        }
        XmlObject[] resourceSettings = XmlBeansUtils.extractAnyElements((XmlObject)rt, ResourceSettingDocument.type.getDocumentElementName());
        for (int i = 0; i < resourceSettings.length; ++i) {
            ResourceSettingDocument.ResourceSetting r = ((ResourceSettingDocument)resourceSettings[i]).getResourceSetting();
            try {
                ResourceRequestDocument rd = ResourceRequestDocument.Factory.newInstance();
                rd.addNewResourceRequest().setName(r.getName());
                String value = r.getValue().getExactArray(0).getStringValue();
                rd.getResourceRequest().setValue(value);
                result.add(rd);
                continue;
            }
            catch (Exception ex) {
                LogUtil.logException("Invalid resource request : " + r.getName(), ex, logger);
            }
        }
        return result;
    }

    public static ResourceDocument convert(ResourceSettingDocument.ResourceSetting r) {
        ResourceDocument rd = ResourceDocument.Factory.newInstance();
        ResourceDocument.Resource resource = rd.addNewResource();
        resource.setName(r.getName());
        if (r.getName() == null) {
            throw new IllegalArgumentException("Name of resource cannot be null!");
        }
        resource.setDescription(r.getDescription());
        resource.setType(AllowedType.DOUBLE);
        if (r.getValue().getRangeArray().length > 0) {
            double min = r.getValue().getRangeArray()[0].getLowerBound().getDoubleValue();
            resource.setMin(String.valueOf(min));
            double max = r.getValue().getRangeArray()[0].getUpperBound().getDoubleValue();
            resource.setMax(String.valueOf(max));
        }
        try {
            double def = r.getValue().getExactArray()[0].getDoubleValue();
            resource.setDefault(String.valueOf(def));
        }
        catch (Exception ex) {
            // empty catch block
        }
        ResourceSettingDocument rs = ResourceSettingDocument.Factory.newInstance();
        rs.addNewResourceSetting();
        XmlBeansUtils.append(rs, rd);
        return rd;
    }

    public static XmlObject getElement(XmlObject parent, QName qname) throws IOException, XmlException {
        XmlCursor cursor = parent.newCursor();
        if (XmlBeansUtils.skipToElement(cursor, qname)) {
            return XmlObject.Factory.parse((Reader)cursor.newReader());
        }
        cursor.dispose();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractUserName(XmlObject xml) {
        XmlCursor cursor = xml.newCursor();
        try {
            if (XmlBeansUtils.skipToElement(cursor, UserNameDocument.type.getDocumentElementName())) {
                String string = UserNameDocument.Factory.parse((Reader)cursor.newReader()).getUserName().getStringValue();
                return string;
            }
        }
        catch (XmlException e) {
        }
        catch (IOException iOException) {
        }
        finally {
            cursor.dispose();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractUserGroup(XmlObject xml) {
        XmlCursor cursor = xml.newCursor();
        try {
            if (XmlBeansUtils.skipToElement(cursor, GroupNameDocument.type.getDocumentElementName())) {
                String string = GroupNameDocument.Factory.parse((Reader)cursor.newReader()).getGroupName().getStringValue();
                return string;
            }
        }
        catch (XmlException e) {
        }
        catch (IOException iOException) {
        }
        finally {
            cursor.dispose();
        }
        return null;
    }

    public static Resource createResource(ResourceDocument doc) throws Exception {
        BaseResource resource;
        ResourceDocument.Resource res = doc.getResource();
        String name = res.getName();
        String min = res.getMin();
        String max = res.getMax();
        String val = res.getDefault();
        String description = res.getDescription();
        if (name == null || name.trim().equals("")) {
            throw new Exception("name can not be empty");
        }
        if (val == null) {
            throw new Exception("default value must be set");
        }
        AllowedType.Enum type = res.getType();
        if (((Object)((Object)AllowedType.DOUBLE)).equals((Object)type)) {
            Double value = Double.valueOf(val);
            Double minF = min != null ? Double.valueOf(min) : null;
            Double maxF = max != null ? Double.valueOf(max) : null;
            resource = new DoubleResource(name, value, maxF, minF, Resource.Category.OTHER);
        } else if (((Object)((Object)AllowedType.INT)).equals((Object)type)) {
            Integer value = Integer.valueOf(res.getDefault());
            Integer minI = min != null ? Integer.valueOf(min) : null;
            Integer maxI = max != null ? Integer.valueOf(max) : null;
            resource = new IntResource(name, value, maxI, minI, Resource.Category.OTHER);
        } else if (((Object)((Object)AllowedType.STRING)).equals((Object)type)) {
            resource = new StringResource(name, val);
        } else if (((Object)((Object)AllowedType.CHOICE)).equals((Object)type)) {
            String[] values = res.getAllowedValueArray();
            resource = new ValueListResource(name, val, Arrays.asList(values), Resource.Category.OTHER);
        } else if (((Object)((Object)AllowedType.BOOLEAN)).equals((Object)type)) {
            Boolean value = Boolean.valueOf(val);
            resource = new BooleanResource(name, value, Resource.Category.OTHER);
        } else {
            throw new Exception("Unknown type of resource " + name + ": " + (Object)((Object)type));
        }
        if (description != null) {
            resource.setDescription(description);
        }
        return resource;
    }

    public static boolean isOldStyleResourceSetting(ResourceDocument res) throws XmlException, IOException {
        return JSDLUtils.isOldStyleResourceSetting(res.getResource());
    }

    public static boolean isOldStyleResourceSetting(ResourceDocument.Resource res) throws XmlException, IOException {
        return XmlBeansUtils.extractFirstAnyElement((XmlObject)res, ResourceSettingDocument.type.getDocumentElementName()) != null;
    }

    public static long extractDateTime(String spec) throws ParseException {
        String[] s1 = spec.split("[=:]", 2);
        if (s1.length > 0) {
            String dateSpec = s1[1];
            Date date = JSDLUtils.getDateFormat().parse(dateSpec);
            return date.getTime();
        }
        return 0L;
    }

    public static DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    }

    public static boolean hasSweep(JobDefinitionDocument job) throws Exception {
        return SweepUtility.hasSweep((Node)job.getDomNode());
    }
}

