/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.jsdl;

import de.fzj.unicore.xnjs.beans.idb.ResourceDocument;
import de.fzj.unicore.xnjs.jsdl.JSDLUtils;
import de.fzj.unicore.xnjs.legacy.TSIUtils;
import de.fzj.unicore.xnjs.resources.DoubleResource;
import de.fzj.unicore.xnjs.resources.ExclusiveExecutionResource;
import de.fzj.unicore.xnjs.resources.RangeResource;
import de.fzj.unicore.xnjs.resources.ReservationResource;
import de.fzj.unicore.xnjs.resources.Resource;
import de.fzj.unicore.xnjs.resources.ResourceRequest;
import de.fzj.unicore.xnjs.resources.ResourceSet;
import de.fzj.unicore.xnjs.util.LogUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.RangeType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.RangeValueType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;

public class JSDLResourceSet
extends ResourceSet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogUtil.getLogger("unicore.services.jobexecution", JSDLResourceSet.class);
    public static final String MEMORY_PER_NODE = "MemoryPerNode";
    public static final String CPU_TIME = "CPUTime";
    public static final String CPUS_PER_NODE = "CPUsPerNode";
    public static final String TOTAL_CPUS = "TotalCPUs";
    public static final String NODES = "Nodes";
    public static final String RESERVATION_ID = "ReservationID";
    public static final String EXCLUSIVE_EXECUTION = "ExclusiveExecution";
    private final boolean needDefaultValue;
    private static Collection<String> jsdlResourceNames = new HashSet<String>();

    public JSDLResourceSet(ResourcesType source) {
        this(source, false);
    }

    public JSDLResourceSet(ResourcesType source, boolean needDefault) {
        this.needDefaultValue = needDefault;
        if (source != null) {
            this.init(source);
        }
    }

    public JSDLResourceSet() {
        this.needDefaultValue = false;
    }

    @Override
    public JSDLResourceSet copy() {
        JSDLResourceSet copy = new JSDLResourceSet();
        for (Map.Entry e : this.resources.entrySet()) {
            copy.resources.put(e.getKey(), ((Resource)e.getValue()).copy());
        }
        return copy;
    }

    protected void init(ResourcesType source) {
        String reservation;
        DoubleResource r;
        if (source.getIndividualPhysicalMemory() != null && (r = this.createDoubleResource(MEMORY_PER_NODE, source.getIndividualPhysicalMemory(), Resource.Category.MEMORY)) != null) {
            this.resources.put(MEMORY_PER_NODE, r);
        }
        if (source.getIndividualCPUTime() != null && (r = this.createDoubleResource(CPU_TIME, source.getIndividualCPUTime(), Resource.Category.TIME)) != null) {
            this.resources.put(CPU_TIME, r);
        }
        if (source.getIndividualCPUCount() != null && (r = this.createDoubleResource(CPUS_PER_NODE, source.getIndividualCPUCount(), Resource.Category.PROCESSING)) != null) {
            this.resources.put(CPUS_PER_NODE, r);
        }
        if (source.getTotalCPUCount() != null && (r = this.createDoubleResource(TOTAL_CPUS, source.getTotalCPUCount(), Resource.Category.PROCESSING)) != null) {
            this.resources.put(TOTAL_CPUS, r);
        }
        if (source.getTotalResourceCount() != null && (r = this.createDoubleResource(NODES, source.getTotalResourceCount(), Resource.Category.PROCESSING)) != null) {
            this.resources.put(NODES, r);
        }
        if ((reservation = TSIUtils.extractReservationID(source)) != null) {
            this.resources.put(RESERVATION_ID, new ReservationResource(reservation));
        }
        if (source.isSetExclusiveExecution()) {
            this.resources.put(EXCLUSIVE_EXECUTION, new ExclusiveExecutionResource(source.getExclusiveExecution()));
        }
        this.processNonJSDLResources(source);
    }

    protected Float getMemoryPerNode(ResourcesType resources) {
        try {
            if (resources.getIndividualPhysicalMemory() != null && resources.getIndividualPhysicalMemory().getExactArray() != null) {
                Float f = Float.valueOf(resources.getIndividualPhysicalMemory().getExactArray()[0].getStringValue());
                return f;
            }
        }
        catch (Exception e) {
            logger.warn((Object)"IndividualPhysicalMemory (memory per node) setting in IDB: not a float.");
        }
        return null;
    }

    protected Float getCPUTime(ResourcesType resources) {
        try {
            if (resources.getIndividualCPUTime() != null && resources.getIndividualCPUTime().getExactArray().length > 0) {
                Float f = Float.valueOf(resources.getIndividualCPUTime().getExactArray()[0].getStringValue());
                return f;
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Individual cpu time setting in IDB: not a float.");
        }
        return null;
    }

    protected Float getNodes(ResourcesType resources) {
        try {
            if (resources.getTotalResourceCount() != null && resources.getTotalResourceCount().getExactArray().length > 0) {
                Float f = Float.valueOf(resources.getTotalResourceCount().getExactArray()[0].getStringValue());
                return f;
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Total resource count (nodes) setting in IDB: not a float.");
        }
        return null;
    }

    protected Float getCPUsPerNode(ResourcesType resources) {
        try {
            if (resources.getIndividualCPUCount() != null && resources.getIndividualCPUCount().getExactArray().length > 0) {
                Float f = Float.valueOf(resources.getIndividualCPUCount().getExactArray()[0].getStringValue());
                return f;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn((Object)"Individual CPU count (CPUs per nodes) setting in IDB: not a float.");
        }
        return null;
    }

    protected Float getTotalCPUs(ResourcesType resources) {
        try {
            if (resources.getTotalCPUCount() != null && resources.getTotalCPUCount().getExactArray().length > 0) {
                Float f = Float.valueOf(resources.getTotalCPUCount().getExactArray()[0].getStringValue());
                return f;
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Total CPU count setting in IDB: not a float.");
        }
        return null;
    }

    protected void processNonJSDLResources(ResourcesType res) {
        List<ResourceDocument> resources;
        try {
            resources = JSDLUtils.extractResourceSpecification(res);
            for (ResourceDocument rs : resources) {
                this.addResource(rs);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Error parsing site specific resources", (Throwable)e);
        }
        try {
            resources = JSDLUtils.extractResourceRequest(res);
            for (ResourceDocument rs : resources) {
                String name = rs.getResourceRequest().getName();
                String value = rs.getResourceRequest().getValue();
                ResourceRequest rr = new ResourceRequest(name, value);
                this.resourceRequests.add(rr);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Error parsing resource requests", (Throwable)e);
        }
    }

    private void addResource(ResourceDocument rs) throws Exception {
        ResourceDocument.Resource res = rs.getResource();
        Resource resource = JSDLUtils.createResource(rs);
        String name = res.getName();
        this.resources.put(name, resource);
        if (JSDLUtils.isOldStyleResourceSetting(rs)) {
            resource.setCategory(Resource.Category.RANGE_VALUE);
        }
    }

    public Double getDoubleResourceValue(String name) {
        Resource r = this.getResource(name);
        if (r != null) {
            return ((DoubleResource)r).getValue();
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Resource r : this.resources.values()) {
            sb.append(r.toString()).append("\n");
        }
        return sb.toString();
    }

    public DoubleResource createDoubleResource(String name, RangeValueType rvt, Resource.Category category) {
        Double defaultValue;
        Double d = defaultValue = rvt.getExactArray().length > 0 ? Double.valueOf(rvt.getExactArray()[0].getStringValue()) : null;
        if (this.needDefaultValue && defaultValue == null) {
            return null;
        }
        Double lower = null;
        Double upper = null;
        if (rvt.getRangeArray().length > 0) {
            RangeType range = rvt.getRangeArray()[0];
            if (range.getLowerBound() != null) {
                lower = Double.valueOf(range.getLowerBound().getStringValue());
            }
            if (range.getUpperBound() != null) {
                upper = Double.valueOf(range.getUpperBound().getStringValue());
            }
        }
        DoubleResource r = new DoubleResource(name, defaultValue, upper, lower, category);
        return r;
    }

    public static DoubleResource createDoubleResource(String name, double value, Resource.Category category) {
        DoubleResource r = new DoubleResource(name, value, null, null, category);
        return r;
    }

    public static boolean isJSDLResourceName(String resourceName) {
        return jsdlResourceNames.contains(resourceName);
    }

    public List<String> validateDefaults() {
        ArrayList<String> errors = new ArrayList<String>();
        for (Map.Entry e : this.resources.entrySet()) {
            Object o;
            Resource r = (Resource)e.getValue();
            if (r.getValue() == null || r.isInRange(o = r.getValue())) continue;
            String msg = "Resource " + r.getName() + ": default value <" + o + "> is not in the validity range!";
            if (r instanceof RangeResource) {
                r.setStringValue(String.valueOf(((RangeResource)((Object)r)).getLower()));
                msg = msg + " Resetting default to " + r.getStringValue();
            }
            errors.add(msg);
        }
        return errors;
    }

    static {
        jsdlResourceNames.add(MEMORY_PER_NODE);
        jsdlResourceNames.add(TOTAL_CPUS);
        jsdlResourceNames.add(NODES);
        jsdlResourceNames.add(CPUS_PER_NODE);
        jsdlResourceNames.add(CPU_TIME);
    }
}

