/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.jsdl;

import de.fzj.unicore.xnjs.resources.Resource;
import de.fzj.unicore.xnjs.resources.ResourceSet;
import de.fzj.unicore.xnjs.resources.ResourceSetRenderer;
import de.fzj.unicore.xnjs.tsi.ApplicationInfo;
import de.fzj.unicore.xnjs.tsi.ApplicationInfoRenderer;
import de.fzj.unicore.xnjs.util.XmlBeansUtils;
import eu.unicore.jsdl.extensions.ResourceRequestDocument;
import java.util.Iterator;
import java.util.Map;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.EnvironmentType;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.POSIXApplicationDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.POSIXApplicationType;

public class JSDLRenderer
implements ResourceSetRenderer<ResourcesDocument>,
ApplicationInfoRenderer<POSIXApplicationDocument> {
    @Override
    public ResourcesDocument renderResourceRequest(ResourceSet resources) {
        ResourcesDocument doc = ResourcesDocument.Factory.newInstance();
        ResourcesType rt = doc.addNewResources();
        ResourceSet workingCopy = resources.copy();
        Iterator<Resource> iterator = workingCopy.getResources().iterator();
        while (iterator.hasNext()) {
            Resource r = iterator.next();
            if (r.getValue() == null) {
                iterator.remove();
                continue;
            }
            String name = r.getName();
            if ("CPUTime".equals(name)) {
                rt.addNewIndividualCPUTime().addNewExact().setDoubleValue(r.getDoubleValue().doubleValue());
                continue;
            }
            if ("CPUsPerNode".equals(name)) {
                rt.addNewIndividualCPUCount().addNewExact().setDoubleValue(r.getDoubleValue().doubleValue());
                continue;
            }
            if ("MemoryPerNode".equals(name)) {
                rt.addNewIndividualPhysicalMemory().addNewExact().setDoubleValue(r.getDoubleValue().doubleValue());
                continue;
            }
            if ("TotalCPUs".equals(name)) {
                rt.addNewTotalCPUCount().addNewExact().setDoubleValue(r.getDoubleValue().doubleValue());
                continue;
            }
            if ("Nodes".equals(name)) {
                rt.addNewTotalResourceCount().addNewExact().setDoubleValue(r.getDoubleValue().doubleValue());
                continue;
            }
            if ("ReservationID".equals(name)) {
                try {
                    String resID = "<u6rr:ReservationReference xmlns:u6rr=\"http://www.unicore.eu/unicore/xnjs\">" + r.getStringValue() + "</u6rr:ReservationReference>";
                    XmlObject o = XmlObject.Factory.parse((String)resID);
                    XmlBeansUtils.append(o, (XmlObject)doc);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            if ("ExclusiveExecution".equals(name)) {
                rt.setExclusiveExecution(((Boolean)r.getValue()).booleanValue());
                continue;
            }
            ResourceRequestDocument rsd = ResourceRequestDocument.Factory.newInstance();
            rsd.addNewResourceRequest().setName(name);
            String value = r.getStringValue();
            rsd.getResourceRequest().setValue(value);
            XmlBeansUtils.append((XmlObject)rsd, (XmlObject)doc);
        }
        return doc;
    }

    @Override
    public POSIXApplicationDocument render(ApplicationInfo applicationInfo) {
        POSIXApplicationDocument pad = POSIXApplicationDocument.Factory.newInstance();
        POSIXApplicationType pa = pad.addNewPOSIXApplication();
        pa.addNewExecutable().setStringValue(applicationInfo.getExecutable());
        for (String string : applicationInfo.getArguments()) {
            pa.addNewArgument().setStringValue(string);
        }
        for (Map.Entry entry : applicationInfo.getEnvironment().entrySet()) {
            EnvironmentType e = pa.addNewEnvironment();
            e.setName((String)entry.getKey());
            e.setStringValue((String)entry.getValue());
        }
        if (applicationInfo.getStdout() != null) {
            pa.addNewOutput().setStringValue(applicationInfo.getStdout());
        }
        if (applicationInfo.getStderr() != null) {
            pa.addNewError().setStringValue(applicationInfo.getStderr());
        }
        if (applicationInfo.getStdin() != null) {
            pa.addNewInput().setStringValue(applicationInfo.getStdin());
        }
        return pad;
    }
}

