/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.jsdl;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.ems.ProcessingException;
import de.fzj.unicore.xnjs.jsdl.IncarnatedExecutionEnvironment;
import de.fzj.unicore.xnjs.jsdl.Incarnation;
import de.fzj.unicore.xnjs.jsdl.JSDLBaseProcessor;
import de.fzj.unicore.xnjs.jsdl.JSDLParser;
import de.fzj.unicore.xnjs.jsdl.JSDLRenderer;
import de.fzj.unicore.xnjs.jsdl.JSDLUtils;
import de.fzj.unicore.xnjs.resources.Resource;
import de.fzj.unicore.xnjs.resources.ResourceSet;
import de.fzj.unicore.xnjs.resources.StringResource;
import de.fzj.unicore.xnjs.simple.BasicExecution;
import de.fzj.unicore.xnjs.tsi.ApplicationInfo;
import de.fzj.unicore.xnjs.util.XmlBeansUtils;
import eu.unicore.security.Client;
import java.io.Serializable;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ApplicationDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ApplicationType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobIdentificationType;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.POSIXApplicationDocument;

public class JSDLProcessor
extends JSDLBaseProcessor {
    public JSDLProcessor(Configuration config) {
        super(config);
    }

    @Override
    protected void handleCreated() throws ProcessingException {
        try {
            if (JSDLUtils.hasSweep((JobDefinitionDocument)this.getJobDescriptionDocument())) {
                this.action.setType("jsdl_parameter_sweep");
                this.action.addLogTrace("This is a JSDL ParameterSweep job, changing type to 'jsdl_parameter_sweep'");
            } else {
                super.handleCreated();
            }
        }
        catch (Exception ex) {
            throw new ProcessingException(ex);
        }
    }

    @Override
    protected void extractFromJSDL() throws ExecutionException {
        Incarnation grounder = this.configuration.getGrounder();
        Client client = this.action.getClient();
        this.ecm.getContext(this.action);
        try {
            JobDefinitionDocument jd = (JobDefinitionDocument)this.action.getAjd();
            ApplicationInfo orig = new JSDLParser(this.configuration).parseApplicationInfo(jd);
            ApplicationInfo pa = grounder.incarnateApplication(orig);
            this.action.setApplicationInfo(pa);
            IncarnatedExecutionEnvironment iee = null;
            iee = grounder.incarnateExecutionEnvironment(this.action, client);
            if (iee != null) {
                this.action.addLogTrace("Incarnated execution environment <" + iee.getName() + "> with executable '" + iee.getExecutable() + "'");
            } else {
                iee = IncarnatedExecutionEnvironment.getDefault();
                this.action.addLogTrace("Using default execution environment.");
            }
            this.action.setExecutionEnvironment(iee);
            ResourceSet incarnated = grounder.incarnateResources(this.action, client);
            this.action.getExecutionContext().setResourceRequest(incarnated);
            this.updateExecutionContext(pa, this.action);
            JobIdentificationType ji = jd.getJobDefinition().getJobDescription().getJobIdentification();
            if (ji != null) {
                String jobName = ji.getJobName();
                this.action.setJobName(jobName);
                String[] requestedProjects = ji.getJobProjectArray();
                if (requestedProjects.length > 0) {
                    String project = requestedProjects[0];
                    Resource projectResource = incarnated.getResource("Project");
                    if (projectResource == null) {
                        projectResource = new StringResource("Project", project);
                        incarnated.putResource(projectResource);
                    } else {
                        projectResource.setStringValue(project);
                    }
                }
                if (requestedProjects.length > 1) {
                    this.action.addLogTrace("Warning: extra projects are ignored!");
                }
            }
            ApplicationDocument ad = ApplicationDocument.Factory.newInstance();
            ApplicationType at = ad.addNewApplication();
            POSIXApplicationDocument pad = new JSDLRenderer().render(pa);
            XmlBeansUtils.append((XmlObject)pad, (XmlObject)ad);
            jd.getJobDefinition().getJobDescription().setApplication(at);
            this.action.setAjd((Serializable)jd);
            String email = null;
            try {
                email = JSDLProcessor.extractEmail(jd);
            }
            catch (Exception e) {
                // empty catch block
            }
            Client c = this.action.getClient();
            if (c != null && email != null) {
                c.setUserEmail(email);
            }
            this.action.setDirty();
        }
        catch (Exception e) {
            if (e instanceof ExecutionException) {
                throw (ExecutionException)e;
            }
            throw new ExecutionException(e);
        }
    }

    public static String extractEmail(JobDefinitionDocument jsdl) {
        String[] annotations;
        String email = null;
        if (jsdl.getJobDefinition().getJobDescription().getJobIdentification() != null && (annotations = jsdl.getJobDefinition().getJobDescription().getJobIdentification().getJobAnnotationArray()) != null) {
            String annotation;
            String[] arr$ = annotations;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (email = BasicExecution.getEmailAddress(annotation = arr$[i$])) == null; ++i$) {
            }
        }
        return email;
    }
}

