/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.jsdl;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.DataStageInInfo;
import de.fzj.unicore.xnjs.io.DataStageOutInfo;
import de.fzj.unicore.xnjs.io.DataStagingCredentials;
import de.fzj.unicore.xnjs.io.DataStagingInfoParser;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.simple.UsernamePassword;
import de.fzj.unicore.xnjs.jsdl.HPCPUtils;
import de.fzj.unicore.xnjs.jsdl.IncarnatedExecutionEnvironment;
import de.fzj.unicore.xnjs.jsdl.JSDLUtils;
import de.fzj.unicore.xnjs.tsi.ApplicationInfo;
import de.fzj.unicore.xnjs.tsi.ApplicationInfoParser;
import de.fzj.unicore.xnjs.util.XmlBeansUtils;
import eu.unicore.jsdl.extensions.ArgumentDocument;
import eu.unicore.jsdl.extensions.CmdType;
import eu.unicore.jsdl.extensions.ExecutionEnvironmentDocument;
import eu.unicore.jsdl.extensions.IgnoreFailureDocument;
import eu.unicore.jsdl.extensions.OptionType;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ApplicationDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ApplicationType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.CreationFlagEnumeration;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.DataStagingType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.ArgumentDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.EnvironmentDocument;

public class JSDLParser
implements ApplicationInfoParser<JobDefinitionDocument>,
DataStagingInfoParser<JobDefinitionDocument> {
    private static final String posix_ns = "http://schemas.ggf.org/jsdl/2005/11/jsdl-posix";
    private static final String spmd_ns = "http://schemas.ogf.org/jsdl/2007/02/jsdl-spmd";
    private static QName[] executableQNames = new QName[]{new QName("http://schemas.ggf.org/jsdl/2005/11/jsdl-posix", "Executable")};
    private static QName[] inputQNames = new QName[]{new QName("http://schemas.ggf.org/jsdl/2005/11/jsdl-posix", "Input")};
    private static QName[] outputQNames = new QName[]{new QName("http://schemas.ggf.org/jsdl/2005/11/jsdl-posix", "Output")};
    private static QName[] errorQNames = new QName[]{new QName("http://schemas.ggf.org/jsdl/2005/11/jsdl-posix", "Error")};
    private final Configuration configuration;
    private static final QName SPMD_PROCESSES = new QName("http://schemas.ogf.org/jsdl/2007/02/jsdl-spmd", "NumberOfProcesses");
    private static final QName SPMD_ATTR_PROCESSES = new QName(null, "actualTotalCPUCount");
    private static final QName SPMD_PROCESSES_PER_HOST = new QName("http://schemas.ogf.org/jsdl/2007/02/jsdl-spmd", "ProcessesPerHost");
    private static final QName SPMD_ATTR_THREADS = new QName(null, "actualIndividualCPUCount");
    private static final QName SPMD_THREADS_PER_PROCESS = new QName("http://schemas.ogf.org/jsdl/2007/02/jsdl-spmd", "ThreadsPerProcess");
    private static final QName SPMD_VARIATION = new QName("http://schemas.ogf.org/jsdl/2007/02/jsdl-spmd", "SPMDVariation");

    public JSDLParser(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public ApplicationInfo parseApplicationInfo(JobDefinitionDocument sourceInfo) throws Exception {
        ApplicationType app = sourceInfo.getJobDefinition().getJobDescription().getApplication();
        ApplicationInfo res = new ApplicationInfo();
        if (app != null) {
            ApplicationDocument ad = ApplicationDocument.Factory.newInstance();
            ad.setApplication(app);
            app = JSDLUtils.handleHPCP(app);
            res.setApplicationName(app.getApplicationName());
            res.setApplicationVersion(app.getApplicationVersion());
            res.setApplicationDescription(res.getApplicationDescription());
            res.setExecutable(this.getExecutable(app));
            res.setStdin(this.getInput(app));
            res.setStderr(this.getError(app));
            res.setStdout(this.getOutput(app));
            this.parseArguments(res, app);
            this.parseEnvironment(res, app);
        }
        return res;
    }

    public IncarnatedExecutionEnvironment parseExecutionEnvironmentInfo(JobDefinitionDocument sourceInfo) throws Exception {
        ExecutionEnvironmentDocument.ExecutionEnvironment execEnvRequest = this.parseSPMDExecutionEnvironmentInfo(sourceInfo);
        if (execEnvRequest == null) {
            XmlObject eObj = XmlBeansUtils.extractFirstAnyElement((XmlObject)sourceInfo, ExecutionEnvironmentDocument.type.getDocumentElementName());
            if (eObj == null) {
                return null;
            }
            ExecutionEnvironmentDocument eed = (ExecutionEnvironmentDocument)eObj;
            execEnvRequest = eed.getExecutionEnvironment();
        }
        return this.incarnateExecutionEnvironment(execEnvRequest);
    }

    ExecutionEnvironmentDocument.ExecutionEnvironment parseSPMDExecutionEnvironmentInfo(JobDefinitionDocument sourceInfo) throws Exception {
        String threadsPerProcess;
        String processesPerHost;
        ApplicationType app = sourceInfo.getJobDefinition().getJobDescription().getApplication();
        String spmd = this.getSPMDVariation(app);
        if (spmd == null) {
            return null;
        }
        spmd = spmd.substring(spmd.lastIndexOf("/") + 1);
        ExecutionEnvironmentDocument.ExecutionEnvironment iee = ExecutionEnvironmentDocument.ExecutionEnvironment.Factory.newInstance();
        iee.setName("SPMD-" + spmd);
        String numProcesses = this.getSPMDNumberOfProcesses(app);
        if (numProcesses != null) {
            ArgumentDocument.Argument arg = iee.addNewArgument();
            arg.setName("NumberOfProcesses");
            arg.setValue(numProcesses);
        }
        if ((processesPerHost = this.getSPMDProcessesPerHost(app)) != null) {
            ArgumentDocument.Argument arg = iee.addNewArgument();
            arg.setName("ProcessesPerHost");
            arg.setValue(processesPerHost);
        }
        if ((threadsPerProcess = this.getSPMDThreadsPerProcess(app)) != null) {
            ArgumentDocument.Argument arg = iee.addNewArgument();
            arg.setName("ThreadsPerProcess");
            arg.setValue(threadsPerProcess);
        }
        return iee;
    }

    String getError(ApplicationType app) {
        return XmlBeansUtils.getElementText((XmlObject)app, errorQNames);
    }

    String getExecutable(ApplicationType app) {
        return XmlBeansUtils.getElementText((XmlObject)app, executableQNames);
    }

    String getInput(ApplicationType app) {
        return XmlBeansUtils.getElementText((XmlObject)app, inputQNames);
    }

    String getOutput(ApplicationType app) {
        return XmlBeansUtils.getElementText((XmlObject)app, outputQNames);
    }

    void parseEnvironment(ApplicationInfo appInfo, ApplicationType app) throws Exception {
        List<EnvironmentDocument> env = XmlBeansUtils.extractAnyElements((XmlObject)app, EnvironmentDocument.type.getDocumentElementName(), EnvironmentDocument.class);
        for (EnvironmentDocument e : env) {
            appInfo.getEnvironment().put(e.getEnvironment().getName(), e.getEnvironment().getStringValue());
        }
    }

    void parseArguments(ApplicationInfo appInfo, ApplicationType app) throws Exception {
        List<ArgumentDocument> env = XmlBeansUtils.extractAnyElements((XmlObject)app, ArgumentDocument.type.getDocumentElementName(), ArgumentDocument.class);
        for (ArgumentDocument a : env) {
            appInfo.getArguments().add(a.getArgument().getStringValue());
        }
    }

    protected IncarnatedExecutionEnvironment incarnateExecutionEnvironment(ExecutionEnvironmentDocument.ExecutionEnvironment execEnvRequest) throws ExecutionException {
        boolean login;
        CmdType reqCmd;
        CmdType[] requested;
        String name = execEnvRequest.getName();
        IncarnatedExecutionEnvironment env = new IncarnatedExecutionEnvironment(name);
        ExecutionEnvironmentDocument.ExecutionEnvironment definedExecEnv = this.configuration.getIDB().getExecutionEnvironment(name);
        if (definedExecEnv == null) {
            throw new ExecutionException(31, "The requested execution environmment '" + name + "' does not exist at this site.");
        }
        if (definedExecEnv.getCommandlineTemplate() != null) {
            env.setCommandlineTemplate(definedExecEnv.getCommandlineTemplate());
        }
        env.setExecutable(definedExecEnv.getExecutableName());
        for (ArgumentDocument.Argument argument : definedExecEnv.getArgumentArray()) {
            ArgumentDocument.Argument reqArg = this.getRequestedArgument(argument.getName(), execEnvRequest.getArgumentArray());
            if (reqArg == null) continue;
            env.addArgument(argument.getIncarnatedValue(), reqArg.getValue());
        }
        for (ArgumentDocument.Argument argument : definedExecEnv.getOptionArray()) {
            if (!this.isOptionDefined(argument.getName(), execEnvRequest.getOptionArray())) continue;
            env.addOption(argument.getIncarnatedValue());
        }
        for (ArgumentDocument.Argument argument : definedExecEnv.getPreCommandArray()) {
            requested = execEnvRequest.getPreCommandArray();
            if (this.isCommandDefined(argument.getName(), requested)) {
                reqCmd = requested[this.getCommandIndex(argument.getName(), requested)];
                if (reqCmd.isSetEnabled() && !reqCmd.getEnabled()) continue;
                env.addPreCommand(argument.getIncarnatedValue(), this.createFlags((CmdType)argument));
                continue;
            }
            if (!argument.getEnabledByDefault()) continue;
            env.addPreCommand(argument.getIncarnatedValue(), this.createFlags((CmdType)argument));
        }
        if (!definedExecEnv.getForbidCommandsOnLoginNode() && execEnvRequest.getUserPreCommand() != null) {
            String userPre = execEnvRequest.getUserPreCommand().getStringValue();
            login = execEnvRequest.getUserPreCommand().getRunOnLoginNode();
            env.setUserPreCommand(userPre);
            env.setRunUserPreCommandOnLoginNode(login);
        }
        for (ArgumentDocument.Argument argument : definedExecEnv.getPostCommandArray()) {
            requested = execEnvRequest.getPostCommandArray();
            if (this.isCommandDefined(argument.getName(), requested)) {
                reqCmd = requested[this.getCommandIndex(argument.getName(), requested)];
                if (reqCmd.isSetEnabled() && !reqCmd.getEnabled()) continue;
                env.addPostCommand(argument.getIncarnatedValue(), this.createFlags((CmdType)argument));
                continue;
            }
            if (!argument.getEnabledByDefault()) continue;
            env.addPostCommand(argument.getIncarnatedValue(), this.createFlags((CmdType)argument));
        }
        if (!definedExecEnv.getForbidCommandsOnLoginNode() && execEnvRequest.getUserPostCommand() != null) {
            String userPost = execEnvRequest.getUserPostCommand().getStringValue();
            login = execEnvRequest.getUserPostCommand().getRunOnLoginNode();
            env.setUserPostCommand(userPost);
            env.setRunUserPostCommandOnLoginNode(login);
        }
        if (execEnvRequest.getExecutableName() != null) {
            env.setExecutable(execEnvRequest.getExecutableName());
        }
        return env;
    }

    private int createFlags(CmdType cmd) {
        int flags = 0;
        if (cmd.getRunOnLoginNode()) {
            flags |= 1;
        }
        return flags;
    }

    String getSPMDNumberOfProcesses(ApplicationType app) throws Exception {
        String attr = XmlBeansUtils.getAttributeText((XmlObject)app, SPMD_PROCESSES, SPMD_ATTR_PROCESSES);
        if (Boolean.parseBoolean(attr)) {
            return "${UC_TOTAL_PROCESSORS}";
        }
        return XmlBeansUtils.getElementText((XmlObject)app, SPMD_PROCESSES);
    }

    String getSPMDProcessesPerHost(ApplicationType app) throws Exception {
        return XmlBeansUtils.getElementText((XmlObject)app, SPMD_PROCESSES_PER_HOST);
    }

    String getSPMDThreadsPerProcess(ApplicationType app) throws Exception {
        String attr = XmlBeansUtils.getAttributeText((XmlObject)app, SPMD_THREADS_PER_PROCESS, SPMD_ATTR_THREADS);
        if (Boolean.parseBoolean(attr)) {
            return "${UC_PROCESSORS_PER_NODE}";
        }
        return XmlBeansUtils.getElementText((XmlObject)app, SPMD_THREADS_PER_PROCESS);
    }

    String getSPMDVariation(ApplicationType app) throws Exception {
        return XmlBeansUtils.getElementText((XmlObject)app, SPMD_VARIATION);
    }

    private ArgumentDocument.Argument getRequestedArgument(String name, ArgumentDocument.Argument[] requestedArgs) {
        for (ArgumentDocument.Argument a : requestedArgs) {
            if (!name.equals(a.getName())) continue;
            return a;
        }
        return null;
    }

    private boolean isOptionDefined(String option, OptionType[] request) {
        if (request == null || request.length == 0) {
            return false;
        }
        for (OptionType o : request) {
            if (!o.getName().equals(option)) continue;
            return true;
        }
        return false;
    }

    private boolean isCommandDefined(String cmd, CmdType[] request) {
        return this.getCommandIndex(cmd, request) > 0;
    }

    private int getCommandIndex(String cmd, CmdType[] cmds) {
        if (cmds == null || cmds.length == 0) {
            return -1;
        }
        for (int i = 0; i < cmds.length; ++i) {
            CmdType c = cmds[i];
            if (!c.getName().equals(cmd)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<DataStageInInfo> parseImports(JobDefinitionDocument sourceInfo) throws Exception {
        ArrayList<DataStageInInfo> result = new ArrayList<DataStageInInfo>();
        DataStagingType[] ds = sourceInfo.getJobDefinition().getJobDescription().getDataStagingArray();
        if (ds != null) {
            for (DataStagingType dst : ds) {
                if (!this.isImport(dst)) continue;
                String target = dst.getFileName();
                String fileSystem = dst.getFilesystemName();
                URI source = new URI(dst.getSource().getURI());
                DataStageInInfo dsi = new DataStageInInfo();
                dsi.setOverwritePolicy(this.getOverwritePolicy(dst));
                dsi.setDeleteOnTermination(dst.getDeleteOnTermination());
                dsi.setSources(new URI[]{source});
                dsi.setFileName(target);
                dsi.setFileSystemName(fileSystem);
                dsi.setCredentials(this.extractCredentials(dst));
                dsi.setIgnoreFailure(this.isIgnoreFailure(dst));
                result.add(dsi);
            }
        }
        return result;
    }

    @Override
    public List<DataStageOutInfo> parseExports(JobDefinitionDocument sourceInfo) throws Exception {
        ArrayList<DataStageOutInfo> result = new ArrayList<DataStageOutInfo>();
        DataStagingType[] ds = sourceInfo.getJobDefinition().getJobDescription().getDataStagingArray();
        if (ds != null) {
            for (DataStagingType dst : ds) {
                if (this.isImport(dst)) continue;
                String source = dst.getFileName();
                String fileSystem = dst.getFilesystemName();
                URI target = new URI(dst.getTarget().getURI());
                DataStageOutInfo dsi = new DataStageOutInfo();
                dsi.setOverwritePolicy(this.getOverwritePolicy(dst));
                dsi.setDeleteOnTermination(dst.getDeleteOnTermination());
                dsi.setTarget(target);
                dsi.setFileName(source);
                dsi.setFileSystemName(fileSystem);
                dsi.setCredentials(this.extractCredentials(dst));
                dsi.setIgnoreFailure(this.isIgnoreFailure(dst));
                result.add(dsi);
            }
        }
        return result;
    }

    private boolean isImport(DataStagingType dst) {
        return dst.isSetSource();
    }

    private IFileTransfer.OverwritePolicy getOverwritePolicy(DataStagingType dst) {
        CreationFlagEnumeration.Enum cfe = dst.getCreationFlag();
        if (CreationFlagEnumeration.OVERWRITE.equals(cfe)) {
            return IFileTransfer.OverwritePolicy.OVERWRITE;
        }
        if (CreationFlagEnumeration.APPEND.equals(cfe)) {
            return IFileTransfer.OverwritePolicy.APPEND;
        }
        if (CreationFlagEnumeration.DONT_OVERWRITE.equals(cfe)) {
            return IFileTransfer.OverwritePolicy.DONT_OVERWRITE;
        }
        return IFileTransfer.OverwritePolicy.OVERWRITE;
    }

    protected DataStagingCredentials extractCredentials(DataStagingType dst) {
        UsernamePassword creds = null;
        try {
            creds = HPCPUtils.extractUsernamePassword((XmlObject)dst);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return creds;
    }

    protected boolean isIgnoreFailure(DataStagingType dst) {
        try {
            XmlObject failure = JSDLUtils.getElement((XmlObject)dst, IgnoreFailureDocument.type.getDocumentElementName());
            if (failure != null) {
                return IgnoreFailureDocument.Factory.parse((InputStream)failure.newInputStream()).getIgnoreFailure();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

