/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.jsdl;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.JobProcessor;
import de.fzj.unicore.xnjs.io.DataStageInInfo;
import de.fzj.unicore.xnjs.io.DataStageOutInfo;
import de.fzj.unicore.xnjs.jsdl.JSDLParser;
import de.fzj.unicore.xnjs.jsdl.JSDLUtils;
import de.fzj.unicore.xnjs.util.XmlBeansUtils;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobIdentificationType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobNameDocument;

public abstract class JSDLBaseProcessor
extends JobProcessor<JobDefinitionDocument> {
    public JSDLBaseProcessor(Configuration configuration) {
        super(configuration);
    }

    @Override
    protected boolean isEmptyJob() {
        JobDefinitionDocument jdd = (JobDefinitionDocument)this.getJobDescriptionDocument();
        return jdd == null || jdd.getJobDefinition() == null || jdd.getJobDefinition().getJobDescription() == null;
    }

    @Override
    protected String getJobName() {
        try {
            return XmlBeansUtils.getElementText((XmlObject)this.getJobDescriptionDocument(), JobNameDocument.type.getDocumentElementName());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected List<DataStageInInfo> extractStageInInfo() throws Exception {
        if (this.action.getStageIns() == null) {
            JobDefinitionDocument jd = (JobDefinitionDocument)this.action.getAjd();
            this.action.setStageIns(new JSDLParser(this.configuration).parseImports(jd));
            this.action.setDirty();
        }
        return this.action.getStageIns();
    }

    @Override
    protected List<DataStageOutInfo> extractStageOutInfo() throws Exception {
        if (this.action.getStageOuts() == null) {
            JobDefinitionDocument jd = (JobDefinitionDocument)this.action.getAjd();
            this.action.setStageOuts(new JSDLParser(this.configuration).parseExports(jd));
            this.action.setDirty();
        }
        return this.action.getStageOuts();
    }

    @Override
    protected boolean hasStageIn() {
        return JSDLUtils.hasStageIn((JobDefinitionDocument)this.getJobDescriptionDocument());
    }

    @Override
    protected boolean hasStageOut() {
        return JSDLUtils.hasStageOut((JobDefinitionDocument)this.getJobDescriptionDocument());
    }

    @Override
    protected void extractNotBefore() {
        JobDefinitionDocument jd = (JobDefinitionDocument)this.action.getAjd();
        JobIdentificationType ji = jd.getJobDefinition().getJobDescription().getJobIdentification();
        if (ji != null) {
            for (String s : ji.getJobAnnotationArray()) {
                if (!s.startsWith("notBefore") && !s.startsWith("scheduledStartTime")) continue;
                try {
                    long time = JSDLUtils.extractDateTime(s);
                    this.action.setNotBefore(time);
                }
                catch (Exception ex) {}
                break;
            }
        }
    }
}

