/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.jsdl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IncarnatedExecutionEnvironment
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_CMDLINE = "#EXECUTABLE #ARGS #USERCOMMAND #USERARGS";
    public static final int CMD_FLAG_NONE = 0;
    public static final int CMD_FLAG_RUN_ON_LOGIN_NODE = 1;
    private final String name;
    private final List<String> preCommands;
    private final List<Integer> preCommandFlags;
    private final List<String> postCommands;
    private final List<Integer> postCommandFlags;
    private final List<String> options;
    private final Map<String, String> arguments;
    private String executable;
    private String userCommand;
    private String userCommandArguments = "";
    private String userPreCommand;
    private boolean runUserPreCommandOnLoginNode;
    private String userPostCommand;
    private boolean runUserPostCommandOnLoginNode;
    private String redirectInput;
    private String commandlineTemplate = "#EXECUTABLE #ARGS #USERCOMMAND #USERARGS";

    public IncarnatedExecutionEnvironment(String name) {
        this.name = name;
        this.preCommands = new ArrayList<String>();
        this.preCommandFlags = new ArrayList<Integer>();
        this.postCommands = new ArrayList<String>();
        this.postCommandFlags = new ArrayList<Integer>();
        this.options = new ArrayList<String>();
        this.arguments = new HashMap<String, String>();
    }

    public String getName() {
        return this.name;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public List<String> getPreCommands() {
        return this.preCommands;
    }

    public List<String> getPostCommands() {
        return this.postCommands;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public String getExecutable() {
        return this.executable;
    }

    public int getPreCommandFlags(int cmdIndex) {
        Integer result = this.preCommandFlags.get(cmdIndex);
        return result == null ? 0 : result;
    }

    public int getPostCommandFlags(int cmdIndex) {
        Integer result = this.postCommandFlags.get(cmdIndex);
        return result == null ? 0 : result;
    }

    public String getUserCommand() {
        return this.userCommand;
    }

    public void setUserCommand(String userCommand) {
        this.userCommand = userCommand;
    }

    public String getUserCommandArguments() {
        return this.userCommandArguments;
    }

    public void setUserCommandArguments(String userCommandArguments) {
        this.userCommandArguments = userCommandArguments;
    }

    public void addPreCommand(String preCommand, int flag) {
        this.preCommands.add(preCommand);
        this.preCommandFlags.add(flag);
    }

    public void addPostCommand(String postCommand, int flag) {
        this.postCommands.add(postCommand);
        this.postCommandFlags.add(flag);
    }

    public void addPreCommand(String preCommand) {
        this.addPreCommand(preCommand, 0);
    }

    public void addPostCommand(String postCommand) {
        this.addPostCommand(postCommand, 0);
    }

    public void addOption(String opt) {
        this.options.add(opt);
    }

    public void addArgument(String name, String value) {
        this.arguments.put(name, value);
    }

    public void setUserPreCommand(String cmd) {
        this.userPreCommand = cmd;
    }

    public String getUserPreCommand() {
        return this.userPreCommand;
    }

    public void setUserPostCommand(String cmd) {
        this.userPostCommand = cmd;
    }

    public String getUserPostCommand() {
        return this.userPostCommand;
    }

    public boolean isRunUserPreCommandOnLoginNode() {
        return this.runUserPreCommandOnLoginNode;
    }

    public void setRunUserPreCommandOnLoginNode(boolean runUserPreCommandOnLoginNode) {
        this.runUserPreCommandOnLoginNode = runUserPreCommandOnLoginNode;
    }

    public boolean isRunPreCommandOnLoginNode(int cmdIndex) {
        int flags = this.preCommandFlags.get(cmdIndex);
        return (flags & 1) != 0;
    }

    public boolean isRunPostCommandOnLoginNode(int cmdIndex) {
        int flags = this.postCommandFlags.get(cmdIndex);
        return (flags & 1) != 0;
    }

    public boolean isRunUserPostCommandOnLoginNode() {
        return this.runUserPostCommandOnLoginNode;
    }

    public void setRunUserPostCommandOnLoginNode(boolean runUserPostCommandOnLoginNode) {
        this.runUserPostCommandOnLoginNode = runUserPostCommandOnLoginNode;
    }

    public void setCommandlineTemplate(String commandlineTemplate) {
        this.commandlineTemplate = commandlineTemplate;
    }

    public String getCommandlineTemplate() {
        return this.commandlineTemplate;
    }

    public String getRedirectInput() {
        return this.redirectInput;
    }

    public void setRedirectInput(String redirectInput) {
        this.redirectInput = redirectInput;
    }

    public Map<String, String> getArguments() {
        return this.arguments;
    }

    public void doIncarnate(StringBuilder target) {
        String cmd = this.commandlineTemplate.replace("#EXECUTABLE", this.executable);
        StringBuilder inc = new StringBuilder();
        boolean first = true;
        for (String string : this.options) {
            if (!first) {
                inc.append(" ");
            }
            inc.append(string);
            first = false;
        }
        for (Map.Entry entry : this.arguments.entrySet()) {
            if (!first) {
                inc.append(" ");
            }
            inc.append((String)entry.getKey()).append((String)entry.getValue());
            first = false;
        }
        cmd = inc.length() > 0 ? cmd.replace("#ARGS", inc.toString()) : cmd.replace(" #ARGS", "");
        cmd = cmd.replace("#USERCOMMAND", this.userCommand);
        cmd = cmd.replace("#USERARGS", this.userCommandArguments);
        if (this.redirectInput != null) {
            cmd = cmd + " < " + this.redirectInput;
        }
        cmd = cmd.replaceAll(" +", " ");
        target.append(cmd);
    }

    public void incarnate(StringBuilder target) {
        int i;
        for (i = 0; i < this.preCommands.size(); ++i) {
            String preCommand = this.preCommands.get(i);
            if (this.isRunPreCommandOnLoginNode(i)) continue;
            target.append(preCommand).append("\n");
        }
        if (this.userPreCommand != null && !this.isRunUserPreCommandOnLoginNode()) {
            target.append(this.userPreCommand).append("\n");
        }
        this.doIncarnate(target);
        target.append("\n");
        for (i = 0; i < this.postCommands.size(); ++i) {
            String postCommand = this.postCommands.get(i);
            if (this.isRunPostCommandOnLoginNode(i)) continue;
            target.append(postCommand).append("\n");
        }
        if (this.userPostCommand != null && !this.isRunUserPostCommandOnLoginNode()) {
            target.append(this.userPostCommand).append("\n");
        }
    }

    public static IncarnatedExecutionEnvironment getDefault() {
        IncarnatedExecutionEnvironment res = new IncarnatedExecutionEnvironment("DEFAULT");
        res.setExecutable("");
        return res;
    }
}

