/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.jsdl;

import de.fzj.unicore.xnjs.io.simple.UsernamePassword;
import de.fzj.unicore.xnjs.util.XmlBeansUtils;
import eu.unicore.util.Log;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;

public class HPCPUtils {
    public static final QName AC_QNAME = new QName("http://schemas.ogf.org/hpcp/2007/11/ac", "Credential");
    public static final QName AC_USERNAME = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Username");
    public static final QName AC_PASSWD = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Password");
    public static final QName AC_QNAME_2 = new QName("http://schemas.ogf.org/hpcp/2007/01/fs", "Credential");

    private HPCPUtils() {
    }

    public static UsernamePassword extractUsernamePassword(XmlObject source) {
        String user = null;
        String passwd = null;
        UsernamePassword userNamePassword = null;
        try {
            XmlObject copy = source.copy();
            XmlObject credential = XmlBeansUtils.extractFirstAnyElement(copy, AC_QNAME);
            if (credential == null) {
                credential = XmlBeansUtils.extractFirstAnyElement(copy, AC_QNAME_2);
            }
            if (credential != null) {
                user = HPCPUtils.getUserName(credential);
                passwd = HPCPUtils.getPassword(credential);
                userNamePassword = new UsernamePassword(user, passwd);
            }
        }
        catch (Exception ex) {
            Log.logException((String)"Problem extracting data staging credentials.", (Throwable)ex);
        }
        return userNamePassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUserName(XmlObject credentials) {
        XmlCursor c = credentials.newCursor();
        try {
            int t;
            do {
                if ((t = c.toNextToken().intValue()) != 2) continue;
                String string = null;
                return string;
            } while (t != 3 || !AC_USERNAME.equals(c.getName()));
            while (c.toNextToken().intValue() != 5) {
            }
            String res = c.getChars().trim();
            c.dispose();
            String string = res;
            return string;
        }
        catch (Exception exception) {
        }
        finally {
            if (c != null) {
                c.dispose();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPassword(XmlObject credentials) {
        XmlCursor c = credentials.newCursor();
        try {
            int t;
            do {
                if ((t = c.toNextToken().intValue()) != 2) continue;
                String string = null;
                return string;
            } while (t != 3 || !AC_PASSWD.equals(c.getName()));
            while (c.toNextToken().intValue() != 5) {
            }
            String res = c.getChars().trim();
            c.dispose();
            String string = res;
            return string;
        }
        catch (Exception exception) {
        }
        finally {
            if (c != null) {
                c.dispose();
            }
        }
        return null;
    }
}

