/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.jsdl;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.ExecutionContext;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.jsdl.BaseIDBImpl;
import de.fzj.unicore.xnjs.jsdl.IncarnatedExecutionEnvironment;
import de.fzj.unicore.xnjs.jsdl.Incarnation;
import de.fzj.unicore.xnjs.jsdl.IncarnationDataBase;
import de.fzj.unicore.xnjs.jsdl.JSDLParser;
import de.fzj.unicore.xnjs.jsdl.JSDLResourceSet;
import de.fzj.unicore.xnjs.jsdl.JSDLUtils;
import de.fzj.unicore.xnjs.resources.DoubleResource;
import de.fzj.unicore.xnjs.resources.Resource;
import de.fzj.unicore.xnjs.resources.ResourceRequest;
import de.fzj.unicore.xnjs.resources.ResourceSet;
import de.fzj.unicore.xnjs.resources.ValueListResource;
import de.fzj.unicore.xnjs.tsi.ApplicationInfo;
import de.fzj.unicore.xnjs.tsi.TSI;
import de.fzj.unicore.xnjs.util.ErrorCode;
import de.fzj.unicore.xnjs.util.LogUtil;
import eu.unicore.jsdl.extensions.ArgumentDocument;
import eu.unicore.security.Client;
import eu.unicore.security.Queue;
import eu.unicore.security.Xlogin;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;

public class GrounderImpl
implements Incarnation {
    protected static final Logger logger = LogUtil.getLogger("unicore.services.jobexecution", GrounderImpl.class);
    protected final IncarnationDataBase idb;
    protected final JSDLParser jsdlParser;
    protected final Configuration configuration;
    public static final String PROPERTY_ALLOW_USER_EXECUTABLE = "xnjs.jobExecution.allowUserExecutable";

    public GrounderImpl(Configuration config) {
        this.configuration = config;
        this.idb = this.configuration.getComponentInstanceOfType(IncarnationDataBase.class);
        this.jsdlParser = new JSDLParser(config);
    }

    @Override
    public ApplicationInfo incarnateApplication(ApplicationInfo abstractApplication) throws ExecutionException {
        ApplicationInfo incarnated = null;
        ApplicationInfo result = new ApplicationInfo();
        String appName = abstractApplication.getApplicationName();
        if (appName != null) {
            String version = abstractApplication.getApplicationVersion();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("name: " + appName + ", version: " + version));
            }
            if ((incarnated = this.idb.getApplicationInfo(appName, version)) != null) {
                result = incarnated.clone();
            }
        }
        try {
            this.mergeInfo(result, abstractApplication);
        }
        catch (Exception ex) {
            throw new ExecutionException(ex);
        }
        if (appName != null && incarnated == null && result.getExecutable() == null) {
            throw new ExecutionException(new ErrorCode(20, "Application could not be mapped to an executable."));
        }
        return result;
    }

    @Override
    public String getUserLogin(Client client, Object job) {
        String requestedLogin = JSDLUtils.extractUserName((XmlObject)job);
        Xlogin xlogin = client.getXlogin();
        return xlogin.isValid(requestedLogin) ? requestedLogin : xlogin.getUserName();
    }

    @Override
    public String getUserGroup(Client client, Object job) {
        String requestedGroup = JSDLUtils.extractUserGroup((XmlObject)job);
        Xlogin xlogin = client.getXlogin();
        return xlogin.isValidGroup(requestedGroup) ? requestedGroup : xlogin.getGroup();
    }

    @Override
    public String incarnatePath(String fileName, String fileSystem, ExecutionContext ec, Client client) throws ExecutionException {
        if (fileSystem == null) {
            String g = (ec.getWorkingDirectory() + File.separator + fileName).replaceAll(File.separator + File.separator, File.separator);
            logger.trace((Object)("incarnated: " + fileName + "->" + g));
            return g;
        }
        String base = null;
        TSI tsi = this.configuration.getTargetSystemInterface(client);
        base = "HOME".equalsIgnoreCase(fileSystem) ? tsi.getHomePath() : this.idb.getFilespace(fileSystem);
        if (base == null) {
            base = tsi.getEnvironment(fileSystem);
        }
        if (base == null || base.length() == 0) {
            throw new ExecutionException(new ErrorCode(0, "Filesystem '" + fileSystem + "' not available."));
        }
        String g = base + fileName;
        logger.trace((Object)("incarnated: " + fileName + "->" + g));
        return g;
    }

    protected void mergeInfo(ApplicationInfo incarnated, ApplicationInfo original) throws Exception {
        if (original.getExecutable() != null) {
            boolean allow = Boolean.parseBoolean(this.idb.getProperty(PROPERTY_ALLOW_USER_EXECUTABLE, "true"));
            if (!allow) {
                String msg = "Cannot execute <" + original.getExecutable() + ">. Only Applications may be executed on this site.";
                ErrorCode ec = new ErrorCode(21, msg);
                throw new ExecutionException(ec);
            }
            incarnated.setExecutable(original.getExecutable());
        }
        incarnated.getEnvironment().putAll(original.getEnvironment());
        List<String> argsFromIDB = incarnated.getArguments();
        ArrayList<String> incarnatedArgs = new ArrayList<String>();
        for (String argName : argsFromIDB) {
            if (!argName.endsWith("?")) {
                incarnatedArgs.add(argName);
                continue;
            }
            String env = this.extractArgumentName(argName.substring(0, argName.length() - 1));
            for (Map.Entry<String, String> envFromIDB : incarnated.getEnvironment().entrySet()) {
                String envName = envFromIDB.getKey();
                if (!envName.equals(env)) continue;
                incarnatedArgs.add(argName.substring(0, argName.length() - 1));
            }
        }
        incarnated.setArguments(incarnatedArgs.toArray(new String[incarnatedArgs.size()]));
        for (String arg : original.getArguments()) {
            incarnated.getArguments().add(arg);
        }
        if (original.getStderr() != null) {
            incarnated.setStderr(original.getStderr());
        }
        if (original.getStdin() != null) {
            incarnated.setStdin(original.getStdin());
        }
        if (original.getStdout() != null) {
            incarnated.setStdout(original.getStdout());
        }
    }

    @Override
    public ResourceSet incarnateResources(Action job, Client client) throws ExecutionException {
        JobDefinitionDocument jd = (JobDefinitionDocument)job.getAjd();
        ResourcesType rt = jd.getJobDefinition().getJobDescription().getResources();
        ResourceSet incarnatedResources = this.incarnateResources(rt, client);
        if (incarnatedResources != null) {
            job.addLogTrace("Incarnated resources: " + incarnatedResources.printSelected());
        }
        return incarnatedResources;
    }

    ResourceSet incarnateResources(ResourcesType request, Client c) throws ExecutionException {
        JSDLResourceSet requested = new JSDLResourceSet(request);
        return this.incarnateResources(requested, c);
    }

    private void updateQueueResourceFromClient(Client c, JSDLResourceSet siteDefaults, JSDLResourceSet siteResources) {
        String defQueueFromIDB;
        Resource queueR;
        if (c == null) {
            return;
        }
        Queue q = c.getQueue();
        if (q.getValidQueues().length == 0) {
            return;
        }
        List<String> validQueues = Arrays.asList(q.getValidQueues());
        String preferredFromAS = q.getSelectedQueue();
        if (preferredFromAS == null) {
            preferredFromAS = validQueues.get(0);
        }
        queueR = (queueR = siteDefaults.getResource("Queue")) == null ? new ValueListResource("Queue", preferredFromAS, validQueues, Resource.Category.QUEUE) : (validQueues.contains(defQueueFromIDB = queueR.getStringValue()) && !q.isSelectedQueueSet() ? new ValueListResource("Queue", defQueueFromIDB, validQueues, Resource.Category.QUEUE) : new ValueListResource("Queue", preferredFromAS, validQueues, Resource.Category.QUEUE));
        siteDefaults.putResource(queueR);
        siteResources.putResource(queueR);
    }

    @Override
    public ResourceSet incarnateResources(ResourceSet requested, Client c) throws ExecutionException {
        String name;
        boolean haveCompute = requested.containsResource(Resource.Category.PROCESSING);
        JSDLResourceSet siteDef = ((JSDLResourceSet)this.idb.getSiteDefaultResources()).copy();
        JSDLResourceSet siteResources = ((JSDLResourceSet)this.idb.getSiteResources()).copy();
        this.updateQueueResourceFromClient(c, siteDef, siteResources);
        for (ResourceRequest rr : requested.getResourceRequests()) {
            name = rr.getName();
            Resource resource = siteResources.getResource(name);
            if (resource == null) {
                throw new ExecutionException(new ErrorCode(30, "Resource <" + name + "> is not available at this site."));
            }
            String value = rr.getRequestedValue();
            if (!resource.isInRange(value)) {
                throw new ExecutionException(new ErrorCode(31, "Resource request <" + name + "=" + value + "> is out of range."));
            }
            Resource copy = resource.copy();
            copy.setStringValue(value);
            requested.putResource(copy);
        }
        try {
            for (Resource sr : siteDef.getResources()) {
                if (haveCompute && Resource.Category.PROCESSING.equals((Object)sr.getCategory()) || requested.getResource(name = sr.getName()) != null) continue;
                requested.putResource(sr.copy());
            }
        }
        catch (Exception ex) {
            logger.warn((Object)"Error.", (Throwable)ex);
        }
        this.verifyComputeResourceRequest(requested, siteDef);
        if (!siteResources.checkBounds(requested)) {
            List<String> unmatched = requested.getUnmatchedResourceNames();
            throw new ExecutionException(new ErrorCode(31, "Resource request cannot be fulfilled on this site: " + unmatched));
        }
        return requested;
    }

    protected void verifyComputeResourceRequest(ResourceSet requested, ResourceSet siteDefaults) throws ExecutionException {
        boolean haveCPN;
        boolean haveTotal = requested.getResource("TotalCPUs") != null;
        boolean haveNodes = requested.getResource("Nodes") != null;
        boolean bl = haveCPN = requested.getResource("CPUsPerNode") != null;
        if (haveTotal) {
            int total = ((DoubleResource)requested.getResource("TotalCPUs")).getValue().intValue();
            if (haveNodes && haveCPN) {
                int nodes;
                int cpn = ((DoubleResource)requested.getResource("CPUsPerNode")).getValue().intValue();
                if (total != cpn * (nodes = ((DoubleResource)requested.getResource("Nodes")).getValue().intValue())) {
                    throw new ExecutionException(new ErrorCode(32, "Inconsistent resources requested: total CPUs != nodes * CPUs per node"));
                }
                requested.removeResource("TotalCPUs");
                return;
            }
            if (haveNodes) {
                int nodes = ((DoubleResource)requested.getResource("Nodes")).getValue().intValue();
                int cpn = total / nodes;
                DoubleResource r = new DoubleResource("CPUsPerNode", Double.valueOf(cpn), null, null, Resource.Category.PROCESSING);
                requested.putResource(r);
                requested.removeResource("TotalCPUs");
            } else if (haveCPN) {
                int cpn = ((DoubleResource)requested.getResource("CPUsPerNode")).getValue().intValue();
                int nodes = total / cpn;
                DoubleResource r = new DoubleResource("Nodes", Double.valueOf(nodes), null, null, Resource.Category.PROCESSING);
                requested.putResource(r);
                requested.removeResource("TotalCPUs");
            }
        } else {
            if (haveNodes && !haveCPN) {
                Resource cpn = siteDefaults.getResource("CPUsPerNode");
                if (cpn != null) {
                    requested.putResource(cpn.copy());
                }
                return;
            }
            if (haveCPN && !haveNodes) {
                Resource nodes = siteDefaults.getResource("Nodes");
                if (nodes != null) {
                    requested.putResource(nodes.copy());
                }
                return;
            }
        }
    }

    @Override
    public IncarnatedExecutionEnvironment incarnateExecutionEnvironment(Action job, Client client) throws Exception {
        JobDefinitionDocument jd = (JobDefinitionDocument)job.getAjd();
        return this.jsdlParser.parseExecutionEnvironmentInfo(jd);
    }

    public String extractArgumentName(String argValue) {
        ArgumentDocument.Argument arg = BaseIDBImpl.parseArgument(argValue);
        return arg.getName();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

