/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.jsdl;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.beans.idb.FileSystemDocument;
import de.fzj.unicore.xnjs.beans.idb.IDBApplicationDocument;
import de.fzj.unicore.xnjs.beans.idb.IDBDocument;
import de.fzj.unicore.xnjs.beans.idb.InfoDocument;
import de.fzj.unicore.xnjs.beans.idb.PropertyDocument;
import de.fzj.unicore.xnjs.beans.idb.ResourceDocument;
import de.fzj.unicore.xnjs.beans.idb.ResourceSettingDocument;
import de.fzj.unicore.xnjs.beans.idb.XNJSScriptDocument;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.jsdl.IncarnationDataBase;
import de.fzj.unicore.xnjs.jsdl.JSDLParser;
import de.fzj.unicore.xnjs.jsdl.JSDLResourceSet;
import de.fzj.unicore.xnjs.jsdl.JSDLUtils;
import de.fzj.unicore.xnjs.resources.DoubleResource;
import de.fzj.unicore.xnjs.tsi.ApplicationInfo;
import de.fzj.unicore.xnjs.util.LogUtil;
import de.fzj.unicore.xnjs.util.XmlBeansUtils;
import eu.unicore.jsdl.extensions.AllowedType;
import eu.unicore.jsdl.extensions.ArgumentDocument;
import eu.unicore.jsdl.extensions.ArgumentMetadataDocument;
import eu.unicore.jsdl.extensions.ExecutionEnvironmentDocument;
import eu.unicore.jsdl.extensions.MetadataDocument;
import eu.unicore.jsdl.extensions.ValidValueType;
import eu.unicore.security.Client;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.ArgumentType;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.FileNameType;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.POSIXApplicationType;

public abstract class BaseIDBImpl
implements IncarnationDataBase {
    private static final String UNIX_VAR = "\\$\\{?(\\w+)\\}?";
    private static final String WIN_VAR = "%(\\w+?)%";
    private static final String VAR = "\\$\\{?(\\w+)\\}?|%(\\w+?)%";
    private static final Pattern ARG_PATTERN = Pattern.compile("\\s?(.*?)(\\$\\{?(\\w+)\\}?|%(\\w+?)%)(.*?)\\s*", 32);
    protected static final Logger logger = LogUtil.getLogger("unicore.services.jobexecution", BaseIDBImpl.class);
    protected Map<String, ApplicationInfo> idb;
    protected Map<String, String> filespaces;
    protected ResourcesType resources;
    protected Map<String, String> textInfoProperties;
    protected Map<String, String> scripts;
    protected Map<String, ResourceDocument> siteSpecificResources;
    protected Map<String, ExecutionEnvironmentDocument.ExecutionEnvironment> executionEnvironments;
    protected String submitTemplate;
    protected String executeTemplate;
    protected String queueName;
    protected Properties properties = new Properties();
    protected JSDLResourceSet siteDefaultResourceSet;
    protected JSDLResourceSet siteResourceSet;
    protected JSDLParser jsdlParser;
    protected final Configuration configuration;
    public static final String PROPERTY_ALLOW_USER_EXECUTABLE = "xnjs.jobExecution.allowUserExecutable";

    public BaseIDBImpl(Configuration configuration) {
        this.configuration = configuration;
        this.idb = Collections.synchronizedMap(new HashMap());
        this.filespaces = Collections.synchronizedMap(new HashMap());
        this.textInfoProperties = new HashMap<String, String>();
        this.scripts = new HashMap<String, String>();
        this.siteSpecificResources = new HashMap<String, ResourceDocument>();
        this.executionEnvironments = new HashMap<String, ExecutionEnvironmentDocument.ExecutionEnvironment>();
        this.jsdlParser = new JSDLParser(configuration);
        this.addDefaults();
    }

    @Override
    public ResourcesType listResources(Client c) throws ExecutionException {
        this.doCheckAndUpdateIDB();
        return this.resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDefinedApplications() {
        Map<String, ApplicationInfo> map = this.idb;
        synchronized (map) {
            this.doCheckAndUpdateIDB();
            return this.idb.keySet().toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationInfo[] getDefinedApplicationTypes() {
        Map<String, ApplicationInfo> map = this.idb;
        synchronized (map) {
            this.doCheckAndUpdateIDB();
            return this.idb.values().toArray(new ApplicationInfo[0]);
        }
    }

    @Override
    public ApplicationInfo getApplicationInfo(String name, String version) {
        this.doCheckAndUpdateIDB();
        ApplicationInfo result = null;
        if (name != null) {
            if (version != null) {
                String key = name + "<" + version + ">";
                result = this.idb.get(key);
            } else {
                String key = name + "<";
                for (Map.Entry<String, ApplicationInfo> entry : this.idb.entrySet()) {
                    if (!entry.getKey().startsWith(key)) continue;
                    result = entry.getValue();
                }
            }
        }
        return result != null ? result.clone() : result;
    }

    @Override
    public String getTextInfo(String name) {
        this.doCheckAndUpdateIDB();
        return this.textInfoProperties.get(name);
    }

    @Override
    public Map<String, String> getTextInfoProperties() {
        this.doCheckAndUpdateIDB();
        return this.textInfoProperties;
    }

    @Override
    public String getSubmitTemplate() {
        this.doCheckAndUpdateIDB();
        return this.submitTemplate;
    }

    @Override
    public String getExecuteTemplate() {
        this.doCheckAndUpdateIDB();
        return this.executeTemplate;
    }

    public void setExecuteTemplate(String template) {
        this.doCheckAndUpdateIDB();
        this.executeTemplate = template;
    }

    @Override
    public String getScript(String name) {
        this.doCheckAndUpdateIDB();
        return this.scripts.get(name);
    }

    @Override
    public Map<String, String> getScripts() {
        this.doCheckAndUpdateIDB();
        return this.scripts;
    }

    @Override
    public Collection<ResourceDocument> getSiteSpecificResourceSettings() {
        this.doCheckAndUpdateIDB();
        return this.siteSpecificResources.values();
    }

    @Override
    public ResourceDocument getSiteSpecificResource(String name) {
        this.doCheckAndUpdateIDB();
        return this.siteSpecificResources.get(name);
    }

    @Override
    public String[] getSiteSpecificResourceNames() {
        this.doCheckAndUpdateIDB();
        return this.siteSpecificResources.keySet().toArray(new String[this.siteSpecificResources.size()]);
    }

    @Override
    public ExecutionEnvironmentDocument.ExecutionEnvironment[] getExecutionEnvironments() {
        this.doCheckAndUpdateIDB();
        return this.executionEnvironments.values().toArray(new ExecutionEnvironmentDocument.ExecutionEnvironment[this.executionEnvironments.size()]);
    }

    @Override
    public ExecutionEnvironmentDocument.ExecutionEnvironment getExecutionEnvironment(String name) {
        this.doCheckAndUpdateIDB();
        return this.executionEnvironments.get(name);
    }

    @Override
    public String getQueueName() {
        this.doCheckAndUpdateIDB();
        return this.queueName;
    }

    @Override
    public String getFilespace(String name) {
        this.doCheckAndUpdateIDB();
        return this.filespaces.get(name);
    }

    @Override
    public String[] getFilesystemNames() {
        this.doCheckAndUpdateIDB();
        return this.filespaces.keySet().toArray(new String[this.filespaces.size()]);
    }

    protected abstract void updateIDB() throws Exception;

    protected abstract boolean idbWasModified();

    protected void addDefaults() {
    }

    protected void readIDB(IDBDocument.IDB xmlidb) {
        this.readProperties(xmlidb);
        this.submitTemplate = xmlidb.getSubmitScriptTemplate();
        this.executeTemplate = xmlidb.getExecuteScriptTemplate();
        if (xmlidb.getTargetSystemProperties() != null) {
            this.queueName = xmlidb.getTargetSystemProperties().getQueueName();
            this.resources = xmlidb.getTargetSystemProperties().getResources();
        }
        this.readApplications(xmlidb);
        this.readFileSystems(xmlidb);
        this.readTextInfoProperties(xmlidb);
        this.readXNJSScripts(xmlidb);
        this.readExecutionEnvironments(xmlidb);
        this.readSiteSpecificResources();
        this.buildSiteResourceSet();
        this.buildSiteDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readProperties(IDBDocument.IDB xmlidb) {
        Properties properties = this.properties;
        synchronized (properties) {
            this.properties.clear();
            PropertyDocument.Property[] props = xmlidb.getPropertyArray();
            if (props != null) {
                for (PropertyDocument.Property p : props) {
                    String name = p.getName();
                    String value = p.getValue();
                    this.properties.put(name, value);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readApplications(IDBDocument.IDB xmlidb) {
        Map<String, ApplicationInfo> map = this.idb;
        synchronized (map) {
            IDBApplicationDocument.IDBApplication[] idbapps;
            for (IDBApplicationDocument.IDBApplication a : idbapps = xmlidb.getIDBApplicationArray()) {
                this.addApplication(a);
            }
        }
    }

    protected void addApplication(IDBApplicationDocument.IDBApplication a) {
        String name = a.getApplicationName();
        if (name == null) {
            logger.warn((Object)"Invalid application entry inside the IDB: The application name has not been set.");
            return;
        }
        String version = a.getApplicationVersion();
        if (version == null) {
            logger.warn((Object)("Invalid application entry inside the IDB: The version of application " + name + " has not been set."));
            return;
        }
        POSIXApplicationType pa = a.getPOSIXApplication();
        if (pa == null) {
            logger.warn((Object)("Invalid application entry inside the IDB: The POSIXApplication element for application " + name + "<" + version + "> is missing."));
            return;
        }
        FileNameType executable = pa.getExecutable();
        if (executable == null) {
            logger.warn((Object)("Invalid application entry inside the IDB: The executable for application " + name + "<" + version + "> is missing."));
            return;
        }
        String description = a.getDescription();
        MetadataDocument.Metadata meta = a.getMetadata();
        if (meta == null) {
            meta = MetadataDocument.Metadata.Factory.newInstance();
        }
        this.getMetadataFromPosixApplication(pa, meta);
        ApplicationInfo appInfo = new ApplicationInfo();
        appInfo.setApplicationName(name);
        appInfo.setApplicationVersion(version);
        appInfo.setExecutable(executable.getStringValue());
        appInfo.setApplicationDescription(description);
        if (meta != null) {
            MetadataDocument md = MetadataDocument.Factory.newInstance();
            md.setMetadata((MetadataDocument.Metadata)meta.copy());
            appInfo.setMetadata(md);
        }
        for (ArgumentType argumentType : pa.getArgumentArray()) {
            appInfo.addArgument(argumentType.getStringValue().trim());
        }
        for (ArgumentType argumentType : pa.getEnvironmentArray()) {
            appInfo.getEnvironment().put(argumentType.getName(), argumentType.getStringValue());
        }
        appInfo.setPreCommands(a.getPreCommandArray());
        appInfo.setPostCommands(a.getPostCommandArray());
        appInfo.setBSSNodesFilter(a.getBSSNodesFilterArray());
        if (a.isSetPreferInteractive() && a.getPreferInteractive()) {
            appInfo.getEnvironment().put("UC_PREFER_INTERACTIVE_EXECUTION", "true");
        }
        this.idb.put(name + "<" + version + ">", appInfo);
        logger.debug((Object)("Have application " + name + "<" + version + ">" + ", executable is " + pa.getExecutable()));
    }

    protected void getMetadataFromPosixApplication(POSIXApplicationType pa, MetadataDocument.Metadata meta) {
        for (ArgumentType a : pa.getArgumentArray()) {
            String enabled;
            String mandatory;
            String mime;
            String validV;
            String exclV;
            String depV;
            String parsedName;
            String text;
            ArgumentDocument.Argument parsed;
            Map<String, String> map = XmlBeansUtils.extractAttributes((XmlObject)a);
            String type = map.get("Type");
            if (type == null) {
                type = "string";
            }
            if ((parsed = BaseIDBImpl.parseArgument(text = a.getStringValue())) == null || this.hasMetadataForName(meta, parsedName = parsed.getName())) continue;
            ArgumentDocument.Argument arg = meta.addNewArgument();
            arg.setName(parsed.getName());
            arg.setIncarnatedValue(parsed.getIncarnatedValue());
            ArgumentMetadataDocument.ArgumentMetadata argMeta = arg.addNewArgumentMetadata();
            argMeta.setType(AllowedType.Enum.forString((String)type));
            String description = map.get("Description");
            if (description == null) {
                description = map.get("description");
            }
            if (description == null) {
                description = "";
            }
            argMeta.setDescription(description);
            String def = map.get("Default");
            if (def == null) {
                def = map.get("default");
            }
            if (def != null) {
                argMeta.setDefault(def);
            }
            if ((depV = map.get("DependsOn")) == null) {
                depV = map.get("dependsOn");
            }
            if (depV != null) {
                String[] dep = depV.split(" +");
                argMeta.setDependsOnArray(dep);
            }
            if ((exclV = map.get("Excludes")) == null) {
                exclV = map.get("excludes");
            }
            if (exclV != null) {
                String[] excl = exclV.split(" +");
                argMeta.setExcludesArray(excl);
            }
            if ((validV = map.get("ValidValues")) == null) {
                validV = map.get("validValues");
            }
            if (validV != null) {
                String[] valid;
                for (String v : valid = validV.split(" +")) {
                    ValidValueType vvt = argMeta.addNewValidValue();
                    String regexPrefix = "regex:";
                    if (v.startsWith(regexPrefix)) {
                        vvt.setIsRegex(true);
                        v = v.substring(regexPrefix.length());
                    } else {
                        vvt.setIsRegex(false);
                    }
                    vvt.setStringValue(v);
                }
            }
            if ((mime = map.get("MimeType")) == null) {
                mime = map.get("mimeType");
            }
            if (mime != null) {
                argMeta.setMimeType(mime);
            }
            if ((mandatory = map.get("IsMandatory")) == null) {
                mandatory = map.get("isMandatory");
            }
            if (mandatory != null) {
                boolean isMandatory = Boolean.parseBoolean(mandatory);
                argMeta.setIsMandatory(isMandatory);
            }
            if ((enabled = map.get("IsEnabled")) == null) {
                enabled = map.get("isEnabled");
            }
            if (enabled == null) continue;
            boolean isEnabled = Boolean.parseBoolean(enabled);
            argMeta.setIsEnabled(isEnabled);
        }
    }

    private boolean hasMetadataForName(MetadataDocument.Metadata meta, String name) {
        for (ArgumentDocument.Argument arg : meta.getArgumentArray()) {
            if (!name.equals(arg.getName())) continue;
            return true;
        }
        return false;
    }

    public static ArgumentDocument.Argument parseArgument(String text) {
        Matcher m = ARG_PATTERN.matcher(text);
        if (m.matches()) {
            ArgumentDocument.Argument arg = ArgumentDocument.Argument.Factory.newInstance();
            String name = m.group(3) == null ? m.group(4) : m.group(3);
            arg.setName(name);
            arg.setIncarnatedValue(m.group(1));
            return arg;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readFileSystems(IDBDocument.IDB xmlidb) {
        FileSystemDocument.FileSystem[] fs = xmlidb.getTargetSystemProperties().getFileSystemArray();
        Map<String, String> map = this.filespaces;
        synchronized (map) {
            this.filespaces.clear();
            for (FileSystemDocument.FileSystem f : fs) {
                String name = f.getName();
                String path = f.getIncarnatedPath();
                if (name == null || name.equals("") || path == null || path.equals("")) continue;
                path = path.endsWith(File.separator) ? path : path + File.separator;
                this.filespaces.put(name, path);
                logger.debug((Object)("Filesystem <" + name + "> mapped to <" + path + ">"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readTextInfoProperties(IDBDocument.IDB xmlidb) {
        Map<String, String> map = this.textInfoProperties;
        synchronized (map) {
            InfoDocument.Info[] infos;
            this.textInfoProperties.clear();
            for (InfoDocument.Info i : infos = xmlidb.getTargetSystemProperties().getInfoArray()) {
                String name = i.getName();
                String value = i.getStringValue();
                logger.debug((Object)("TextInfo Property: " + name + "='" + value + "'"));
                if (name == null || value == null) continue;
                this.textInfoProperties.put(name.trim(), value.trim());
            }
        }
    }

    protected void readXNJSScripts(IDBDocument.IDB xmlidb) {
        XNJSScriptDocument.XNJSScript[] xscripts;
        for (XNJSScriptDocument.XNJSScript i : xscripts = xmlidb.getXNJSScriptArray()) {
            String name = i.getName();
            String value = i.getStringValue();
            logger.debug((Object)("Loaded XNJSScript: " + name));
            logger.debug((Object)("value: " + value));
            if (name == null || value == null) continue;
            this.scripts.put(name.trim(), value.trim());
        }
    }

    protected void readSiteSpecificResources() {
        String name;
        ResourceDocument rs;
        XmlObject[] res;
        try {
            for (XmlObject o : res = XmlBeansUtils.extractAnyElements((XmlObject)this.resources, ResourceDocument.type.getDocumentElementName())) {
                rs = (ResourceDocument)o;
                name = rs.getResource().getName();
                logger.debug((Object)("Have resource: " + name));
                this.siteSpecificResources.put(name, rs);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error reading (old-style) site specific resources from IDB.", (Throwable)e);
        }
        try {
            for (XmlObject o : res = XmlBeansUtils.extractAnyElements((XmlObject)this.resources, ResourceSettingDocument.type.getDocumentElementName())) {
                rs = JSDLUtils.convert(((ResourceSettingDocument)o).getResourceSetting());
                name = rs.getResource().getName();
                logger.debug((Object)("Have resource: " + name));
                this.siteSpecificResources.put(name, rs);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error reading (old-style) site specific resources from IDB.", (Throwable)e);
        }
    }

    protected void readExecutionEnvironments(IDBDocument.IDB xmlidb) {
        try {
            ExecutionEnvironmentDocument.ExecutionEnvironment[] env;
            for (ExecutionEnvironmentDocument.ExecutionEnvironment e : env = xmlidb.getExecutionEnvironmentArray()) {
                this.executionEnvironments.put(e.getName(), e);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error reading execution environments from IDB.", (Throwable)ex);
        }
    }

    protected synchronized void doCheckAndUpdateIDB() {
        if (this.idbWasModified()) {
            try {
                logger.info((Object)"IDB modified/touched, re-reading...");
                this.updateIDB();
            }
            catch (Exception e) {
                logger.error((Object)"Problems updating IDB...", (Throwable)e);
            }
        }
    }

    protected void buildSiteResourceSet() {
        JSDLResourceSet res = new JSDLResourceSet(this.resources);
        List<String> validationErrors = res.validateDefaults();
        if (validationErrors.size() > 0) {
            logger.error((Object)("ERROR validating site defaults. PLEASE CHECK THE IDB. " + validationErrors));
        }
        this.siteResourceSet = res;
    }

    protected void buildSiteDefaults() {
        boolean haveCPUsPerNode;
        JSDLResourceSet res = new JSDLResourceSet(this.resources, true);
        DoubleResource totalCPUs = (DoubleResource)res.getResource("TotalCPUs");
        boolean haveTotalCPUs = totalCPUs != null && totalCPUs.getValue() != null;
        boolean haveNodes = res.getDoubleResourceValue("Nodes") != null;
        boolean bl = haveCPUsPerNode = res.getDoubleResourceValue("CPUsPerNode") != null;
        if (haveTotalCPUs && haveNodes && haveCPUsPerNode) {
            logger.warn((Object)"Both TotalCPUCount and (TotalResourceCount + IndividualCPUCount) have default ('Exact') values in the IDB! Will use (TotalResourceCount + IndividualCPUCount) as default.");
            res.removeResource("TotalCPUs");
        }
        this.siteDefaultResourceSet = res;
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProperty(String key, String defaultValue) {
        this.doCheckAndUpdateIDB();
        String res = null;
        Properties properties = this.properties;
        synchronized (properties) {
            res = this.properties.getProperty(key);
        }
        if (res == null) {
            res = this.configuration.getProperty(key, defaultValue);
        }
        return res;
    }

    @Override
    public JSDLResourceSet getSiteDefaultResources() {
        this.doCheckAndUpdateIDB();
        return this.siteDefaultResourceSet.copy();
    }

    @Override
    public JSDLResourceSet getSiteResources() {
        this.doCheckAndUpdateIDB();
        return this.siteResourceSet;
    }
}

