/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.io.simple;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.io.DataStagingCredentials;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.IFileTransferCreator;
import de.fzj.unicore.xnjs.io.IFileTransferEngine;
import de.fzj.unicore.xnjs.io.IOCapabilities;
import de.fzj.unicore.xnjs.io.UnsupportedProtocolException;
import de.fzj.unicore.xnjs.util.LogUtil;
import eu.unicore.security.Client;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.log4j.Logger;

public class SimpleFileTransferEngine
implements IFileTransferEngine {
    private static final Logger logger = LogUtil.getLogger("unicore.xnjs.io", SimpleFileTransferEngine.class);
    private final List<IFileTransferCreator> creators;
    private final List<String> protocols;
    private final Configuration configuration;

    public SimpleFileTransferEngine(Configuration configuration) {
        this.configuration = configuration;
        this.creators = new ArrayList<IFileTransferCreator>();
        this.protocols = new ArrayList<String>();
        this.loadExtensions();
    }

    private synchronized void loadExtensions() {
        try {
            ServiceLoader<IOCapabilities> sl = ServiceLoader.load(IOCapabilities.class);
            for (IOCapabilities c : sl) {
                Class<? extends IFileTransferCreator>[] classes = c.getFileTransferCreators();
                if (classes == null || classes.length == 0) {
                    logger.warn((Object)("Plugin definition <" + c.getClass().getName() + "> does not define any file transfers."));
                    continue;
                }
                for (Class<? extends IFileTransferCreator> clazz : classes) {
                    IFileTransferCreator ftc = clazz.getConstructor(Configuration.class).newInstance(this.configuration);
                    this.registerFileTransferCreator(ftc);
                }
            }
            logger.info((Object)("Loaded XNJS data staging protocol support: " + Arrays.toString(this.listProtocols())));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public synchronized IFileTransfer createFileImport(Client client, String workingDirectory, URI source, String target, IFileTransfer.OverwritePolicy overwrite, DataStagingCredentials credentials) throws IOException {
        for (IFileTransferCreator c : this.creators) {
            IFileTransfer f = c.createFileImport(client, workingDirectory, source, target, credentials);
            if (f == null) continue;
            f.setOverwritePolicy(overwrite);
            return f;
        }
        throw new UnsupportedProtocolException("Transfer " + source + "->" + target + " uses unsupported protocol(s)");
    }

    @Override
    public synchronized IFileTransfer createFileExport(Client client, String workingDirectory, String source, URI target, IFileTransfer.OverwritePolicy overwrite, DataStagingCredentials credentials) throws IOException {
        for (IFileTransferCreator c : this.creators) {
            IFileTransfer f = c.createFileExport(client, workingDirectory, source, target, credentials);
            if (f == null) continue;
            f.setOverwritePolicy(overwrite);
            return f;
        }
        throw new UnsupportedProtocolException("Transfer " + source + "->" + target + " uses unsupported protocol(s)");
    }

    @Override
    public synchronized void registerFileTransferCreator(IFileTransferCreator creator) {
        if (!this.creators.contains(creator)) {
            this.creators.add(creator);
            String p = creator.getProtocol();
            if (!this.protocols.contains(p)) {
                this.protocols.add(p);
                logger.debug((Object)("Added <" + creator + "> for protocol " + creator.getProtocol()));
            }
        }
    }

    @Override
    public synchronized String[] listProtocols() {
        return this.protocols.toArray(new String[0]);
    }
}

