/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.io.simple;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.io.DataStagingCredentials;
import de.fzj.unicore.xnjs.io.simple.AsyncFilemover;
import de.fzj.unicore.xnjs.io.simple.UsernamePassword;
import de.fzj.unicore.xnjs.util.IOUtils;
import eu.unicore.security.Client;
import java.net.URI;

public class ScpUpload
extends AsyncFilemover {
    private final UsernamePassword credentials;

    public ScpUpload(Client client, String workingDirectory, String source, URI target, Configuration config, DataStagingCredentials credentials) {
        super(client, workingDirectory, source, target.toString(), config);
        if (credentials != null && !(credentials instanceof UsernamePassword)) {
            throw new IllegalArgumentException("Unsupported credential type <" + credentials.getClass().getName() + ">, only UsernamePassword is supported.");
        }
        this.credentials = (UsernamePassword)credentials;
    }

    @Override
    public final boolean isImport() {
        return false;
    }

    @Override
    public String makeCommandline() throws Exception {
        String scpWrapper = this.configuration.getIDB().getProperty("scp-wrapper.sh", "scp-wrapper.sh");
        String uri = this.target;
        if (this.credentials == null) {
            throw new IllegalArgumentException("Username required for scp");
        }
        uri = IOUtils.makeSCPAddress(uri, this.credentials.getUser());
        StringBuilder sb = new StringBuilder();
        sb.append(scpWrapper).append(" \"").append(this.workingDirectory).append("/").append(this.source).append("\" \"");
        sb.append(uri).append("\"");
        if (this.credentials != null && this.credentials.getPassword() != null) {
            sb.append(" '").append(this.credentials.getPassword()).append("'");
        }
        return sb.toString();
    }

    @Override
    public String getProtocol() {
        return "scp";
    }
}

