/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.io.simple;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.aaa.XNJSSocketFactory;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.simple.AsyncFilemover;
import de.fzj.unicore.xnjs.tsi.TSI;
import de.fzj.unicore.xnjs.util.LogUtil;
import eu.unicore.security.Client;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IPlainClientConfiguration;
import eu.unicore.util.httpclient.ServerHostnameCheckingMode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.Logger;

public class MailtoUpload
extends AsyncFilemover {
    private static final Logger logger = LogUtil.getLogger("unicore.xnjs.io", MailtoUpload.class);
    private String subject = "Result file from your job";
    private String body = "Dear user, please find attached the result file from your job";
    private String address;

    public MailtoUpload(Client client, String workingDirectory, String source, String target, Configuration config) {
        super(client, workingDirectory, source, target, config);
        this.parseMailto();
    }

    private void parseMailto() {
        try {
            String[] queryParts = this.target.split("\\?", 2);
            if (queryParts.length > 1) {
                String reqBody;
                this.address = queryParts[0];
                String query = queryParts[1];
                Map<String, String> headers = this.asMap(query);
                String reqSubject = headers.get("subject");
                if (reqSubject != null) {
                    this.subject = reqSubject;
                }
                if ((reqBody = headers.get("body")) != null) {
                    this.body = reqBody;
                }
            } else {
                this.address = this.target;
            }
        }
        catch (Exception ex) {
            logger.warn((Object)Log.createFaultMessage((String)("Error parsing URL: <" + this.target + ">"), (Throwable)ex));
        }
    }

    private Map<String, String> asMap(String query) {
        String[] headers;
        HashMap<String, String> result = new HashMap<String, String>();
        for (String header : headers = query.split("&")) {
            String[] hs = header.split("=", 2);
            if (hs.length <= 1) continue;
            result.put(hs[0], hs[1]);
        }
        return result;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }

    @Override
    public final boolean isImport() {
        return false;
    }

    @Override
    public void run() {
        if (this.configuration.getIDB().getProperty("mail-wrapper.sh") == null) {
            this.runLocally();
        } else {
            super.run();
        }
    }

    @Override
    public String makeCommandline() {
        String mailCmd = this.configuration.getIDB().getProperty("mail-wrapper.sh");
        return mailCmd + " \"" + this.address + "\" \"" + this.source + "\" " + "\"" + this.subject + "\"";
    }

    public void runLocally() {
        try {
            this.startTime = System.currentTimeMillis();
            logger.info((Object)("Executing " + this.getDescription()));
            this.transferredBytes = 0L;
            this.status = IFileTransfer.Status.RUNNING;
            this.postMail(this.address, this.subject, this.body, "unicorex@do-not-reply", this.source);
            this.status = IFileTransfer.Status.DONE;
            this.reportUsage();
        }
        catch (Exception ex) {
            this.reportFailure("Could not perform staging out via email", ex);
        }
    }

    @Override
    public String getProtocol() {
        return "mailto";
    }

    public void postMail(String to, String subject, String text, String whofrom, final String fileName) throws MessagingException {
        Properties props = new Properties();
        String host = this.configuration.getIDB().getProperty("mail.smtp.host", "localhost");
        String port = this.configuration.getIDB().getProperty("mail.smtp.port", "25");
        props.put("mail.smtp.host", host);
        props.put("mail.smtp.port", port);
        logger.debug((Object)("Sending mail via " + host + ":" + port));
        String user = this.configuration.getIDB().getProperty("mail.smtp.user", null);
        String password = this.configuration.getIDB().getProperty("mail.smtp.password", null);
        Authenticator auth = null;
        if (user != null) {
            auth = new Authenticator(user, password);
        }
        try {
            boolean ssl = Boolean.parseBoolean(this.configuration.getIDB().getProperty("mail.smtp.ssl", "false"));
            if (ssl) {
                props.put("mail.smtp.ssl.enable", "true");
                props.put("mail.smtp.socketFactory.fallback", "false");
                SSLSocketFactory sslSocketFactory = new XNJSSocketFactory(this.configuration).getSSLSocketFactoryForSMTP();
                props.put("mail.smtp.ssl.socketFactory", sslSocketFactory);
                IPlainClientConfiguration clientCfg = this.configuration.getComponentInstanceOfType(IPlainClientConfiguration.class);
                if (clientCfg.getServerHostnameCheckingMode() == ServerHostnameCheckingMode.FAIL) {
                    props.put("mail.smtp.ssl.checkserveridentity", "true");
                } else if (clientCfg.getServerHostnameCheckingMode() == ServerHostnameCheckingMode.WARN) {
                    logger.info((Object)"For SMTP connections the ServerHostnameChecking mode 'WARN' is treated as NONE. Only FAIL is effective.");
                }
            }
        }
        catch (Exception ex) {
            throw new MessagingException("Could not setup SSL", ex);
        }
        Session session = Session.getInstance((Properties)props, (javax.mail.Authenticator)auth);
        session.setDebug(logger.isDebugEnabled());
        MimeMessage message = new MimeMessage(session);
        InternetAddress from = new InternetAddress(whofrom);
        message.setFrom((Address)from);
        message.addRecipients(Message.RecipientType.TO, to);
        message.setSubject(subject);
        MimeBodyPart[] mbp = new MimeBodyPart[2];
        MimeMultipart mp = new MimeMultipart();
        mbp[0] = new MimeBodyPart();
        mbp[0].setText(text);
        mp.addBodyPart((BodyPart)mbp[0]);
        mbp[1] = new MimeBodyPart();
        DataSource fds = new DataSource(){

            public InputStream getInputStream() throws IOException {
                InputStream attachment = null;
                try {
                    if (MailtoUpload.this.storageAdapter == null) {
                        TSI tsi = MailtoUpload.this.configuration.getTargetSystemInterface(MailtoUpload.this.client);
                        tsi.setStorageRoot(MailtoUpload.this.workingDirectory);
                        attachment = tsi.getInputStream(MailtoUpload.this.source);
                    } else {
                        attachment = MailtoUpload.this.storageAdapter.getInputStream(MailtoUpload.this.source);
                    }
                    return attachment;
                }
                catch (ExecutionException e) {
                    throw new IOException(e);
                }
            }

            public OutputStream getOutputStream() throws IOException {
                throw new IOException();
            }

            public String getContentType() {
                return "application/octet-stream";
            }

            public String getName() {
                return fileName;
            }
        };
        mbp[1].setDataHandler(new DataHandler(fds));
        mbp[1].setFileName(fileName);
        mp.addBodyPart((BodyPart)mbp[1]);
        message.setContent((Multipart)mp);
        Transport.send((Message)message);
    }

    private static class Authenticator
    extends javax.mail.Authenticator {
        private final PasswordAuthentication authentication;

        public Authenticator(String user, String password) {
            this.authentication = new PasswordAuthentication(user, password);
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return this.authentication;
        }
    }
}

