/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.io.simple;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.io.DataStagingCredentials;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.http.IConnectionFactory;
import de.fzj.unicore.xnjs.io.simple.AsyncFilemover;
import de.fzj.unicore.xnjs.io.simple.UsernamePassword;
import de.fzj.unicore.xnjs.tsi.TSI;
import de.fzj.unicore.xnjs.util.LogUtil;
import eu.unicore.security.Client;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.log4j.Logger;

public class HTTPFileUpload
extends AsyncFilemover {
    private static final Logger logger = LogUtil.getLogger("unicore.xnjs.io", HTTPFileUpload.class);
    private final UsernamePassword credentials;

    public HTTPFileUpload(Client client, String workingDirectory, String source, String target, Configuration config, DataStagingCredentials credentials) {
        super(client, workingDirectory, source, target, config);
        if (credentials != null && !(credentials instanceof UsernamePassword)) {
            throw new IllegalArgumentException("Unsupported credential type <" + credentials.getClass().getName() + ">, only UsernamePassword is supported.");
        }
        this.credentials = (UsernamePassword)credentials;
    }

    @Override
    public final boolean isImport() {
        return false;
    }

    @Override
    public void run() {
        this.runLocally();
    }

    @Override
    public String makeCommandline() {
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runLocally() {
        InputStream is = null;
        try {
            this.startTime = System.currentTimeMillis();
            logger.info((Object)("Executing " + this.getDescription()));
            this.transferredBytes = 0L;
            if (this.storageAdapter == null) {
                TSI tsi = this.configuration.getTargetSystemInterface(this.client);
                tsi.setStorageRoot(this.workingDirectory);
                is = tsi.getInputStream(this.source);
            } else {
                is = this.storageAdapter.getInputStream(this.source);
            }
            this.status = IFileTransfer.Status.RUNNING;
            IConnectionFactory cf = this.configuration.getComponentInstanceOfType(IConnectionFactory.class);
            PutMethod put = new PutMethod(this.target);
            put.setContentChunked(true);
            put.setRequestEntity((RequestEntity)new InputStreamRequestEntity(is));
            HttpClient httpClient = cf.getConnection(this.target, this.client);
            if (this.credentials != null) {
                UsernamePasswordCredentials httpCreds = new UsernamePasswordCredentials(this.credentials.getUser(), this.credentials.getPassword());
                httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)httpCreds);
            }
            httpClient.executeMethod((HttpMethod)put);
            int code = put.getStatusCode();
            if (code < 200 || code >= 300) {
                throw new Exception("Error performing upload: server returned <" + put.getStatusLine() + ">");
            }
            this.status = IFileTransfer.Status.DONE;
            this.reportUsage();
        }
        catch (Exception ex) {
            this.reportFailure("Could not perform HTTP upload", ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    logger.error((Object)"Error closing stream", (Throwable)ex);
                }
            }
        }
    }

    @Override
    public String getProtocol() {
        return this.target.toLowerCase().startsWith("https") ? "https" : "http";
    }
}

