/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.io.simple;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.io.DataStagingCredentials;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.http.IConnectionFactory;
import de.fzj.unicore.xnjs.io.simple.AsyncFilemover;
import de.fzj.unicore.xnjs.io.simple.UsernamePassword;
import de.fzj.unicore.xnjs.tsi.TSI;
import de.fzj.unicore.xnjs.util.LogUtil;
import eu.unicore.security.Client;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

public class HTTPFileDownload
extends AsyncFilemover {
    private static final Logger logger = LogUtil.getLogger("unicore.xnjs.io", HTTPFileDownload.class);
    private final UsernamePassword credentials;

    public HTTPFileDownload(Client client, String workingDirectory, String source, String target, Configuration config, DataStagingCredentials credentials) {
        super(client, workingDirectory, source, target, config);
        if (credentials != null && !(credentials instanceof UsernamePassword)) {
            throw new IllegalArgumentException("Unsupported credential type <" + credentials.getClass().getName() + ">, only UsernamePassword is supported.");
        }
        this.credentials = (UsernamePassword)credentials;
    }

    @Override
    public final boolean isImport() {
        return true;
    }

    @Override
    public void run() {
        if (this.configuration.getIDB().getProperty("wget") == null) {
            this.runLocally();
        } else {
            super.run();
        }
    }

    @Override
    public String makeCommandline() {
        String wgetCmd = this.configuration.getIDB().getProperty("wget");
        String wgetOpts = this.configuration.getIDB().getProperty("wget.parameters");
        return wgetCmd + (wgetOpts != null ? " " + wgetOpts : "") + " -O " + this.target + " " + this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runLocally() {
        InputStream is = null;
        OutputStream os = null;
        try {
            this.startTime = System.currentTimeMillis();
            logger.info((Object)("Executing " + this.getDescription()));
            this.transferredBytes = 0L;
            is = this.getInputStream(this.source);
            if (this.storageAdapter == null) {
                TSI tsi = this.configuration.getTargetSystemInterface(this.client);
                tsi.setStorageRoot(this.workingDirectory);
                os = tsi.getOutputStream(this.target);
            } else {
                os = this.storageAdapter.getOutputStream(this.target, false);
            }
            this.status = IFileTransfer.Status.RUNNING;
            this.copyTrackingTransferedBytes(is, os);
            is.close();
            os.flush();
            os.close();
            this.status = IFileTransfer.Status.DONE;
            this.reportUsage();
        }
        catch (Exception ex) {
            this.reportFailure("Download failed.", ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    logger.error((Object)"Error closing stream", (Throwable)ex);
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {
                    logger.error((Object)"Error closing stream", (Throwable)ex);
                }
            }
        }
    }

    protected InputStream getInputStream(String url) throws IOException, MalformedURLException {
        IConnectionFactory cf = this.configuration.getComponentInstanceOfType(IConnectionFactory.class);
        if (cf == null) {
            return new URL(this.source).openStream();
        }
        GetMethod g = new GetMethod(this.source);
        HttpClient httpClient = cf.getConnection(this.source, this.client);
        if (this.credentials != null) {
            UsernamePasswordCredentials httpCreds = new UsernamePasswordCredentials(this.credentials.getUser(), this.credentials.getPassword());
            httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)httpCreds);
        }
        httpClient.executeMethod((HttpMethod)g);
        int status = g.getStatusCode();
        if (status < 200 || status >= 300) {
            throw new IOException("Error downloading file, server message: <" + g.getStatusLine() + ">");
        }
        return g.getResponseBodyAsStream();
    }

    @Override
    public String getProtocol() {
        return this.source.toLowerCase().startsWith("https") ? "https" : "http";
    }
}

