/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.io.simple;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.io.simple.AsyncFilemover;
import de.fzj.unicore.xnjs.tsi.TSI;
import de.fzj.unicore.xnjs.util.IOUtils;
import eu.unicore.security.Client;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;

public class GSIFTPDownload
extends AsyncFilemover {
    public static final String GLOBUS_URL_COPY = "globus-url-copy";
    public static final String GLOBUS_URL_COPY_PARAMS = "globus-url-copy.parameters";
    private static final String proxyWriter = "de.fzj.unicore.uas.xnjs.ProxyCertToUspaceProcessor";

    public GSIFTPDownload(Client client, String workingDirectory, URI source, String target, Configuration config) {
        super(client, workingDirectory, source.toASCIIString(), target, config);
    }

    @Override
    public String makeCommandline() {
        String executable = this.configuration.getIDB().getProperty(GLOBUS_URL_COPY, GLOBUS_URL_COPY);
        String params = this.configuration.getIDB().getProperty(GLOBUS_URL_COPY_PARAMS, "");
        File f = new File(this.workingDirectory, this.target);
        URI uri = f.toURI();
        return executable + " " + params + " \"" + this.source + "\" \"" + uri.toASCIIString() + "\"";
    }

    @Override
    public final boolean isImport() {
        return true;
    }

    @Override
    protected void preSubmit() throws Exception {
        GSIFTPDownload.writeProxyIfRequired(this.configuration, this.client, this.workingDirectory);
        this.ach.setEnvironmentVariable("X509_USER_PROXY", ".proxy");
    }

    @Override
    public String getProtocol() {
        return "gsiftp";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeProxyIfRequired(Configuration configuration, Client client, String workingDirectory) throws Exception {
        if (Arrays.asList(configuration.getProcessorChain("JSDL")).contains(proxyWriter)) {
            return;
        }
        String pem = (String)client.getSecurityTokens().getContext().get("Proxy");
        if (pem == null) {
            logger.error((Object)"No proxy cert available in security attributes! Can't execute GSIFTP");
            throw new Exception("No proxy cert available in security attributes! Can't execute GSIFTP");
        }
        TSI tsi = configuration.getTargetSystemInterface(client);
        tsi.setStorageRoot(workingDirectory);
        ByteArrayInputStream is = new ByteArrayInputStream(pem.getBytes());
        OutputStream os = tsi.getOutputStream(".proxy");
        try {
            IOUtils.copy(is, os, Integer.MAX_VALUE);
        }
        finally {
            os.close();
        }
    }
}

