/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.io.simple;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import de.fzj.unicore.xnjs.tsi.TSI;
import eu.unicore.security.Client;
import eu.unicore.util.Log;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;

public class FileCopy
implements IFileTransfer {
    private IFileTransfer.Status status = IFileTransfer.Status.CREATED;
    private String statusMessage = "OK.";
    private final String source;
    private final String target;
    private final String workingDirectory;
    private final String uuid;
    private final Client client;
    private final Configuration configuration;
    private final boolean isImport;
    private String parentActionID;
    private boolean ignoreFailure;

    public FileCopy(Configuration configuration, Client client, String workingDirectory, String source, String target, boolean isImport) {
        this.configuration = configuration;
        this.client = client;
        this.workingDirectory = workingDirectory;
        this.source = source;
        this.target = target;
        this.isImport = isImport;
        this.uuid = UUID.randomUUID().toString();
    }

    @Override
    public String getUniqueId() {
        return this.uuid;
    }

    @Override
    public IFileTransfer.Status getStatus() {
        return this.status;
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Override
    public boolean isStreaming() {
        return false;
    }

    @Override
    public long getTransferredBytes() {
        if (this.status == IFileTransfer.Status.CREATED) {
            return 0L;
        }
        return this.status == IFileTransfer.Status.RUNNING ? 0L : (long)this.target.length();
    }

    @Override
    public long getDataSize() {
        return -1L;
    }

    @Override
    public void run() {
        try {
            this.status = IFileTransfer.Status.RUNNING;
            TSI tsi = this.configuration.getTargetSystemInterface(this.client);
            String s = this.isImport ? this.source : this.workingDirectory + tsi.getFileSeparator() + this.source;
            String t = !this.isImport ? this.target : this.workingDirectory + tsi.getFileSeparator() + this.target;
            this.createParentDirectories(t, tsi);
            tsi.cp(s, t);
            this.status = IFileTransfer.Status.DONE;
        }
        catch (Exception ex) {
            this.status = IFileTransfer.Status.FAILED;
            this.statusMessage = Log.createFaultMessage((String)"File transfer failed", (Throwable)ex);
        }
    }

    private void createParentDirectories(String target, TSI tsi) throws Exception {
        String parent = new File(target).getParent();
        if (parent != null) {
            tsi.mkdir(parent);
        }
    }

    @Override
    public boolean abort() {
        return false;
    }

    @Override
    public Map<String, Serializable> pause() {
        return null;
    }

    @Override
    public void resume(Map<String, Serializable> state) {
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public void setOverwritePolicy(IFileTransfer.OverwritePolicy overwrite) {
    }

    @Override
    public void setStorageAdapter(IStorageAdapter adapter) {
    }

    @Override
    public String getParentActionID() {
        return this.parentActionID;
    }

    @Override
    public void setParentActionID(String actionID) {
        this.parentActionID = actionID;
    }

    @Override
    public String getProtocol() {
        return "file";
    }

    @Override
    public boolean isIgnoreFailure() {
        return this.ignoreFailure;
    }

    @Override
    public void setIgnoreFailure(boolean ignoreFailure) {
        this.ignoreFailure = ignoreFailure;
    }
}

