/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xnjs.io.simple;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.io.DataStagingCredentials;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.simple.AsyncFilemover;
import de.fzj.unicore.xnjs.io.simple.UsernamePassword;
import de.fzj.unicore.xnjs.tsi.TSI;
import de.fzj.unicore.xnjs.util.IOUtils;
import de.fzj.unicore.xnjs.util.LogUtil;
import eu.unicore.security.Client;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.log4j.Logger;

public class FTPUpload
extends AsyncFilemover {
    private static final Logger logger = LogUtil.getLogger("unicore.xnjs.io", FTPUpload.class);
    private final UsernamePassword credentials;

    public FTPUpload(Client client, String workingDirectory, String source, URI target, Configuration config, DataStagingCredentials credentials) {
        super(client, workingDirectory, source, target.toString(), config);
        if (credentials != null && !(credentials instanceof UsernamePassword)) {
            throw new IllegalArgumentException("Unsupported credential type <" + credentials.getClass().getName() + ">, only UsernamePassword is supported.");
        }
        this.credentials = (UsernamePassword)credentials;
    }

    @Override
    public final boolean isImport() {
        return false;
    }

    @Override
    public long getTransferredBytes() {
        if (this.getStatus() == IFileTransfer.Status.CREATED) {
            return 0L;
        }
        return this.getStatus() == IFileTransfer.Status.RUNNING ? 0L : (long)this.source.length();
    }

    @Override
    public String makeCommandline() throws MalformedURLException {
        String curl = this.configuration.getIDB().getProperty("curl", "curl");
        URL url = IOUtils.addFTPCredentials(new URL(this.target), this.credentials);
        StringBuilder sb = new StringBuilder();
        sb.append(curl).append(" -T \"");
        sb.append(this.workingDirectory).append("/").append(this.source).append("\"");
        sb.append(" \"").append(url).append("\"");
        return sb.toString();
    }

    @Override
    public void run() {
        if (this.configuration.getIDB().getProperty("curl") == null) {
            this.runLocally();
        } else {
            super.run();
        }
    }

    public void runLocally() {
        try {
            this.startTime = System.currentTimeMillis();
            logger.info((Object)("Executing " + this.getDescription()));
            URL url = IOUtils.addFTPCredentials(new URL(this.target), this.credentials);
            OutputStream os = url.openConnection().getOutputStream();
            InputStream is = null;
            if (this.storageAdapter == null) {
                TSI tsi = this.configuration.getTargetSystemInterface(this.client);
                tsi.setStorageRoot(this.workingDirectory);
                is = tsi.getInputStream(this.source);
            } else {
                is = this.storageAdapter.getInputStream(this.source);
            }
            this.status = IFileTransfer.Status.RUNNING;
            this.copyTrackingTransferedBytes(is, os);
            is.close();
            os.flush();
            os.close();
            this.status = IFileTransfer.Status.DONE;
            this.reportUsage();
        }
        catch (Exception ex) {
            this.reportFailure("Could not do FTP upload", ex);
        }
    }

    @Override
    public String getProtocol() {
        return "ftp";
    }
}

